/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.util;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.LowLevelLogUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertiesPropertySource;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertyFilePropertySource;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PropertySource;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.ServiceLoaderUtil;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;

public final class PropertiesUtil {
    private static final String LOG4J_PROPERTIES_FILE_NAME = "com.contrastsecurity.thirdparty.log4j2.component.properties";
    private static final String LOG4J_SYSTEM_PROPERTIES_FILE_NAME = "com.contrastsecurity.thirdparty.log4j2.system.properties";
    private static final PropertiesUtil LOG4J_PROPERTIES = new PropertiesUtil("com.contrastsecurity.thirdparty.log4j2.component.properties", false);
    private final Environment environment;

    public PropertiesUtil(Properties properties) {
        this(new PropertiesPropertySource(properties));
    }

    public PropertiesUtil(String string) {
        this(string, true);
    }

    private PropertiesUtil(String string, boolean bl2) {
        this(new PropertyFilePropertySource(string, bl2));
    }

    PropertiesUtil(PropertySource propertySource) {
        this.environment = new Environment(propertySource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadClose(InputStream inputStream, Object object) {
        Properties properties = new Properties();
        if (null != inputStream) {
            try {
                properties.load(inputStream);
            }
            catch (IOException iOException) {
                LowLevelLogUtil.logException("Unable to read " + object, iOException);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    LowLevelLogUtil.logException("Unable to close " + object, iOException);
                }
            }
        }
        return properties;
    }

    public static PropertiesUtil getProperties() {
        return LOG4J_PROPERTIES;
    }

    public void addPropertySource(PropertySource propertySource) {
        if (this.environment != null) {
            this.environment.addPropertySource(propertySource);
        }
    }

    public boolean hasProperty(String string) {
        return this.environment.containsKey(string);
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl2) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? bl2 : "true".equalsIgnoreCase(string2);
    }

    public boolean getBooleanProperty(String string, boolean bl2, boolean bl3) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? bl2 : (string2.isEmpty() ? bl3 : "true".equalsIgnoreCase(string2));
    }

    public Boolean getBooleanProperty(String[] stringArray, String string, Supplier<Boolean> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getBooleanProperty(string2 + string);
        }
        return supplier != null ? supplier.get() : null;
    }

    public Charset getCharsetProperty(String string) {
        return this.getCharsetProperty(string, Charset.defaultCharset());
    }

    public Charset getCharsetProperty(String string, Charset charset) {
        String string2;
        String string3 = this.getStringProperty(string);
        if (string3 == null) {
            return charset;
        }
        if (Charset.isSupported(string3)) {
            return Charset.forName(string3);
        }
        ResourceBundle resourceBundle = PropertiesUtil.getCharsetsResourceBundle();
        if (resourceBundle.containsKey(string) && Charset.isSupported(string2 = resourceBundle.getString(string))) {
            return Charset.forName(string2);
        }
        LowLevelLogUtil.log("Unable to get Charset '" + string3 + "' for property '" + string + "', using default " + charset + " and continuing.");
        return charset;
    }

    public double getDoubleProperty(String string, double d2) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            try {
                return Double.parseDouble(string2);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
            }
        }
        return d2;
    }

    public int getIntegerProperty(String string, int n2) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2.trim());
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
            }
        }
        return n2;
    }

    public Integer getIntegerProperty(String[] stringArray, String string, Supplier<Integer> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getIntegerProperty(string2 + string, 0);
        }
        return supplier != null ? supplier.get() : null;
    }

    public long getLongProperty(String string, long l2) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            try {
                return Long.parseLong(string2);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
            }
        }
        return l2;
    }

    public Long getLongProperty(String[] stringArray, String string, Supplier<Long> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getLongProperty(string2 + string, 0L);
        }
        return supplier != null ? supplier.get() : null;
    }

    public Duration getDurationProperty(String string, Duration duration) {
        String string2 = this.getStringProperty(string);
        if (string2 != null) {
            return TimeUnit.getDuration(string2);
        }
        return duration;
    }

    public Duration getDurationProperty(String[] stringArray, String string, Supplier<Duration> supplier) {
        for (String string2 : stringArray) {
            if (!this.hasProperty(string2 + string)) continue;
            return this.getDurationProperty(string2 + string, null);
        }
        return supplier != null ? supplier.get() : null;
    }

    public String getStringProperty(String[] stringArray, String string, Supplier<String> supplier) {
        for (String string2 : stringArray) {
            String string3 = this.getStringProperty(string2 + string);
            if (string3 == null) continue;
            return string3;
        }
        return supplier != null ? supplier.get() : null;
    }

    public String getStringProperty(String string) {
        return this.environment.get(string);
    }

    public String getStringProperty(String string, String string2) {
        String string3 = this.getStringProperty(string);
        return string3 == null ? string2 : string3;
    }

    public static Properties getSystemProperties() {
        try {
            return new Properties(System.getProperties());
        }
        catch (SecurityException securityException) {
            Throwables.throwIfCritical(securityException);
            SecurityException securityException2 = securityException;
            LowLevelLogUtil.logException("Unable to access system properties.", securityException2);
            return new Properties();
        }
    }

    public void reload() {
        this.environment.reload();
    }

    public static Properties extractSubset(Properties properties, String string) {
        Properties properties2 = new Properties();
        if (string == null || string.length() == 0) {
            return properties2;
        }
        String string2 = string.charAt(string.length() - 1) != '.' ? string + '.' : string;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : properties.stringPropertyNames()) {
            if (!string3.startsWith(string2)) continue;
            properties2.setProperty(string3.substring(string2.length()), properties.getProperty(string3));
            arrayList.add(string3);
        }
        for (String string3 : arrayList) {
            properties.remove(string3);
        }
        return properties2;
    }

    static ResourceBundle getCharsetsResourceBundle() {
        return ResourceBundle.getBundle("Log4j-charsets");
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties) {
        return PropertiesUtil.partitionOnCommonPrefixes(properties, false);
    }

    public static Map<String, Properties> partitionOnCommonPrefixes(Properties properties, boolean bl2) {
        ConcurrentHashMap<String, Properties> concurrentHashMap = new ConcurrentHashMap<String, Properties>();
        for (String string : properties.stringPropertyNames()) {
            int n2 = string.indexOf(46);
            if (n2 < 0) {
                if (!bl2) continue;
                if (!concurrentHashMap.containsKey(string)) {
                    concurrentHashMap.put(string, new Properties());
                }
                ((Properties)concurrentHashMap.get(string)).setProperty("", properties.getProperty(string));
                continue;
            }
            String string2 = string.substring(0, n2);
            if (!concurrentHashMap.containsKey(string2)) {
                concurrentHashMap.put(string2, new Properties());
            }
            ((Properties)concurrentHashMap.get(string2)).setProperty(string.substring(n2 + 1), properties.getProperty(string));
        }
        return concurrentHashMap;
    }

    public boolean isOsWindows() {
        return this.getStringProperty("os.name", "").startsWith("Windows");
    }

    private static enum TimeUnit {
        NANOS("ns,nano,nanos,nanosecond,nanoseconds", ChronoUnit.NANOS),
        MICROS("us,micro,micros,microsecond,microseconds", ChronoUnit.MICROS),
        MILLIS("ms,milli,millis,millsecond,milliseconds", ChronoUnit.MILLIS),
        SECONDS("s,second,seconds", ChronoUnit.SECONDS),
        MINUTES("m,minute,minutes", ChronoUnit.MINUTES),
        HOURS("h,hour,hours", ChronoUnit.HOURS),
        DAYS("d,day,days", ChronoUnit.DAYS);

        private final String[] descriptions;
        private final ChronoUnit timeUnit;

        private TimeUnit(String string2, ChronoUnit chronoUnit) {
            this.descriptions = string2.split(",");
            this.timeUnit = chronoUnit;
        }

        ChronoUnit getTimeUnit() {
            return this.timeUnit;
        }

        static Duration getDuration(String string) {
            String string2 = string.trim();
            ChronoUnit chronoUnit = ChronoUnit.MILLIS;
            long l2 = 0L;
            for (TimeUnit timeUnit : TimeUnit.values()) {
                for (String string3 : timeUnit.descriptions) {
                    if (!string2.endsWith(string3)) continue;
                    chronoUnit = timeUnit.timeUnit;
                    l2 = Long.parseLong(string2.substring(0, string2.length() - string3.length()));
                }
            }
            return Duration.of(l2, chronoUnit);
        }
    }

    private static class Environment {
        private final Set<PropertySource> sources = new ConcurrentSkipListSet<PropertySource>(new PropertySource.Comparator());
        private final Map<String, String> literal = new ConcurrentHashMap<String, String>();
        private final Map<String, String> normalized = new ConcurrentHashMap<String, String>();
        private final Map<List<CharSequence>, String> tokenized = new ConcurrentHashMap<List<CharSequence>, String>();

        private Environment(PropertySource propertySource) {
            PropertyFilePropertySource propertyFilePropertySource = new PropertyFilePropertySource(PropertiesUtil.LOG4J_SYSTEM_PROPERTIES_FILE_NAME, false);
            try {
                propertyFilePropertySource.forEach((string, string2) -> {
                    if (System.getProperty(string) == null) {
                        System.setProperty(string, string2);
                    }
                });
            }
            catch (SecurityException securityException) {
                Throwables.throwIfCritical(securityException);
                SecurityException securityException2 = securityException;
            }
            this.sources.add(propertySource);
            ServiceLoaderUtil.loadServices(PropertySource.class, MethodHandles.lookup(), false, false).forEach(this.sources::add);
            this.reload();
        }

        public void addPropertySource(PropertySource propertySource) {
            this.sources.add(propertySource);
        }

        private synchronized void reload() {
            this.literal.clear();
            this.normalized.clear();
            this.tokenized.clear();
            HashSet hashSet = new HashSet();
            this.sources.stream().map(PropertySource::getPropertyNames).reduce(hashSet, (collection, collection2) -> {
                collection.addAll(collection2);
                return collection;
            });
            hashSet.stream().filter(Objects::nonNull).forEach(string -> {
                List<CharSequence> list = PropertySource.Util.tokenize(string);
                boolean bl2 = !list.isEmpty();
                this.sources.forEach(propertySource -> {
                    String string2;
                    if (propertySource.containsProperty((String)string)) {
                        string2 = propertySource.getProperty((String)string);
                        this.literal.putIfAbsent((String)string, string2);
                        if (bl2) {
                            this.tokenized.putIfAbsent(list, string2);
                        }
                    }
                    if (bl2 && (string2 = Objects.toString(propertySource.getNormalForm(list), null)) != null && propertySource.containsProperty(string2)) {
                        this.normalized.putIfAbsent((String)string, propertySource.getProperty(string2));
                    }
                });
            });
        }

        private String get(String string) {
            if (this.normalized.containsKey(string)) {
                return this.normalized.get(string);
            }
            if (this.literal.containsKey(string)) {
                return this.literal.get(string);
            }
            List<CharSequence> list = PropertySource.Util.tokenize(string);
            boolean bl2 = !list.isEmpty();
            for (PropertySource propertySource : this.sources) {
                String string2;
                if (bl2 && (string2 = Objects.toString(propertySource.getNormalForm(list), null)) != null && propertySource.containsProperty(string2)) {
                    return propertySource.getProperty(string2);
                }
                if (!propertySource.containsProperty(string)) continue;
                return propertySource.getProperty(string);
            }
            return this.tokenized.get(list);
        }

        private boolean containsKey(String string) {
            List<CharSequence> list = PropertySource.Util.tokenize(string);
            return this.normalized.containsKey(string) || this.literal.containsKey(string) || this.tokenized.containsKey(list) || this.sources.stream().anyMatch(propertySource -> {
                CharSequence charSequence = propertySource.getNormalForm(list);
                return propertySource.containsProperty(string) || charSequence != null && propertySource.containsProperty(charSequence.toString());
            });
        }
    }
}

