/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh;

import com.contrastsecurity.thirdparty.ohh.AbstractHistogram;
import com.contrastsecurity.thirdparty.ohh.ConcurrentHistogram;
import com.contrastsecurity.thirdparty.ohh.DoubleHistogram;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;

public class ConcurrentDoubleHistogram
extends DoubleHistogram {
    public ConcurrentDoubleHistogram(int n2) {
        this(2L, n2);
        this.setAutoResize(true);
    }

    public ConcurrentDoubleHistogram(long l2, int n2) {
        this(l2, n2, ConcurrentHistogram.class);
    }

    public ConcurrentDoubleHistogram(DoubleHistogram doubleHistogram) {
        super(doubleHistogram);
    }

    ConcurrentDoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz) {
        super(l2, n2, clazz);
    }

    ConcurrentDoubleHistogram(long l2, int n2, Class<? extends AbstractHistogram> clazz, AbstractHistogram abstractHistogram) {
        super(l2, n2, clazz, abstractHistogram);
    }

    public static ConcurrentDoubleHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        try {
            int n2 = byteBuffer.getInt();
            if (!ConcurrentDoubleHistogram.isNonCompressedDoubleHistogramCookie(n2)) {
                throw new IllegalArgumentException("The buffer does not contain a DoubleHistogram");
            }
            ConcurrentDoubleHistogram concurrentDoubleHistogram = ConcurrentDoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, ConcurrentDoubleHistogram.class, ConcurrentHistogram.class, l2);
            return concurrentDoubleHistogram;
        }
        catch (DataFormatException dataFormatException) {
            throw new RuntimeException(dataFormatException);
        }
    }

    public static ConcurrentDoubleHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        int n2 = byteBuffer.getInt();
        if (!ConcurrentDoubleHistogram.isCompressedDoubleHistogramCookie(n2)) {
            throw new IllegalArgumentException("The buffer does not contain a compressed DoubleHistogram");
        }
        ConcurrentDoubleHistogram concurrentDoubleHistogram = ConcurrentDoubleHistogram.constructHistogramFromBuffer(n2, byteBuffer, ConcurrentDoubleHistogram.class, ConcurrentHistogram.class, l2);
        return concurrentDoubleHistogram;
    }
}

