/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.thirdparty.ohh.DoubleHistogram;
import com.contrastsecurity.thirdparty.ohh.EncodableHistogram;
import com.contrastsecurity.thirdparty.ohh.Histogram;
import com.contrastsecurity.thirdparty.ohh.HistogramLogReader;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TreeSet;

public class HistogramLogProcessor
extends Thread {
    static final String versionString = "Histogram Log Processor version 2.1.12";
    private final HistogramLogProcessorConfiguration config;
    private HistogramLogReader logReader;
    private int lineNumber = 0;

    private void outputTimeRange(PrintStream printStream, String string) {
        printStream.format(Locale.US, "#[%s between %.3f and", string, this.config.rangeStartTimeSec);
        if (this.config.rangeEndTimeSec < Double.MAX_VALUE) {
            printStream.format(" %.3f", this.config.rangeEndTimeSec);
        } else {
            printStream.format(" %s", "<Infinite>");
        }
        printStream.format(" seconds (relative to StartTime)]\n", new Object[0]);
    }

    private void outputStartTime(PrintStream printStream, Double d2) {
        printStream.format(Locale.US, "#[StartTime: %.3f (seconds since epoch), %s]\n", d2, new Date((long)(d2 * 1000.0)).toString());
    }

    EncodableHistogram copyCorrectedForCoordinatedOmission(EncodableHistogram encodableHistogram) {
        long l2;
        EncodableHistogram encodableHistogram2 = encodableHistogram;
        if (encodableHistogram2 instanceof DoubleHistogram) {
            if (this.config.expectedIntervalForCoordinatedOmissionCorrection > 0.0) {
                encodableHistogram2 = ((DoubleHistogram)encodableHistogram2).copyCorrectedForCoordinatedOmission(this.config.expectedIntervalForCoordinatedOmissionCorrection);
            }
        } else if (encodableHistogram2 instanceof Histogram && (l2 = (long)this.config.expectedIntervalForCoordinatedOmissionCorrection) > 0L) {
            encodableHistogram2 = ((Histogram)encodableHistogram2).copyCorrectedForCoordinatedOmission(l2);
        }
        return encodableHistogram2;
    }

    private EncodableHistogram getIntervalHistogram() {
        EncodableHistogram encodableHistogram = null;
        try {
            encodableHistogram = this.logReader.nextIntervalHistogram(this.config.rangeStartTimeSec, this.config.rangeEndTimeSec);
            if (this.config.expectedIntervalForCoordinatedOmissionCorrection > 0.0) {
                encodableHistogram = this.copyCorrectedForCoordinatedOmission(encodableHistogram);
            }
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            RuntimeException runtimeException2 = runtimeException;
            System.err.println("Log file parsing error at line number " + this.lineNumber + ": line appears to be malformed.");
            if (this.config.verbose) {
                throw runtimeException2;
            }
            System.exit(1);
        }
        ++this.lineNumber;
        return encodableHistogram;
    }

    private EncodableHistogram getIntervalHistogram(String string) {
        EncodableHistogram encodableHistogram;
        if (string == null) {
            while ((encodableHistogram = this.getIntervalHistogram()) != null && encodableHistogram.getTag() != null) {
            }
        } else {
            while ((encodableHistogram = this.getIntervalHistogram()) != null && !string.equals(encodableHistogram.getTag())) {
            }
        }
        return encodableHistogram;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            String string;
            String string2;
            PrintStream printStream = null;
            PrintStream printStream2 = null;
            PrintStream printStream3 = System.out;
            double d2 = 0.0;
            boolean bl2 = false;
            boolean bl3 = false;
            LinkedList<Object> linkedList = new LinkedList<Object>();
            if (this.config.listTags) {
                EncodableHistogram encodableHistogram;
                TreeSet<String> treeSet = new TreeSet<String>();
                boolean bl4 = false;
                while ((encodableHistogram = this.getIntervalHistogram()) != null) {
                    String string3 = encodableHistogram.getTag();
                    if (string3 != null) {
                        treeSet.add(encodableHistogram.getTag());
                        continue;
                    }
                    bl4 = true;
                }
                System.out.println("Tags found in input file:");
                if (bl4) {
                    System.out.println("[NO TAG (default)]");
                }
                for (String string4 : treeSet) {
                    System.out.println(string4);
                }
                scopeProvider.leaveScope();
                return;
            }
            if (this.config.logFormatCsv) {
                string2 = "%.3f,%d,%.3f,%.3f,%.3f,%d,%.3f,%.3f,%.3f,%.3f,%.3f,%.3f\n";
                string = "%.3f,%d,%.3f,%.3f\n";
            } else {
                string2 = "%4.3f: I:%d ( %7.3f %7.3f %7.3f ) T:%d ( %7.3f %7.3f %7.3f %7.3f %7.3f %7.3f )\n";
                string = "%4.3f: I:%d P:%7.3f M:%7.3f\n";
            }
            try {
                EncodableHistogram encodableHistogram;
                boolean bl5;
                Object object;
                if (this.config.outputFileName != null) {
                    try {
                        printStream = new PrintStream(new FileOutputStream(this.config.outputFileName), false);
                        this.outputTimeRange(printStream, "Interval percentile log");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("Failed to open output file " + this.config.outputFileName);
                    }
                    object = this.config.outputFileName + ".hgrm";
                    try {
                        printStream3 = new PrintStream(new FileOutputStream((String)object), false);
                        this.outputTimeRange(printStream3, "Overall percentile distribution");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        System.err.println("Failed to open percentiles histogram output file " + (String)object);
                    }
                    if (this.config.movingWindow) {
                        String string5 = this.config.outputFileName + ".mwp";
                        try {
                            printStream2 = new PrintStream(new FileOutputStream(string5), false);
                            this.outputTimeRange(printStream2, "Moving window log for " + this.config.movingWindowPercentileToReport + " percentile");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            System.err.println("Failed to open moving window output file " + string5);
                        }
                    }
                }
                Histogram histogram = (bl5 = (object = this.getIntervalHistogram(this.config.tag)) instanceof DoubleHistogram) ? new Histogram(3) : ((Histogram)object).copy();
                histogram.reset();
                histogram.setAutoResize(true);
                DoubleHistogram doubleHistogram = bl5 ? ((DoubleHistogram)object).copy() : new DoubleHistogram(3);
                doubleHistogram.reset();
                doubleHistogram.setAutoResize(true);
                EncodableHistogram encodableHistogram2 = encodableHistogram = bl5 ? new DoubleHistogram(3) : new Histogram(3);
                while (object != null) {
                    if (object instanceof DoubleHistogram) {
                        if (!bl5) {
                            throw new IllegalStateException("Encountered a DoubleHistogram line in a log of Histograms.");
                        }
                        doubleHistogram.add((DoubleHistogram)object);
                    } else {
                        if (bl5) {
                            throw new IllegalStateException("Encountered a Histogram line in a log of DoubleHistograms.");
                        }
                        histogram.add((Histogram)object);
                    }
                    long l2 = ((EncodableHistogram)object).getEndTimeStamp() - this.config.movingWindowLengthInMsec;
                    if (this.config.movingWindow) {
                        EncodableHistogram encodableHistogram3;
                        if (encodableHistogram instanceof DoubleHistogram && object instanceof DoubleHistogram) {
                            ((DoubleHistogram)encodableHistogram).add((DoubleHistogram)object);
                        } else if (encodableHistogram instanceof Histogram && object instanceof Histogram) {
                            ((Histogram)encodableHistogram).add((Histogram)object);
                        }
                        while ((encodableHistogram3 = (EncodableHistogram)linkedList.peek()) != null && encodableHistogram3.getEndTimeStamp() <= l2) {
                            EncodableHistogram encodableHistogram4 = (EncodableHistogram)linkedList.remove();
                            if (encodableHistogram instanceof DoubleHistogram) {
                                if (encodableHistogram4 == null) continue;
                                ((DoubleHistogram)encodableHistogram).subtract((DoubleHistogram)encodableHistogram4);
                                continue;
                            }
                            if (!(encodableHistogram instanceof Histogram) || encodableHistogram4 == null) continue;
                            ((Histogram)encodableHistogram).subtract((Histogram)encodableHistogram4);
                        }
                        linkedList.add(object);
                    }
                    if (d2 == 0.0 && this.logReader.getStartTimeSec() != 0.0) {
                        d2 = this.logReader.getStartTimeSec();
                        this.outputStartTime(printStream3, d2);
                        if (printStream != null) {
                            this.outputStartTime(printStream, d2);
                        }
                    }
                    if (printStream != null) {
                        if (!bl2) {
                            bl2 = true;
                            if (this.config.logFormatCsv) {
                                printStream.println("\"Timestamp\",\"Int_Count\",\"Int_50%\",\"Int_90%\",\"Int_Max\",\"Total_Count\",\"Total_50%\",\"Total_90%\",\"Total_99%\",\"Total_99.9%\",\"Total_99.99%\",\"Total_Max\"");
                            } else {
                                printStream.println("Time: IntervalPercentiles:count ( 50% 90% Max ) TotalPercentiles:count ( 50% 90% 99% 99.9% 99.99% Max )");
                            }
                        }
                        if (bl5) {
                            printStream.format(Locale.US, string2, (double)((EncodableHistogram)object).getEndTimeStamp() / 1000.0 - this.logReader.getStartTimeSec(), ((DoubleHistogram)object).getTotalCount(), ((DoubleHistogram)object).getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, ((DoubleHistogram)object).getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, ((DoubleHistogram)object).getMaxValue() / this.config.outputValueUnitRatio, doubleHistogram.getTotalCount(), doubleHistogram.getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, doubleHistogram.getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, doubleHistogram.getValueAtPercentile(99.0) / this.config.outputValueUnitRatio, doubleHistogram.getValueAtPercentile(99.9) / this.config.outputValueUnitRatio, doubleHistogram.getValueAtPercentile(99.99) / this.config.outputValueUnitRatio, doubleHistogram.getMaxValue() / this.config.outputValueUnitRatio);
                        } else {
                            printStream.format(Locale.US, string2, (double)((EncodableHistogram)object).getEndTimeStamp() / 1000.0 - this.logReader.getStartTimeSec(), ((Histogram)object).getTotalCount(), (double)((Histogram)object).getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, (double)((Histogram)object).getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, (double)((Histogram)object).getMaxValue() / this.config.outputValueUnitRatio, histogram.getTotalCount(), (double)histogram.getValueAtPercentile(50.0) / this.config.outputValueUnitRatio, (double)histogram.getValueAtPercentile(90.0) / this.config.outputValueUnitRatio, (double)histogram.getValueAtPercentile(99.0) / this.config.outputValueUnitRatio, (double)histogram.getValueAtPercentile(99.9) / this.config.outputValueUnitRatio, (double)histogram.getValueAtPercentile(99.99) / this.config.outputValueUnitRatio, (double)histogram.getMaxValue() / this.config.outputValueUnitRatio);
                        }
                    }
                    if (printStream2 != null) {
                        if (!bl3) {
                            bl3 = true;
                            if (this.config.logFormatCsv) {
                                printStream2.println("\"Timestamp\",\"Window_Count\",\"" + this.config.movingWindowPercentileToReport + "%'ile\",\"Max\"");
                            } else {
                                printStream2.println("Time: WindoCount " + this.config.movingWindowPercentileToReport + "%'ile Max");
                            }
                        }
                        if (object instanceof DoubleHistogram) {
                            printStream2.format(Locale.US, string, (double)((EncodableHistogram)object).getEndTimeStamp() / 1000.0 - this.logReader.getStartTimeSec(), ((DoubleHistogram)encodableHistogram).getTotalCount(), ((DoubleHistogram)encodableHistogram).getValueAtPercentile(this.config.movingWindowPercentileToReport) / this.config.outputValueUnitRatio, ((DoubleHistogram)encodableHistogram).getMaxValue() / this.config.outputValueUnitRatio);
                        } else {
                            printStream2.format(Locale.US, string, (double)((EncodableHistogram)object).getEndTimeStamp() / 1000.0 - this.logReader.getStartTimeSec(), ((Histogram)encodableHistogram).getTotalCount(), (double)((Histogram)encodableHistogram).getValueAtPercentile(this.config.movingWindowPercentileToReport) / this.config.outputValueUnitRatio, (double)((Histogram)encodableHistogram).getMaxValue() / this.config.outputValueUnitRatio);
                        }
                    }
                    object = this.getIntervalHistogram(this.config.tag);
                }
                if (bl5) {
                    doubleHistogram.outputPercentileDistribution(printStream3, this.config.percentilesOutputTicksPerHalf, this.config.outputValueUnitRatio, this.config.logFormatCsv);
                } else {
                    histogram.outputPercentileDistribution(printStream3, this.config.percentilesOutputTicksPerHalf, this.config.outputValueUnitRatio, this.config.logFormatCsv);
                }
            }
            finally {
                if (printStream != null) {
                    printStream.close();
                }
                if (printStream2 != null) {
                    printStream2.close();
                }
                if (printStream3 != System.out) {
                    printStream3.close();
                }
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    public HistogramLogProcessor(String[] stringArray) throws FileNotFoundException {
        this.setName("HistogramLogProcessor");
        this.config = new HistogramLogProcessorConfiguration(stringArray);
        this.logReader = this.config.inputFileName != null ? new HistogramLogReader(this.config.inputFileName) : new HistogramLogReader(System.in);
    }

    public static void main(String[] stringArray) {
        try {
            HistogramLogProcessor histogramLogProcessor = new HistogramLogProcessor(stringArray);
            histogramLogProcessor.start();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("failed to open input file.");
        }
    }

    private static class HistogramLogProcessorConfiguration {
        boolean verbose = false;
        String outputFileName = null;
        String inputFileName = null;
        String tag = null;
        double rangeStartTimeSec = 0.0;
        double rangeEndTimeSec = Double.MAX_VALUE;
        boolean logFormatCsv = false;
        boolean listTags = false;
        boolean allTags = false;
        boolean movingWindow = false;
        double movingWindowPercentileToReport = 99.0;
        long movingWindowLengthInMsec = 60000L;
        int percentilesOutputTicksPerHalf = 5;
        Double outputValueUnitRatio = 1000000.0;
        double expectedIntervalForCoordinatedOmissionCorrection = 0.0;
        String errorMessage = "";

        HistogramLogProcessorConfiguration(String[] stringArray) {
            boolean bl2 = false;
            try {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    if (stringArray[i2].equals("-csv")) {
                        this.logFormatCsv = true;
                        continue;
                    }
                    if (stringArray[i2].equals("-v")) {
                        this.verbose = true;
                        continue;
                    }
                    if (stringArray[i2].equals("-listtags")) {
                        this.listTags = true;
                        continue;
                    }
                    if (stringArray[i2].equals("-alltags")) {
                        this.allTags = true;
                        continue;
                    }
                    if (stringArray[i2].equals("-i")) {
                        this.inputFileName = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-tag")) {
                        this.tag = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-mwp")) {
                        this.movingWindowPercentileToReport = Double.parseDouble(stringArray[++i2]);
                        this.movingWindow = true;
                        continue;
                    }
                    if (stringArray[i2].equals("-mwpl")) {
                        this.movingWindowLengthInMsec = Long.parseLong(stringArray[++i2]);
                        this.movingWindow = true;
                        continue;
                    }
                    if (stringArray[i2].equals("-start")) {
                        this.rangeStartTimeSec = Double.parseDouble(stringArray[++i2]);
                        continue;
                    }
                    if (stringArray[i2].equals("-end")) {
                        this.rangeEndTimeSec = Double.parseDouble(stringArray[++i2]);
                        continue;
                    }
                    if (stringArray[i2].equals("-o")) {
                        this.outputFileName = stringArray[++i2];
                        continue;
                    }
                    if (stringArray[i2].equals("-percentilesOutputTicksPerHalf")) {
                        this.percentilesOutputTicksPerHalf = Integer.parseInt(stringArray[++i2]);
                        continue;
                    }
                    if (stringArray[i2].equals("-outputValueUnitRatio")) {
                        this.outputValueUnitRatio = Double.parseDouble(stringArray[++i2]);
                        continue;
                    }
                    if (stringArray[i2].equals("-correctLogWithKnownCoordinatedOmission")) {
                        this.expectedIntervalForCoordinatedOmissionCorrection = Double.parseDouble(stringArray[++i2]);
                        continue;
                    }
                    if (stringArray[i2].equals("-h")) {
                        bl2 = true;
                        throw new Exception("Help: " + stringArray[i2]);
                    }
                    throw new Exception("Invalid args: " + stringArray[i2]);
                }
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                this.errorMessage = "Error: Histogram Log Processor version 2.1.12 launched with the following args:\n";
                for (String string : stringArray) {
                    this.errorMessage = this.errorMessage + string + " ";
                }
                if (!bl2) {
                    this.errorMessage = this.errorMessage + "\nWhich was parsed as an error, indicated by the following exception:\n" + exception2;
                    System.err.println(this.errorMessage);
                }
                String string = "\"[-csv] [-v] [-i inputFileName] [-o outputFileName] [-tag tag] [-start rangeStartTimeSec] [-end rangeEndTimeSec] [-outputValueUnitRatio r] [-correctLogWithKnownCoordinatedOmission i] [-listtags]";
                System.err.println("valid arguments = \"[-csv] [-v] [-i inputFileName] [-o outputFileName] [-tag tag] [-start rangeStartTimeSec] [-end rangeEndTimeSec] [-outputValueUnitRatio r] [-correctLogWithKnownCoordinatedOmission i] [-listtags]");
                System.err.println(" [-h]                                         help\n [-v]                                         Provide verbose error output\n [-csv]                                       Use CSV format for output log files\n [-i logFileName]                             File name of Histogram Log to process (default is standard input)\n [-o outputFileName]                          File name to output to (default is standard output)\n [-tag tag]                                   The tag (default no tag) of the histogram lines to be processed\n [-start rangeStartTimeSec]                   The start time for the range in the file, in seconds (default 0.0)\n [-end rangeEndTimeSec]                       The end time for the range in the file, in seconds (default is infinite)\n [-outputValueUnitRatio r]                    The scaling factor by which to divide histogram recorded values units\n                                              in output. [default = 1000000.0 (1 msec in nsec)]\n [-correctLogWithKnownCoordinatedOmission i]  When the supplied expected interval i is than 0, performs coordinated\n                                              omission corection on the input log's interval histograms by adding\n                                              missing values as appropriate based on the supplied expected interval\n                                              value i (in wahtever units the log histograms were recorded with). This\n                                              feature should only be used when the input log is known to have been\n                                              recorded with coordinated ommisions, and when an expected interval is known.\n [-listtags]                                  list all tags found on histogram lines the input file.");
                System.exit(1);
            }
        }
    }
}

