/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh;

import com.contrastsecurity.thirdparty.ohh.AbstractHistogram;
import com.contrastsecurity.thirdparty.ohh.Base64Helper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;

public class ShortCountsHistogram
extends AbstractHistogram {
    long totalCount;
    short[] counts;
    int normalizingIndexOffset;

    @Override
    long getCountAtIndex(int n2) {
        return this.counts[this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength)];
    }

    @Override
    long getCountAtNormalizedIndex(int n2) {
        return this.counts[n2];
    }

    @Override
    void incrementCountAtIndex(int n2) {
        int n3 = this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength);
        short s2 = this.counts[n3];
        short s3 = (short)(s2 + 1);
        if (s3 < 0) {
            throw new IllegalStateException("would overflow short integer count");
        }
        this.counts[n3] = s3;
    }

    @Override
    void addToCountAtIndex(int n2, long l2) {
        int n3 = this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength);
        long l3 = this.counts[n3];
        long l4 = l3 + l2;
        if (l4 < -32768L || l4 > 32767L) {
            throw new IllegalStateException("would overflow short integer count");
        }
        this.counts[n3] = (short)l4;
    }

    @Override
    void setCountAtIndex(int n2, long l2) {
        this.setCountAtNormalizedIndex(this.normalizeIndex(n2, this.normalizingIndexOffset, this.countsArrayLength), l2);
    }

    @Override
    void setCountAtNormalizedIndex(int n2, long l2) {
        if (l2 < 0L || l2 > 32767L) {
            throw new IllegalStateException("would overflow short integer count");
        }
        this.counts[n2] = (short)l2;
    }

    @Override
    int getNormalizingIndexOffset() {
        return this.normalizingIndexOffset;
    }

    @Override
    void setNormalizingIndexOffset(int n2) {
        this.normalizingIndexOffset = n2;
    }

    @Override
    void setIntegerToDoubleValueConversionRatio(double d2) {
        this.nonConcurrentSetIntegerToDoubleValueConversionRatio(d2);
    }

    @Override
    void shiftNormalizingIndexByOffset(int n2, boolean bl2, double d2) {
        this.nonConcurrentNormalizingIndexShift(n2, bl2);
    }

    @Override
    void clearCounts() {
        Arrays.fill(this.counts, (short)0);
        this.totalCount = 0L;
    }

    @Override
    public ShortCountsHistogram copy() {
        ShortCountsHistogram shortCountsHistogram = new ShortCountsHistogram(this);
        shortCountsHistogram.add(this);
        return shortCountsHistogram;
    }

    @Override
    public ShortCountsHistogram copyCorrectedForCoordinatedOmission(long l2) {
        ShortCountsHistogram shortCountsHistogram = new ShortCountsHistogram(this);
        shortCountsHistogram.addWhileCorrectingForCoordinatedOmission(this, l2);
        return shortCountsHistogram;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    @Override
    void setTotalCount(long l2) {
        this.totalCount = l2;
    }

    @Override
    void incrementTotalCount() {
        ++this.totalCount;
    }

    @Override
    void addToTotalCount(long l2) {
        this.totalCount += l2;
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 2 * this.counts.length;
    }

    @Override
    void resize(long l2) {
        int n2 = this.normalizeIndex(0, this.normalizingIndexOffset, this.countsArrayLength);
        this.establishSize(l2);
        int n3 = this.countsArrayLength - this.counts.length;
        this.counts = Arrays.copyOf(this.counts, this.countsArrayLength);
        if (n2 != 0) {
            int n4 = n2 + n3;
            int n5 = this.countsArrayLength - n3 - n2;
            System.arraycopy(this.counts, n2, this.counts, n4, n5);
            Arrays.fill(this.counts, n2, n4, (short)0);
        }
    }

    public ShortCountsHistogram(int n2) {
        this(1L, 2L, n2);
        this.setAutoResize(true);
    }

    public ShortCountsHistogram(long l2, int n2) {
        this(1L, l2, n2);
    }

    public ShortCountsHistogram(long l2, long l3, int n2) {
        super(l2, l3, n2);
        this.counts = new short[this.countsArrayLength];
        this.wordSizeInBytes = 2;
    }

    public ShortCountsHistogram(AbstractHistogram abstractHistogram) {
        super(abstractHistogram);
        this.counts = new short[this.countsArrayLength];
        this.wordSizeInBytes = 2;
    }

    public static ShortCountsHistogram decodeFromByteBuffer(ByteBuffer byteBuffer, long l2) {
        return ShortCountsHistogram.decodeFromByteBuffer(byteBuffer, ShortCountsHistogram.class, l2);
    }

    public static ShortCountsHistogram decodeFromCompressedByteBuffer(ByteBuffer byteBuffer, long l2) throws DataFormatException {
        return ShortCountsHistogram.decodeFromCompressedByteBuffer(byteBuffer, ShortCountsHistogram.class, l2);
    }

    public static ShortCountsHistogram fromString(String string) throws DataFormatException {
        return ShortCountsHistogram.decodeFromCompressedByteBuffer(ByteBuffer.wrap(Base64Helper.parseBase64Binary(string)), 0L);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
    }
}

