/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ohh.packedarray;

import com.contrastsecurity.thirdparty.ohh.WriterReaderPhaser;
import com.contrastsecurity.thirdparty.ohh.packedarray.PackedLongArray;
import java.util.concurrent.atomic.AtomicLong;

public class PackedArraySingleWriterRecorder {
    private static AtomicLong instanceIdSequencer = new AtomicLong(1L);
    private final long instanceId = instanceIdSequencer.getAndIncrement();
    private final WriterReaderPhaser recordingPhaser = new WriterReaderPhaser();
    private volatile PackedLongArray activeArray;

    public PackedArraySingleWriterRecorder(int n2) {
        this.activeArray = new InternalPackedLongArray(this.instanceId, n2);
        this.activeArray.setStartTimeStamp(System.currentTimeMillis());
    }

    public PackedArraySingleWriterRecorder(int n2, int n3) {
        this.activeArray = new InternalPackedLongArray(this.instanceId, n2, n3);
        this.activeArray.setStartTimeStamp(System.currentTimeMillis());
    }

    public int length() {
        return this.activeArray.length();
    }

    public void setVirtualLength(int n2) {
        try {
            this.recordingPhaser.readerLock();
            this.activeArray.setVirtualLength(n2);
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void increment(int n2) throws ArrayIndexOutOfBoundsException {
        long l2 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeArray.increment(n2);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(int n2, long l2) throws ArrayIndexOutOfBoundsException {
        long l3 = this.recordingPhaser.writerCriticalSectionEnter();
        try {
            this.activeArray.add(n2, l2);
        }
        finally {
            this.recordingPhaser.writerCriticalSectionExit(l3);
        }
    }

    public synchronized PackedLongArray getIntervalArray() {
        return this.getIntervalArray(null);
    }

    public synchronized PackedLongArray getIntervalArray(PackedLongArray packedLongArray) {
        return this.getIntervalArray(packedLongArray, true);
    }

    public synchronized PackedLongArray getIntervalArray(PackedLongArray packedLongArray, boolean bl2) {
        this.validateFitAsReplacementArray(packedLongArray, bl2);
        PackedLongArray packedLongArray2 = this.performIntervalSample(packedLongArray);
        return packedLongArray2;
    }

    public synchronized void reset() {
        this.performIntervalSample(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private PackedLongArray performIntervalSample(PackedLongArray packedLongArray) {
        PackedLongArray packedLongArray2 = packedLongArray;
        try {
            this.recordingPhaser.readerLock();
            if (packedLongArray2 == null) {
                if (!(this.activeArray instanceof InternalPackedLongArray)) throw new IllegalStateException("Unexpected internal array type for activeArray");
                packedLongArray2 = new InternalPackedLongArray(this.instanceId, this.activeArray.length());
            } else {
                packedLongArray2.clear();
            }
            PackedLongArray packedLongArray3 = packedLongArray2;
            packedLongArray2 = this.activeArray;
            this.activeArray = packedLongArray3;
            long l2 = System.currentTimeMillis();
            this.activeArray.setStartTimeStamp(l2);
            packedLongArray2.setEndTimeStamp(l2);
            this.recordingPhaser.flipPhase(500000L);
            return packedLongArray2;
        }
        finally {
            this.recordingPhaser.readerUnlock();
        }
    }

    private void validateFitAsReplacementArray(PackedLongArray packedLongArray, boolean bl2) {
        boolean bl3 = true;
        if (packedLongArray == null) {
            bl3 = false;
        } else if (packedLongArray instanceof InternalPackedLongArray && this.activeArray instanceof InternalPackedLongArray && (!bl2 || ((InternalPackedLongArray)packedLongArray).containingInstanceId == ((InternalPackedLongArray)this.activeArray).containingInstanceId)) {
            bl3 = false;
        }
        if (bl3) {
            throw new IllegalArgumentException("replacement array must have been obtained via a previous getIntervalArray() call from this " + this.getClass().getName() + (bl2 ? " insatnce" : " class"));
        }
    }

    private static class InternalPackedLongArray
    extends PackedLongArray {
        private final long containingInstanceId;

        private InternalPackedLongArray(long l2, int n2, int n3) {
            super(n2, n3);
            this.containingInstanceId = l2;
        }

        private InternalPackedLongArray(long l2, int n2) {
            super(n2);
            this.containingInstanceId = l2;
        }
    }
}

