/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.ojt.maps;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.ojt.maps.AbstractEntry;
import com.contrastsecurity.thirdparty.ojt.maps.ConcurrentAutoTable;
import com.contrastsecurity.thirdparty.ojt.maps.NonBlockingHashMap;
import com.contrastsecurity.thirdparty.ojt.util.RangeUtil;
import com.contrastsecurity.thirdparty.ojt.util.UnsafeAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class NonBlockingIdentityHashMap<TypeK, TypeV>
extends AbstractMap<TypeK, TypeV>
implements Serializable,
Cloneable,
ConcurrentMap<TypeK, TypeV> {
    private static final long serialVersionUID = 1234123412341234123L;
    private static final int REPROBE_LIMIT = 10;
    private static final int _Obase = UnsafeAccess.UNSAFE.arrayBaseOffset(Object[].class);
    private static final int _Oscale = UnsafeAccess.UNSAFE.arrayIndexScale(Object[].class);
    private static final long _kvs_offset = UnsafeAccess.fieldOffset(NonBlockingHashMap.class, "_kvs");
    private transient Object[] _kvs;
    private transient long _last_resize_milli;
    private static final int MIN_SIZE_LOG = 3;
    private static final int MIN_SIZE = 8;
    private static final Object NO_MATCH_OLD = new Object();
    private static final Object MATCH_ANY = new Object();
    private static final Object TOMBSTONE = new Object();
    private static final Prime TOMBPRIME = new Prime(TOMBSTONE);
    private transient ConcurrentAutoTable _reprobes = new ConcurrentAutoTable();

    private static long rawIndex(Object[] objectArray, int n2) {
        assert (n2 >= 0 && n2 < objectArray.length);
        return (long)_Obase + (long)n2 * (long)_Oscale;
    }

    private final boolean CAS_kvs(Object[] objectArray, Object[] objectArray2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(this, _kvs_offset, objectArray, objectArray2);
    }

    private static final int hash(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = System.identityHashCode(object);
        return n2;
    }

    private static final CHM chm(Object[] objectArray) {
        return (CHM)objectArray[0];
    }

    private static final int[] hashes(Object[] objectArray) {
        return (int[])objectArray[1];
    }

    private static final int len(Object[] objectArray) {
        return objectArray.length - 2 >> 1;
    }

    private static final Object key(Object[] objectArray, int n2) {
        return objectArray[(n2 << 1) + 2];
    }

    private static final Object val(Object[] objectArray, int n2) {
        return objectArray[(n2 << 1) + 3];
    }

    private static final boolean CAS_key(Object[] objectArray, int n2, Object object, Object object2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(objectArray, NonBlockingIdentityHashMap.rawIndex(objectArray, (n2 << 1) + 2), object, object2);
    }

    private static final boolean CAS_val(Object[] objectArray, int n2, Object object, Object object2) {
        return UnsafeAccess.UNSAFE.compareAndSwapObject(objectArray, NonBlockingIdentityHashMap.rawIndex(objectArray, (n2 << 1) + 3), object, object2);
    }

    public final void print() {
        System.out.println("=========");
        this.print2(this._kvs);
        System.out.println("=========");
    }

    private final void print(Object[] objectArray) {
        for (int i2 = 0; i2 < NonBlockingIdentityHashMap.len(objectArray); ++i2) {
            Object object = NonBlockingIdentityHashMap.key(objectArray, i2);
            if (object == null) continue;
            String string = object == TOMBSTONE ? "XXX" : object.toString();
            Object object2 = NonBlockingIdentityHashMap.val(objectArray, i2);
            Object object3 = Prime.unbox(object2);
            String string2 = object2 == object3 ? "" : "prime_";
            String string3 = object3 == TOMBSTONE ? "tombstone" : object3.toString();
            System.out.println("" + i2 + " (" + string + "," + string2 + string3 + ")");
        }
        Object[] objectArray2 = NonBlockingIdentityHashMap.chm((Object[])objectArray)._newkvs;
        if (objectArray2 != null) {
            System.out.println("----");
            this.print(objectArray2);
        }
    }

    private final void print2(Object[] objectArray) {
        for (int i2 = 0; i2 < NonBlockingIdentityHashMap.len(objectArray); ++i2) {
            Object object = NonBlockingIdentityHashMap.key(objectArray, i2);
            Object object2 = NonBlockingIdentityHashMap.val(objectArray, i2);
            Object object3 = Prime.unbox(object2);
            if (object == null || object == TOMBSTONE || object2 == null || object3 == TOMBSTONE) continue;
            String string = object2 == object3 ? "" : "prime_";
            System.out.println("" + i2 + " (" + object + "," + string + object2 + ")");
        }
        Object[] objectArray2 = NonBlockingIdentityHashMap.chm((Object[])objectArray)._newkvs;
        if (objectArray2 != null) {
            System.out.println("----");
            this.print2(objectArray2);
        }
    }

    public long reprobes() {
        long l2 = this._reprobes.get();
        this._reprobes = new ConcurrentAutoTable();
        return l2;
    }

    private static final int reprobe_limit(int n2) {
        return 10 + (n2 >> 2);
    }

    public NonBlockingIdentityHashMap() {
        this(8);
    }

    public NonBlockingIdentityHashMap(int n2) {
        this.initialize(n2);
    }

    private final void initialize(int n2) {
        RangeUtil.checkPositiveOrZero(n2, "initial_sz");
        if (n2 > 0x100000) {
            n2 = 0x100000;
        }
        int n3 = 3;
        while (1 << n3 < n2 << 2) {
            ++n3;
        }
        this._kvs = new Object[(1 << n3 << 1) + 2];
        this._kvs[0] = new CHM(new ConcurrentAutoTable());
        this._kvs[1] = new int[1 << n3];
        this._last_resize_milli = System.currentTimeMillis();
    }

    protected final void initialize() {
        this.initialize(8);
    }

    @Override
    public int size() {
        return NonBlockingIdentityHashMap.chm(this._kvs).size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    @Override
    public TypeV put(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, NO_MATCH_OLD);
    }

    @Override
    public TypeV putIfAbsent(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, TOMBSTONE);
    }

    @Override
    public TypeV remove(Object object) {
        return this.putIfMatch(object, TOMBSTONE, NO_MATCH_OLD);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        return NonBlockingIdentityHashMap.objectsEquals(this.putIfMatch(object, TOMBSTONE, object2), object2);
    }

    @Override
    public TypeV replace(TypeK TypeK, TypeV TypeV) {
        return this.putIfMatch(TypeK, TypeV, MATCH_ANY);
    }

    @Override
    public boolean replace(TypeK TypeK, TypeV TypeV, TypeV TypeV2) {
        return NonBlockingIdentityHashMap.objectsEquals(this.putIfMatch(TypeK, TypeV2, TypeV), TypeV);
    }

    private static boolean objectsEquals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private final TypeV putIfMatch(Object object, Object object2, Object object3) {
        if (object3 == null || object2 == null) {
            throw new NullPointerException();
        }
        Object object4 = NonBlockingIdentityHashMap.putIfMatch0(this, this._kvs, object, object2, object3);
        assert (!(object4 instanceof Prime));
        assert (object4 != null);
        return (TypeV)(object4 == TOMBSTONE ? null : object4);
    }

    @Override
    public void putAll(Map<? extends TypeK, ? extends TypeV> map) {
        for (Map.Entry<TypeK, TypeV> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        Object[] objectArray = new NonBlockingIdentityHashMap<TypeK, TypeV>((int)8)._kvs;
        while (!this.CAS_kvs(this._kvs, objectArray)) {
        }
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (TypeV TypeV : this.values()) {
            if (TypeV != object && !TypeV.equals(object)) continue;
            return true;
        }
        return false;
    }

    protected void rehash() {
    }

    @Override
    public Object clone() {
        try {
            NonBlockingIdentityHashMap nonBlockingIdentityHashMap = (NonBlockingIdentityHashMap)super.clone();
            nonBlockingIdentityHashMap.clear();
            for (TypeK TypeK : this.keySet()) {
                TypeV TypeV = this.get(TypeK);
                nonBlockingIdentityHashMap.put(TypeK, TypeV);
            }
            return nonBlockingIdentityHashMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    @Override
    public String toString() {
        Iterator<Map.Entry<TypeK, TypeV>> iterator = this.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<TypeK, TypeV> entry = iterator.next();
            TypeK TypeK = entry.getKey();
            TypeV TypeV = entry.getValue();
            stringBuilder.append((Object)(TypeK == this ? "(this Map)" : TypeK));
            stringBuilder.append('=');
            stringBuilder.append((Object)(TypeV == this ? "(this Map)" : TypeV));
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
        }
    }

    @Override
    public TypeV get(Object object) {
        Object object2 = NonBlockingIdentityHashMap.get_impl(this, this._kvs, object);
        assert (!(object2 instanceof Prime));
        assert (object2 != TOMBSTONE);
        return (TypeV)object2;
    }

    private static final Object get_impl(NonBlockingIdentityHashMap nonBlockingIdentityHashMap, Object[] objectArray, Object object) {
        int n2 = NonBlockingIdentityHashMap.hash(object);
        int n3 = NonBlockingIdentityHashMap.len(objectArray);
        CHM cHM = NonBlockingIdentityHashMap.chm(objectArray);
        int n4 = n2 & n3 - 1;
        int n5 = 0;
        while (true) {
            Object object2 = NonBlockingIdentityHashMap.key(objectArray, n4);
            Object object3 = NonBlockingIdentityHashMap.val(objectArray, n4);
            if (object2 == null) {
                return null;
            }
            Object[] objectArray2 = cHM._newkvs;
            if (object2 == object) {
                if (!(object3 instanceof Prime)) {
                    return object3 == TOMBSTONE ? null : object3;
                }
                return NonBlockingIdentityHashMap.get_impl(nonBlockingIdentityHashMap, cHM.copy_slot_and_check(nonBlockingIdentityHashMap, objectArray, n4, object), object);
            }
            if (++n5 >= NonBlockingIdentityHashMap.reprobe_limit(n3) || object2 == TOMBSTONE) {
                return objectArray2 == null ? null : NonBlockingIdentityHashMap.get_impl(nonBlockingIdentityHashMap, nonBlockingIdentityHashMap.help_copy(objectArray2), object);
            }
            n4 = n4 + 1 & n3 - 1;
        }
    }

    private static final Object putIfMatch0(NonBlockingIdentityHashMap nonBlockingIdentityHashMap, Object[] objectArray, Object object, Object object2, Object object3) {
        int n2;
        assert (object2 != null);
        assert (!(object2 instanceof Prime));
        assert (!(object3 instanceof Prime));
        int n3 = NonBlockingIdentityHashMap.hash(object);
        int n4 = NonBlockingIdentityHashMap.len(objectArray);
        CHM cHM = NonBlockingIdentityHashMap.chm(objectArray);
        int n5 = n3 & n4 - 1;
        int n6 = 0;
        Object object4 = null;
        Object object5 = null;
        Object[] objectArray2 = null;
        while (true) {
            object5 = NonBlockingIdentityHashMap.val(objectArray, n5);
            object4 = NonBlockingIdentityHashMap.key(objectArray, n5);
            if (object4 == null) {
                if (object2 == TOMBSTONE) {
                    return TOMBSTONE;
                }
                if (object3 == MATCH_ANY) {
                    return TOMBSTONE;
                }
                if (NonBlockingIdentityHashMap.CAS_key(objectArray, n5, null, object)) {
                    cHM._slots.add(1L);
                    break;
                }
                n2 = NonBlockingHashMap.DUMMY_VOLATILE;
                continue;
            }
            objectArray2 = cHM._newkvs;
            if (object4 == object) break;
            if (++n6 >= NonBlockingIdentityHashMap.reprobe_limit(n4) || object4 == TOMBSTONE) {
                objectArray2 = cHM.resize(nonBlockingIdentityHashMap, objectArray);
                if (object3 != null) {
                    nonBlockingIdentityHashMap.help_copy(objectArray2);
                }
                return NonBlockingIdentityHashMap.putIfMatch0(nonBlockingIdentityHashMap, objectArray2, object, object2, object3);
            }
            n5 = n5 + 1 & n4 - 1;
        }
        while (true) {
            if (object2 == object5) {
                return object5;
            }
            if (objectArray2 == null && (object5 == null && cHM.tableFull(n6, n4) || object5 instanceof Prime)) {
                objectArray2 = cHM.resize(nonBlockingIdentityHashMap, objectArray);
            }
            if (objectArray2 != null) {
                return NonBlockingIdentityHashMap.putIfMatch0(nonBlockingIdentityHashMap, cHM.copy_slot_and_check(nonBlockingIdentityHashMap, objectArray, n5, object3), object, object2, object3);
            }
            assert (!(object5 instanceof Prime));
            if (!(object3 == NO_MATCH_OLD || object5 == object3 || object3 == MATCH_ANY && object5 != TOMBSTONE && object5 != null || object5 == null && object3 == TOMBSTONE || object3 != null && object3.equals(object5))) {
                return object5 == null ? TOMBSTONE : object5;
            }
            if (NonBlockingIdentityHashMap.CAS_val(objectArray, n5, object5, object2)) break;
            object5 = NonBlockingIdentityHashMap.val(objectArray, n5);
            if (object5 instanceof Prime) {
                return NonBlockingIdentityHashMap.putIfMatch0(nonBlockingIdentityHashMap, cHM.copy_slot_and_check(nonBlockingIdentityHashMap, objectArray, n5, object3), object, object2, object3);
            }
            n2 = NonBlockingHashMap.DUMMY_VOLATILE;
        }
        if (object3 != null) {
            if ((object5 == null || object5 == TOMBSTONE) && object2 != TOMBSTONE) {
                cHM._size.add(1L);
            }
            if (object5 != null && object5 != TOMBSTONE && object2 == TOMBSTONE) {
                cHM._size.add(-1L);
            }
        }
        return object5 == null && object3 != null ? TOMBSTONE : object5;
    }

    private final Object[] help_copy(Object[] objectArray) {
        Object[] objectArray2 = this._kvs;
        CHM cHM = NonBlockingIdentityHashMap.chm(objectArray2);
        if (cHM._newkvs == null) {
            return objectArray;
        }
        cHM.help_copy_impl(this, objectArray2, false);
        return objectArray;
    }

    public Enumeration<TypeV> elements() {
        return new SnapshotV();
    }

    @Override
    public Collection<TypeV> values() {
        return new AbstractCollection<TypeV>(){

            @Override
            public void clear() {
                NonBlockingIdentityHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingIdentityHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingIdentityHashMap.this.containsValue(object);
            }

            @Override
            public Iterator<TypeV> iterator() {
                return new SnapshotV();
            }
        };
    }

    public Enumeration<TypeK> keys() {
        return new SnapshotK();
    }

    @Override
    public Set<TypeK> keySet() {
        return new AbstractSet<TypeK>(){

            @Override
            public void clear() {
                NonBlockingIdentityHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingIdentityHashMap.this.size();
            }

            @Override
            public boolean contains(Object object) {
                return NonBlockingIdentityHashMap.this.containsKey(object);
            }

            @Override
            public boolean remove(Object object) {
                return NonBlockingIdentityHashMap.this.remove(object) != null;
            }

            @Override
            public Iterator<TypeK> iterator() {
                return new SnapshotK();
            }
        };
    }

    @Override
    public Set<Map.Entry<TypeK, TypeV>> entrySet() {
        return new AbstractSet<Map.Entry<TypeK, TypeV>>(){

            @Override
            public void clear() {
                NonBlockingIdentityHashMap.this.clear();
            }

            @Override
            public int size() {
                return NonBlockingIdentityHashMap.this.size();
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                return NonBlockingIdentityHashMap.this.remove(entry.getKey(), entry.getValue());
            }

            @Override
            public boolean contains(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)object;
                Object TypeV = NonBlockingIdentityHashMap.this.get(entry.getKey());
                return TypeV != null && TypeV.equals(entry.getValue());
            }

            @Override
            public Iterator<Map.Entry<TypeK, TypeV>> iterator() {
                return new SnapshotE();
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (TypeK TypeK : this.keySet()) {
            TypeV TypeV = this.get(TypeK);
            objectOutputStream.writeObject(TypeK);
            objectOutputStream.writeObject(TypeV);
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.initialize(8);
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put((TypeK)object, (TypeV)object2);
        }
    }

    private class SnapshotE
    implements Iterator<Map.Entry<TypeK, TypeV>> {
        final SnapshotV _ss;

        public SnapshotE() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public Map.Entry<TypeK, TypeV> next() {
            this._ss.next();
            return new NBHMEntry(this._ss._prevK, this._ss._prevV);
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }
    }

    private class NBHMEntry
    extends AbstractEntry<TypeK, TypeV> {
        NBHMEntry(TypeK TypeK, TypeV TypeV) {
            super(TypeK, TypeV);
        }

        @Override
        public TypeV setValue(TypeV TypeV) {
            if (TypeV == null) {
                throw new NullPointerException();
            }
            this._val = TypeV;
            return NonBlockingIdentityHashMap.this.put(this._key, TypeV);
        }
    }

    private class SnapshotK
    implements Enumeration<TypeK>,
    Iterator<TypeK> {
        final SnapshotV _ss;

        public SnapshotK() {
            this._ss = new SnapshotV();
        }

        @Override
        public void remove() {
            this._ss.removeKey();
        }

        @Override
        public TypeK next() {
            this._ss.next();
            return this._ss._prevK;
        }

        @Override
        public boolean hasNext() {
            return this._ss.hasNext();
        }

        @Override
        public TypeK nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private class SnapshotV
    implements Enumeration<TypeV>,
    Iterator<TypeV> {
        final Object[] _sskvs;
        private int _idx;
        private Object _nextK;
        private Object _prevK;
        private TypeV _nextV;
        private TypeV _prevV;

        public SnapshotV() {
            Object[] objectArray;
            while (true) {
                objectArray = NonBlockingIdentityHashMap.this._kvs;
                CHM cHM = NonBlockingIdentityHashMap.chm(objectArray);
                if (cHM._newkvs == null) break;
                cHM.help_copy_impl(NonBlockingIdentityHashMap.this, objectArray, true);
            }
            this._sskvs = objectArray;
            this.next();
        }

        int length() {
            return NonBlockingIdentityHashMap.len(this._sskvs);
        }

        Object key(int n2) {
            return NonBlockingIdentityHashMap.key(this._sskvs, n2);
        }

        @Override
        public boolean hasNext() {
            return this._nextV != null;
        }

        @Override
        public TypeV next() {
            if (this._idx != 0 && this._nextV == null) {
                throw new NoSuchElementException();
            }
            this._prevK = this._nextK;
            this._prevV = this._nextV;
            this._nextV = null;
            while (this._idx < this.length()) {
                this._nextK = this.key(this._idx++);
                if (this._nextK == null || this._nextK == TOMBSTONE || (this._nextV = NonBlockingIdentityHashMap.this.get(this._nextK)) == null) continue;
                break;
            }
            return this._prevV;
        }

        public void removeKey() {
            if (this._prevV == null) {
                throw new IllegalStateException();
            }
            NonBlockingIdentityHashMap.this.putIfMatch(this._prevK, TOMBSTONE, NO_MATCH_OLD);
            this._prevV = null;
        }

        @Override
        public void remove() {
            this.removeKey();
        }

        @Override
        public TypeV nextElement() {
            return this.next();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }
    }

    private static final class CHM<TypeK, TypeV> {
        private final ConcurrentAutoTable _size;
        private final ConcurrentAutoTable _slots;
        volatile Object[] _newkvs;
        private static final AtomicReferenceFieldUpdater<CHM, Object[]> _newkvsUpdater = AtomicReferenceFieldUpdater.newUpdater(CHM.class, Object[].class, "_newkvs");
        volatile long _resizers;
        private static final AtomicLongFieldUpdater<CHM> _resizerUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_resizers");
        volatile long _copyIdx = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyIdxUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyIdx");
        volatile long _copyDone = 0L;
        private static final AtomicLongFieldUpdater<CHM> _copyDoneUpdater = AtomicLongFieldUpdater.newUpdater(CHM.class, "_copyDone");

        public int size() {
            return (int)this._size.get();
        }

        public int slots() {
            return (int)this._slots.get();
        }

        boolean CAS_newkvs(Object[] objectArray) {
            while (this._newkvs == null) {
                if (!_newkvsUpdater.compareAndSet(this, null, objectArray)) continue;
                return true;
            }
            return false;
        }

        CHM(ConcurrentAutoTable concurrentAutoTable) {
            this._size = concurrentAutoTable;
            this._slots = new ConcurrentAutoTable();
        }

        private final boolean tableFull(int n2, int n3) {
            return n2 >= 10 && this._slots.estimate_get() >= (long)NonBlockingIdentityHashMap.reprobe_limit(n3);
        }

        private final Object[] resize(NonBlockingIdentityHashMap nonBlockingIdentityHashMap, Object[] objectArray) {
            int n2;
            assert (NonBlockingIdentityHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            if (objectArray2 != null) {
                return objectArray2;
            }
            int n3 = NonBlockingIdentityHashMap.len(objectArray);
            int n4 = n2 = this.size();
            if (n2 >= n3 >> 2) {
                n4 = n3 << 1;
                if (n2 >= n3 >> 1) {
                    n4 = n3 << 2;
                }
            }
            long l2 = System.currentTimeMillis();
            long l3 = 0L;
            if (n4 <= n3 && l2 <= nonBlockingIdentityHashMap._last_resize_milli + 10000L && (l3 = this._slots.estimate_get()) >= (long)(n2 << 1)) {
                n4 = n3 << 1;
            }
            if (n4 < n3) {
                n4 = n3;
            }
            int n5 = 3;
            while (1 << n5 < n4) {
                ++n5;
            }
            long l4 = this._resizers;
            while (!_resizerUpdater.compareAndSet(this, l4, l4 + 1L)) {
                l4 = this._resizers;
            }
            int n6 = (1 << n5 << 1) + 4 << 3 >> 20;
            if (l4 >= 2L && n6 > 0) {
                objectArray2 = this._newkvs;
                if (objectArray2 != null) {
                    return objectArray2;
                }
                try {
                    Thread.sleep(8L * (long)n6);
                }
                catch (Exception exception) {
                    Throwables.throwIfCritical(exception);
                    Exception exception2 = exception;
                }
            }
            if ((objectArray2 = this._newkvs) != null) {
                return objectArray2;
            }
            objectArray2 = new Object[(1 << n5 << 1) + 2];
            objectArray2[0] = new CHM<TypeK, TypeV>(this._size);
            objectArray2[1] = new int[1 << n5];
            if (this._newkvs != null) {
                return this._newkvs;
            }
            if (this.CAS_newkvs(objectArray2)) {
                nonBlockingIdentityHashMap.rehash();
            } else {
                objectArray2 = this._newkvs;
            }
            return objectArray2;
        }

        private final void help_copy_impl(NonBlockingIdentityHashMap nonBlockingIdentityHashMap, Object[] objectArray, boolean bl2) {
            assert (NonBlockingIdentityHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            assert (objectArray2 != null);
            int n2 = NonBlockingIdentityHashMap.len(objectArray);
            int n3 = Math.min(n2, 1024);
            int n4 = -1;
            int n5 = -9999;
            while (this._copyDone < (long)n2) {
                if (n4 == -1) {
                    n5 = (int)this._copyIdx;
                    while (n5 < n2 << 1 && !_copyIdxUpdater.compareAndSet(this, n5, n5 + n3)) {
                        n5 = (int)this._copyIdx;
                    }
                    if (n5 >= n2 << 1) {
                        n4 = n5;
                    }
                }
                int n6 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (!this.copy_slot(nonBlockingIdentityHashMap, n5 + i2 & n2 - 1, objectArray, objectArray2)) continue;
                    ++n6;
                }
                if (n6 > 0) {
                    this.copy_check_and_promote(nonBlockingIdentityHashMap, objectArray, n6);
                }
                n5 += n3;
                if (bl2 || n4 != -1) continue;
                return;
            }
            this.copy_check_and_promote(nonBlockingIdentityHashMap, objectArray, 0);
        }

        private final Object[] copy_slot_and_check(NonBlockingIdentityHashMap nonBlockingIdentityHashMap, Object[] objectArray, int n2, Object object) {
            assert (NonBlockingIdentityHashMap.chm(objectArray) == this);
            Object[] objectArray2 = this._newkvs;
            assert (objectArray2 != null);
            if (this.copy_slot(nonBlockingIdentityHashMap, n2, objectArray, this._newkvs)) {
                this.copy_check_and_promote(nonBlockingIdentityHashMap, objectArray, 1);
            }
            return object == null ? objectArray2 : nonBlockingIdentityHashMap.help_copy(objectArray2);
        }

        private final void copy_check_and_promote(NonBlockingIdentityHashMap nonBlockingIdentityHashMap, Object[] objectArray, int n2) {
            assert (NonBlockingIdentityHashMap.chm(objectArray) == this);
            int n3 = NonBlockingIdentityHashMap.len(objectArray);
            long l2 = this._copyDone;
            assert (l2 + (long)n2 <= (long)n3);
            if (n2 > 0) {
                while (!_copyDoneUpdater.compareAndSet(this, l2, l2 + (long)n2)) {
                    l2 = this._copyDone;
                    assert (l2 + (long)n2 <= (long)n3);
                }
            }
            if (l2 + (long)n2 == (long)n3 && nonBlockingIdentityHashMap._kvs == objectArray && nonBlockingIdentityHashMap.CAS_kvs(objectArray, this._newkvs)) {
                nonBlockingIdentityHashMap._last_resize_milli = System.currentTimeMillis();
            }
        }

        private boolean copy_slot(NonBlockingIdentityHashMap nonBlockingIdentityHashMap, int n2, Object[] objectArray, Object[] objectArray2) {
            Object object;
            Object object2;
            while ((object2 = NonBlockingIdentityHashMap.key(objectArray, n2)) == null) {
                NonBlockingIdentityHashMap.CAS_key(objectArray, n2, null, TOMBSTONE);
            }
            Object object3 = NonBlockingIdentityHashMap.val(objectArray, n2);
            while (!(object3 instanceof Prime)) {
                Object object4 = object = object3 == null || object3 == TOMBSTONE ? TOMBPRIME : new Prime(object3);
                if (NonBlockingIdentityHashMap.CAS_val(objectArray, n2, object3, object)) {
                    if (object == TOMBPRIME) {
                        return true;
                    }
                    object3 = object;
                    break;
                }
                object3 = NonBlockingIdentityHashMap.val(objectArray, n2);
            }
            if (object3 == TOMBPRIME) {
                return false;
            }
            object = ((Prime)object3)._V;
            assert (object != TOMBSTONE);
            NonBlockingIdentityHashMap.putIfMatch0(nonBlockingIdentityHashMap, objectArray2, object2, object, null);
            while (object3 != TOMBPRIME && !NonBlockingIdentityHashMap.CAS_val(objectArray, n2, object3, TOMBPRIME)) {
                object3 = NonBlockingIdentityHashMap.val(objectArray, n2);
            }
            return object3 != TOMBPRIME;
        }
    }

    private static final class Prime {
        final Object _V;

        Prime(Object object) {
            this._V = object;
        }

        static Object unbox(Object object) {
            return object instanceof Prime ? ((Prime)object)._V : object;
        }
    }
}

