/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omp.core.buffer;

import com.contrastsecurity.thirdparty.omp.core.Preconditions;
import com.contrastsecurity.thirdparty.omp.core.buffer.MessageBuffer;
import com.contrastsecurity.thirdparty.omp.core.buffer.MessageBufferInput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ChannelBufferInput
implements MessageBufferInput {
    private ReadableByteChannel channel;
    private final MessageBuffer buffer;

    public ChannelBufferInput(ReadableByteChannel readableByteChannel) {
        this(readableByteChannel, 8192);
    }

    public ChannelBufferInput(ReadableByteChannel readableByteChannel, int n2) {
        this.channel = Preconditions.checkNotNull(readableByteChannel, "input channel is null");
        Preconditions.checkArgument(n2 > 0, "buffer size must be > 0: " + n2);
        this.buffer = MessageBuffer.allocate(n2);
    }

    public ReadableByteChannel reset(ReadableByteChannel readableByteChannel) throws IOException {
        ReadableByteChannel readableByteChannel2 = this.channel;
        this.channel = readableByteChannel;
        return readableByteChannel2;
    }

    @Override
    public MessageBuffer next() throws IOException {
        ByteBuffer byteBuffer = this.buffer.sliceAsByteBuffer();
        int n2 = this.channel.read(byteBuffer);
        if (n2 == -1) {
            return null;
        }
        byteBuffer.flip();
        return this.buffer.slice(0, byteBuffer.limit());
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

