/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omp.core.buffer;

import com.contrastsecurity.thirdparty.omp.core.Preconditions;
import com.contrastsecurity.thirdparty.omp.core.buffer.MessageBuffer;
import java.nio.ByteBuffer;

public class MessageBufferU
extends MessageBuffer {
    private final ByteBuffer wrap;

    MessageBufferU(byte[] byArray, int n2, int n3) {
        super(byArray, n2, n3);
        this.wrap = ByteBuffer.wrap(byArray, n2, n3).slice();
    }

    MessageBufferU(ByteBuffer byteBuffer) {
        super(byteBuffer);
        this.wrap = byteBuffer.slice();
    }

    private MessageBufferU(Object object, long l2, int n2, ByteBuffer byteBuffer) {
        super(object, l2, n2);
        this.wrap = byteBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessageBufferU slice(int n2, int n3) {
        if (n2 == 0 && n3 == this.size()) {
            return this;
        }
        Preconditions.checkArgument(n2 + n3 <= this.size());
        try {
            this.wrap.position(n2);
            this.wrap.limit(n2 + n3);
            MessageBufferU messageBufferU = new MessageBufferU(this.base, this.address + (long)n2, n3, this.wrap.slice());
            return messageBufferU;
        }
        finally {
            this.resetBufferPosition();
        }
    }

    private void resetBufferPosition() {
        this.wrap.position(0);
        this.wrap.limit(this.size);
    }

    @Override
    public byte getByte(int n2) {
        return this.wrap.get(n2);
    }

    @Override
    public boolean getBoolean(int n2) {
        return this.wrap.get(n2) != 0;
    }

    @Override
    public short getShort(int n2) {
        return this.wrap.getShort(n2);
    }

    @Override
    public int getInt(int n2) {
        return this.wrap.getInt(n2);
    }

    @Override
    public float getFloat(int n2) {
        return this.wrap.getFloat(n2);
    }

    @Override
    public long getLong(int n2) {
        return this.wrap.getLong(n2);
    }

    @Override
    public double getDouble(int n2) {
        return this.wrap.getDouble(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int n2, int n3, ByteBuffer byteBuffer) {
        try {
            this.wrap.position(n2);
            this.wrap.limit(n2 + n3);
            byteBuffer.put(this.wrap);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    @Override
    public void putByte(int n2, byte by2) {
        this.wrap.put(n2, by2);
    }

    @Override
    public void putBoolean(int n2, boolean bl2) {
        this.wrap.put(n2, bl2 ? (byte)1 : 0);
    }

    @Override
    public void putShort(int n2, short s2) {
        this.wrap.putShort(n2, s2);
    }

    @Override
    public void putInt(int n2, int n3) {
        this.wrap.putInt(n2, n3);
    }

    @Override
    public void putFloat(int n2, float f2) {
        this.wrap.putFloat(n2, f2);
    }

    @Override
    public void putLong(int n2, long l2) {
        this.wrap.putLong(n2, l2);
    }

    @Override
    public void putDouble(int n2, double d2) {
        this.wrap.putDouble(n2, d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer sliceAsByteBuffer(int n2, int n3) {
        try {
            this.wrap.position(n2);
            this.wrap.limit(n2 + n3);
            ByteBuffer byteBuffer = this.wrap.slice();
            return byteBuffer;
        }
        finally {
            this.resetBufferPosition();
        }
    }

    @Override
    public ByteBuffer sliceAsByteBuffer() {
        return this.sliceAsByteBuffer(0, this.size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getBytes(int n2, byte[] byArray, int n3, int n4) {
        try {
            this.wrap.position(n2);
            this.wrap.get(byArray, n3, n4);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putByteBuffer(int n2, ByteBuffer byteBuffer, int n3) {
        assert (n3 <= byteBuffer.remaining());
        if (byteBuffer.hasArray()) {
            this.putBytes(n2, byteBuffer.array(), byteBuffer.position() + byteBuffer.arrayOffset(), n3);
            byteBuffer.position(byteBuffer.position() + n3);
        } else {
            int n4 = byteBuffer.limit();
            try {
                byteBuffer.limit(byteBuffer.position() + n3);
                this.wrap.position(n2);
                this.wrap.put(byteBuffer);
            }
            finally {
                byteBuffer.limit(n4);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putBytes(int n2, byte[] byArray, int n3, int n4) {
        try {
            this.wrap.position(n2);
            this.wrap.put(byArray, n3, n4);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void copyTo(int n2, MessageBuffer messageBuffer, int n3, int n4) {
        try {
            this.wrap.position(n2);
            messageBuffer.putByteBuffer(n3, this.wrap, n4);
        }
        finally {
            this.resetBufferPosition();
        }
    }

    @Override
    public void putMessageBuffer(int n2, MessageBuffer messageBuffer, int n3, int n4) {
        this.putByteBuffer(n2, messageBuffer.sliceAsByteBuffer(n3, n4), n4);
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = new byte[this.size()];
        this.getBytes(0, byArray, 0, byArray.length);
        return byArray;
    }

    @Override
    public boolean hasArray() {
        return !this.wrap.isDirect();
    }

    @Override
    public byte[] array() {
        return this.hasArray() ? this.wrap.array() : null;
    }
}

