/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omp.value.impl;

import com.contrastsecurity.thirdparty.omp.core.MessagePacker;
import com.contrastsecurity.thirdparty.omp.value.ImmutableFloatValue;
import com.contrastsecurity.thirdparty.omp.value.ImmutableNumberValue;
import com.contrastsecurity.thirdparty.omp.value.Value;
import com.contrastsecurity.thirdparty.omp.value.ValueType;
import com.contrastsecurity.thirdparty.omp.value.impl.AbstractImmutableValue;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class ImmutableDoubleValueImpl
extends AbstractImmutableValue
implements ImmutableFloatValue {
    private final double value;

    public ImmutableDoubleValueImpl(double d2) {
        this.value = d2;
    }

    @Override
    public ValueType getValueType() {
        return ValueType.FLOAT;
    }

    @Override
    public ImmutableDoubleValueImpl immutableValue() {
        return this;
    }

    @Override
    public ImmutableNumberValue asNumberValue() {
        return this;
    }

    @Override
    public ImmutableFloatValue asFloatValue() {
        return this;
    }

    @Override
    public byte toByte() {
        return (byte)this.value;
    }

    @Override
    public short toShort() {
        return (short)this.value;
    }

    @Override
    public int toInt() {
        return (int)this.value;
    }

    @Override
    public long toLong() {
        return (long)this.value;
    }

    @Override
    public BigInteger toBigInteger() {
        return new BigDecimal(this.value).toBigInteger();
    }

    @Override
    public float toFloat() {
        return (float)this.value;
    }

    @Override
    public double toDouble() {
        return this.value;
    }

    @Override
    public void writeTo(MessagePacker messagePacker) throws IOException {
        messagePacker.packDouble(this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Value)) {
            return false;
        }
        Value value = (Value)object;
        if (!value.isFloatValue()) {
            return false;
        }
        return this.value == value.asFloatValue().toDouble();
    }

    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.value);
        return (int)(l2 ^ l2 >>> 32);
    }

    @Override
    public String toJson() {
        if (Double.isNaN(this.value) || Double.isInfinite(this.value)) {
            return "null";
        }
        return Double.toString(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }
}

