/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2;

import com.contrastsecurity.thirdparty.omv2.ErrorDetail;
import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.util.ParseTools;
import com.contrastsecurity.thirdparty.omv2.util.StringAppender;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileException
extends RuntimeException {
    private char[] expr;
    private int cursor = 0;
    private int msgOffset = 0;
    private int lineNumber = 1;
    private int column = 0;
    private int lastLineStart = 0;
    private List<ErrorDetail> errors;
    private Object evaluationContext;

    public CompileException(String string, List<ErrorDetail> list, char[] cArray, int n2, ParserContext parserContext) {
        super(string);
        this.expr = cArray;
        this.cursor = n2;
        if (!list.isEmpty()) {
            ErrorDetail errorDetail = list.iterator().next();
            this.cursor = errorDetail.getCursor();
            this.lineNumber = errorDetail.getLineNumber();
            this.column = errorDetail.getColumn();
        }
        this.errors = list;
    }

    public void setEvaluationContext(Object object) {
        this.evaluationContext = object;
    }

    @Override
    public String toString() {
        return this.generateErrorMessage();
    }

    public CompileException(String string, char[] cArray, int n2, Throwable throwable) {
        super(string, throwable);
        this.expr = cArray;
        this.cursor = n2;
    }

    public CompileException(String string, char[] cArray, int n2) {
        super(string);
        this.expr = cArray;
        this.cursor = n2;
    }

    @Override
    public String getMessage() {
        return this.generateErrorMessage();
    }

    private void calcRowAndColumn() {
        if (this.lineNumber > 1 || this.column > 1) {
            return;
        }
        int n2 = 1;
        int n3 = 1;
        if (this.lineNumber != 0 && this.column != 0 || this.expr == null || this.expr.length == 0) {
            return;
        }
        block4: for (int i2 = 0; i2 < this.cursor && i2 < this.expr.length; ++i2) {
            switch (this.expr[i2]) {
                case '\r': {
                    continue block4;
                }
                case '\n': {
                    ++n2;
                    n3 = 1;
                    continue block4;
                }
                default: {
                    ++n3;
                }
            }
        }
        this.lineNumber = n2;
        this.column = n3;
    }

    private CharSequence showCodeNearError(char[] cArray, int n2) {
        int n3;
        if (cArray == null) {
            return "Unknown";
        }
        int n4 = n2 - 20;
        int n5 = n2 + 30;
        if (n5 > cArray.length) {
            n5 = cArray.length;
            n4 -= 30;
        }
        if (n4 < 0) {
            n4 = 0;
        }
        String string = String.copyValueOf(cArray, n4, n5 - n4).trim();
        int n6 = -1;
        int n7 = 0;
        String string2 = null;
        if (n2 < n5) {
            n6 = n2;
            if (n6 > 0) {
                while (n6 > 0 && !ParseTools.isWhitespace(cArray[n6 - 1])) {
                    --n6;
                }
            }
            n7 = n2 - n6;
            string2 = new String(cArray, n6, cArray.length - n6);
            block6: for (n3 = 0; n3 < string2.length(); ++n3) {
                switch (string2.charAt(n3)) {
                    case '\n': 
                    case ')': {
                        string2 = string2.substring(0, n3);
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            if (string2.length() >= 30) {
                string2 = string2.substring(0, 30);
            }
        }
        while (true) {
            int n8 = string.indexOf(10);
            int n9 = string.lastIndexOf(10);
            if (n8 == -1) break;
            int n10 = n3 = string2 == null ? 0 : string.indexOf(string2);
            if (n8 != -1 && n8 == n9) {
                if (n8 > n3) {
                    string = string.substring(0, n8);
                    continue;
                }
                if (n8 >= n3) continue;
                string = string.substring(n8 + 1, string.length());
                continue;
            }
            if (n8 < n3) {
                string = string.substring(n8 + 1, n9);
                continue;
            }
            string = string.substring(0, n8);
        }
        String string3 = string.trim();
        this.msgOffset = string2 != null ? string3.indexOf(string2) + n7 : string.length() - (string.length() - string3.length());
        if (this.msgOffset == 0 && n7 == 0) {
            this.msgOffset = n2;
        }
        return string3;
    }

    public CharSequence getCodeNearError() {
        return this.showCodeNearError(this.expr, this.cursor);
    }

    private String generateErrorMessage() {
        StringAppender stringAppender = new StringAppender().append("[Error: " + super.getMessage() + "]\n");
        int n2 = stringAppender.length();
        stringAppender.append("[Near : {... ");
        n2 = stringAppender.length() - n2;
        stringAppender.append(this.showCodeNearError(this.expr, this.cursor)).append(" ....}]\n").append(ParseTools.repeatChar(' ', n2));
        if (this.msgOffset < 0) {
            this.msgOffset = 0;
        }
        stringAppender.append(ParseTools.repeatChar(' ', this.msgOffset)).append('^');
        this.calcRowAndColumn();
        if (this.evaluationContext != null) {
            stringAppender.append("\n").append("In ").append(this.evaluationContext);
        } else if (this.lineNumber != -1) {
            stringAppender.append("\n").append("[Line: " + this.lineNumber + ", Column: " + this.column + "]");
        }
        return stringAppender.toString();
    }

    public char[] getExpr() {
        return this.expr;
    }

    public int getCursor() {
        return this.cursor;
    }

    public List<ErrorDetail> getErrors() {
        return this.errors != null ? this.errors : Collections.emptyList();
    }

    public void setErrors(List<ErrorDetail> list) {
        this.errors = list;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int n2) {
        this.lineNumber = n2;
    }

    public int getColumn() {
        return this.column;
    }

    public void setColumn(int n2) {
        this.column = n2;
    }

    public int getCursorOffet() {
        return this.msgOffset;
    }

    public void setExpr(char[] cArray) {
        this.expr = cArray;
    }

    public void setCursor(int n2) {
        this.cursor = n2;
    }

    public int getLastLineStart() {
        return this.lastLineStart;
    }

    public void setLastLineStart(int n2) {
        this.lastLineStart = n2;
    }
}

