/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.optimizers.dynamic;

import com.contrastsecurity.thirdparty.omv2.ParserContext;
import com.contrastsecurity.thirdparty.omv2.compiler.Accessor;
import com.contrastsecurity.thirdparty.omv2.integration.VariableResolverFactory;
import com.contrastsecurity.thirdparty.omv2.optimizers.AccessorOptimizer;
import com.contrastsecurity.thirdparty.omv2.optimizers.OptimizationNotSupported;
import com.contrastsecurity.thirdparty.omv2.optimizers.OptimizerFactory;
import com.contrastsecurity.thirdparty.omv2.optimizers.dynamic.DynamicAccessor;
import com.contrastsecurity.thirdparty.omv2.optimizers.dynamic.DynamicOptimizer;

public class DynamicGetAccessor
implements DynamicAccessor {
    private char[] expr;
    private int start;
    private int offset;
    private long stamp;
    private int type;
    private int runcount;
    private boolean opt = false;
    private ParserContext pCtx;
    private Accessor _safeAccessor;
    private Accessor _accessor;

    public DynamicGetAccessor(ParserContext parserContext, char[] cArray, int n2, int n3, int n4, Accessor accessor) {
        this._safeAccessor = this._accessor = accessor;
        this.type = n4;
        this.expr = cArray;
        this.start = n2;
        this.offset = n3;
        this.pCtx = parserContext;
        this.stamp = System.currentTimeMillis();
    }

    public Object getValue(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                try {
                    return this.optimize(object, object2, variableResolverFactory);
                }
                catch (OptimizationNotSupported optimizationNotSupported) {
                }
            } else {
                this.runcount = 0;
                this.stamp = System.currentTimeMillis();
            }
        }
        return this._accessor.getValue(object, object2, variableResolverFactory);
    }

    public Object setValue(Object object, Object object2, VariableResolverFactory variableResolverFactory, Object object3) {
        ++this.runcount;
        return this._accessor.setValue(object, object2, variableResolverFactory, object3);
    }

    private Object optimize(Object object, Object object2, VariableResolverFactory variableResolverFactory) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        AccessorOptimizer accessorOptimizer = OptimizerFactory.getAccessorCompiler("ASM");
        switch (this.type) {
            case 0: {
                this._accessor = accessorOptimizer.optimizeAccessor(this.pCtx, this.expr, this.start, this.offset, object, object2, variableResolverFactory, false, null);
                return accessorOptimizer.getResultOptPass();
            }
            case 3: {
                this._accessor = accessorOptimizer.optimizeObjectCreation(this.pCtx, this.expr, this.start, this.offset, object, object2, variableResolverFactory);
                return this._accessor.getValue(object, object2, variableResolverFactory);
            }
            case 2: {
                this._accessor = accessorOptimizer.optimizeCollection(this.pCtx, object, null, this.expr, this.start, this.offset, object, object2, variableResolverFactory);
                return this._accessor.getValue(object, object2, variableResolverFactory);
            }
        }
        return null;
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public long getStamp() {
        return this.stamp;
    }

    public int getRuncount() {
        return this.runcount;
    }

    public Class getKnownEgressType() {
        return this._safeAccessor.getKnownEgressType();
    }

    public Accessor getAccessor() {
        return this._accessor;
    }

    public Accessor getSafeAccessor() {
        return this._safeAccessor;
    }
}

