/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.omv2.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndexHashMapWrapper<K, V>
implements Map<K, V> {
    private int indexCounter;
    private final Map<K, ValueContainer<K, V>> wrappedMap;
    private final ArrayList<ValueContainer<K, V>> indexBasedLookup;

    public SimpleIndexHashMapWrapper() {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>();
        this.indexBasedLookup = new ArrayList();
    }

    public SimpleIndexHashMapWrapper(SimpleIndexHashMapWrapper<K, V> simpleIndexHashMapWrapper, boolean bl2) {
        this.indexBasedLookup = new ArrayList(simpleIndexHashMapWrapper.indexBasedLookup.size());
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>();
        int n2 = 0;
        if (bl2) {
            for (ValueContainer<K, V> valueContainer : simpleIndexHashMapWrapper.indexBasedLookup) {
                ValueContainer<K, Object> valueContainer2 = new ValueContainer<K, Object>(n2++, valueContainer.getKey(), null);
                this.indexBasedLookup.add(valueContainer2);
                this.wrappedMap.put(valueContainer.getKey(), valueContainer2);
            }
        } else {
            for (ValueContainer<K, V> valueContainer : simpleIndexHashMapWrapper.indexBasedLookup) {
                ValueContainer<K, V> valueContainer3 = new ValueContainer<K, V>(n2++, valueContainer.getKey(), valueContainer.getValue());
                this.indexBasedLookup.add(valueContainer3);
                this.wrappedMap.put(valueContainer.getKey(), valueContainer3);
            }
        }
    }

    public SimpleIndexHashMapWrapper(K[] KArray) {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>(KArray.length * 2);
        this.indexBasedLookup = new ArrayList(KArray.length);
        this.initWithKeys(KArray);
    }

    public SimpleIndexHashMapWrapper(K[] KArray, int n2, float f2) {
        this.wrappedMap = new HashMap<K, ValueContainer<K, V>>(n2 * 2, f2);
        this.indexBasedLookup = new ArrayList(n2);
        this.initWithKeys(KArray);
    }

    public void initWithKeys(K[] KArray) {
        int n2 = 0;
        for (K k2 : KArray) {
            ValueContainer<K, Object> valueContainer = new ValueContainer<K, Object>(n2++, k2, null);
            this.wrappedMap.put(k2, valueContainer);
            this.indexBasedLookup.add(valueContainer);
        }
    }

    public void addKey(K k2) {
        ValueContainer<K, Object> valueContainer = new ValueContainer<K, Object>(this.indexCounter++, k2, null);
        this.indexBasedLookup.add(valueContainer);
        this.wrappedMap.put(k2, valueContainer);
    }

    public void addKey(K k2, V v2) {
        ValueContainer<K, V> valueContainer = new ValueContainer<K, V>(this.indexCounter++, k2, v2);
        this.indexBasedLookup.add(valueContainer);
        this.wrappedMap.put(k2, valueContainer);
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object object) {
        return this.wrappedMap.containsKey(object);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.wrappedMap.containsValue(object);
    }

    @Override
    public V get(Object object) {
        return this.wrappedMap.get(object).getValue();
    }

    public V getByIndex(int n2) {
        return this.indexBasedLookup.get(n2).getValue();
    }

    public K getKeyAtIndex(int n2) {
        return this.indexBasedLookup.get(n2).getKey();
    }

    public int indexOf(K k2) {
        return this.wrappedMap.get(k2).getIndex();
    }

    @Override
    public V put(K k2, V v2) {
        ValueContainer<K, V> valueContainer = this.wrappedMap.get(k2);
        if (valueContainer == null) {
            throw new RuntimeException("cannot add a new entry.  you must allocate a new key with addKey() first.");
        }
        this.indexBasedLookup.add(valueContainer);
        return this.wrappedMap.put(k2, valueContainer).getValue();
    }

    public void putAtIndex(int n2, V v2) {
        ValueContainer<K, V> valueContainer = this.indexBasedLookup.get(n2);
        valueContainer.setValue(v2);
    }

    @Override
    public V remove(Object object) {
        throw new UnsupportedOperationException("cannot remove keys");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("cannot clear map");
    }

    @Override
    public Set<K> keySet() {
        return this.wrappedMap.keySet();
    }

    @Override
    public Collection<V> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValueContainer<K, V> {
        private int index;
        private K key;
        private V value;

        public ValueContainer(int n2, K k2, V v2) {
            this.index = n2;
            this.key = k2;
            this.value = v2;
        }

        public int getIndex() {
            return this.index;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        void setKey(K k2) {
            this.key = k2;
        }

        void setValue(V v2) {
            this.value = v2;
        }
    }
}

