/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oobjw.asm.tree;

import com.contrastsecurity.thirdparty.oobjw.asm.MethodVisitor;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.AbstractInsnNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.LabelNode;
import com.contrastsecurity.thirdparty.oobjw.asm.tree.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(-1);
    }

    public FrameNode(int n2, int n3, Object[] objectArray, int n4, Object[] objectArray2) {
        super(-1);
        this.type = n2;
        switch (n2) {
            case -1: 
            case 0: {
                this.local = Util.asArrayList(n3, objectArray);
                this.stack = Util.asArrayList(n4, objectArray2);
                break;
            }
            case 1: {
                this.local = Util.asArrayList(n3, objectArray);
                break;
            }
            case 2: {
                this.local = Util.asArrayList(n3);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = Util.asArrayList(1, objectArray2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        switch (this.type) {
            case -1: 
            case 0: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            case 1: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0, null);
                break;
            }
            case 2: {
                methodVisitor.visitFrame(this.type, this.local.size(), null, 0, null);
                break;
            }
            case 3: {
                methodVisitor.visitFrame(this.type, 0, null, 0, null);
                break;
            }
            case 4: {
                methodVisitor.visitFrame(this.type, 0, null, 1, FrameNode.asArray(this.stack));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> map) {
        Object object;
        int n2;
        int n3;
        FrameNode frameNode = new FrameNode();
        frameNode.type = this.type;
        if (this.local != null) {
            frameNode.local = new ArrayList<Object>();
            n3 = this.local.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = this.local.get(n2);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.local.add(object);
            }
        }
        if (this.stack != null) {
            frameNode.stack = new ArrayList<Object>();
            n3 = this.stack.size();
            for (n2 = 0; n2 < n3; ++n2) {
                object = this.stack.get(n2);
                if (object instanceof LabelNode) {
                    object = map.get(object);
                }
                frameNode.stack.add(object);
            }
        }
        return frameNode;
    }

    private static Object[] asArray(List<Object> list) {
        Object[] objectArray = new Object[list.size()];
        int n2 = objectArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = list.get(i2);
            if (object instanceof LabelNode) {
                object = ((LabelNode)object).getLabel();
            }
            objectArray[i2] = object;
        }
        return objectArray;
    }
}

