/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.context;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.HeapUsage;
import com.contrastsecurity.agent.context.ExecutionContext;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;

@HeapUsage.SupportsHeapProfiling
@DontObfuscate
abstract class AbstractExecutionContext
implements ExecutionContext {
    @HeapUsage.Deep
    protected final ConcurrentMap<ExecutionContext.Key<?>, Object> state;

    AbstractExecutionContext() {
        this.state = new ConcurrentHashMap();
    }

    AbstractExecutionContext(AbstractExecutionContext abstractExecutionContext) {
        this.state = new ConcurrentHashMap(abstractExecutionContext.state);
    }

    @Override
    public final <T> T put(ExecutionContext.Key<T> key, T t2) {
        T t3 = this.state.put(key, t2);
        return key.type().cast(t3);
    }

    @Override
    public final <T> T putIfAbsent(ExecutionContext.Key<T> key, T t2) {
        Object object = this.state.putIfAbsent(key, t2);
        return key.type().cast(object);
    }

    @Override
    public final <T> T getOrComputeIfAbsent(ExecutionContext.Key<T> key, Supplier<T> supplier) {
        T t2 = this.get(key);
        if (t2 != null) {
            return t2;
        }
        T t3 = supplier.get();
        t2 = this.putIfAbsent(key, t3);
        return t2 == null ? t3 : t2;
    }

    @Override
    public final <T> T get(ExecutionContext.Key<T> key) {
        Object v2 = this.state.get(key);
        return key.type().cast(v2);
    }

    @Override
    public <T> T remove(ExecutionContext.Key<T> key) {
        return key.type().cast(this.state.remove(key));
    }
}

