/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.core;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.ScopedSensor;
import com.contrastsecurity.agent.c.a;
import com.contrastsecurity.agent.commons.Clock;
import com.contrastsecurity.agent.commons.Memoizer;
import com.contrastsecurity.agent.commons.StartupTiming;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.commons.SystemClock;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.config.ConfigUpdatable;
import com.contrastsecurity.agent.config.WorkingDirectories;
import com.contrastsecurity.agent.config.exception.ContrastConfigurationException;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.core.ContrastEngine;
import com.contrastsecurity.agent.core.ContrastVersion;
import com.contrastsecurity.agent.core.b;
import com.contrastsecurity.agent.f.k;
import com.contrastsecurity.agent.h;
import com.contrastsecurity.agent.i;
import com.contrastsecurity.agent.logging.c;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.plugins.PluginManager;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.scope.ScopeProvider;
import com.contrastsecurity.agent.services.ngreporting.f;
import com.contrastsecurity.agent.startup.FatalStartupException;
import com.contrastsecurity.agent.startup.e;
import com.contrastsecurity.agent.startup.x;
import com.contrastsecurity.agent.telemetry.errors.o;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.util.C2Compiler;
import com.contrastsecurity.agent.util.CpuInfo;
import com.contrastsecurity.agent.util.D;
import com.contrastsecurity.agent.util.E;
import com.contrastsecurity.agent.util.ObjectShare;
import com.contrastsecurity.agent.util.PerfUtil;
import com.contrastsecurity.agent.util.PreConfigUtil;
import com.contrastsecurity.agent.util.VMArguments;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

@DontObfuscate
public class ContrastAgent {
    private static final String DELAYED_BOOT_STRATEGY = "boot";
    private static final String DELAYED_ACTIVATION_STRATEGY = "activation";
    private static final String ERROR_PROBABILISTIC_VALUE = "Unable to process probabilistic startup value";

    public static void setup(boolean bl2, String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        Objects.requireNonNull(instrumentation);
        ContrastContext.enableThreadLocal();
        ContrastAgent.scopedSetup(bl2, string, instrumentation, file, startupTiming);
    }

    @ScopedSensor
    public static void scopedSetup(boolean bl2, String string, Instrumentation instrumentation, File file, StartupTiming startupTiming) {
        ScopeProvider scopeProvider = ContrastContext.current().scopeProvider().enterScope();
        try {
            WorkingDirectories workingDirectories;
            ConfigUpdatable configUpdatable;
            com.contrastsecurity.agent.s.a.a(file);
            D d2 = E.b();
            ContrastAgent.patchLiferayLocaleErrors();
            e e2 = new e();
            try {
                configUpdatable = e2.a(string);
            }
            catch (ContrastConfigurationException contrastConfigurationException) {
                PreConfigUtil.err("Couldn't initialize Contrast. Invalid configuration: " + contrastConfigurationException.getMessage());
                if (bl2) {
                    throw contrastConfigurationException;
                }
                contrastConfigurationException.printStackTrace(System.err);
                ContrastAgent.logStartingWithoutContrast();
                scopeProvider.leaveScope();
                return;
            }
            try {
                workingDirectories = WorkingDirectories.fromConfig(configUpdatable);
            }
            catch (IOException iOException) {
                String string2 = configUpdatable.getOrNull(ConfigProperty.WORKING_DIR);
                PreConfigUtil.err("\n\tUnable to create references to the working directory, check that permissions are open to\n\twrite to on the directory indicated by the configuration: `contrast.agent.contrast_working_dir`\n\tThe current setting of the working directory is [ " + (string2 != null ? string2 : WorkingDirectories.getDefaultContrastDirPath()) + " ]\n\tand the agent was unable to access it and/or its contents.");
                iOException.printStackTrace(System.err);
                ContrastAgent.logStartingWithoutContrast();
                scopeProvider.leaveScope();
                return;
            }
            d2.b();
            startupTiming.configLoadTimeNs(d2.e());
            CpuInfo cpuInfo = CpuInfo.detectAvailableCpus();
            C2Compiler c2Compiler = C2Compiler.configureC2Compilation(configUpdatable, cpuInfo);
            boolean bl3 = configUpdatable.getBoolean(ConfigProperty.SUPPRESS_STDOUT);
            if (bl3) {
                PreConfigUtil.quiet();
            }
            if (ContrastAgent.isAgentStartupDisabled(configUpdatable)) {
                scopeProvider.leaveScope();
                return;
            }
            int n2 = ContrastAgent.getStartupDelay(configUpdatable);
            if (n2 > 0) {
                ContrastAgent.delayedStartup(bl2, cpuInfo, c2Compiler, instrumentation, configUpdatable, workingDirectories, file, n2, startupTiming);
            } else {
                ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, cpuInfo, c2Compiler, configUpdatable, workingDirectories, file, startupTiming);
                if (contrastEngine != null) {
                    contrastEngine.activatePlugins();
                }
            }
            scopeProvider.leaveScope();
            return;
        }
        catch (Throwable throwable) {
            scopeProvider.leaveScope();
            throw throwable;
        }
    }

    @q
    static boolean isAgentStartupDisabled(Config config) {
        if (!config.getBoolean(ConfigProperty.ENABLED)) {
            return true;
        }
        try {
            a a2 = ContrastAgent.probabilisticStartupCheck(config);
            return a2 != null && !a2.a();
        }
        catch (FatalStartupException fatalStartupException) {
            return true;
        }
    }

    private static a probabilisticStartupCheck(Config config) throws FatalStartupException {
        int n2;
        try {
            n2 = config.getInt(ConfigProperty.PROBABILISTIC_STARTUP);
        }
        catch (ContrastConfigurationException contrastConfigurationException) {
            ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with non-numeric value");
            throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
        }
        if (n2 != -1) {
            try {
                return new a(n2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ContrastAgent.logProbabilisticStartupConfigError("Probabilistic startup was specified but with an invalid value: " + n2);
                throw new FatalStartupException(ERROR_PROBABILISTIC_VALUE);
            }
        }
        return null;
    }

    private static void logProbabilisticStartupConfigError(String string) {
        PreConfigUtil.err(string);
        PreConfigUtil.err("Please specify a number between 1 and 99 (percentage)");
        ContrastAgent.logStartingWithoutContrast();
    }

    private static void logStartingWithoutContrast() {
        PreConfigUtil.err("Continuing without Contrast...");
    }

    private static void delayedStartup(boolean bl2, CpuInfo cpuInfo, C2Compiler c2Compiler, Instrumentation instrumentation, ConfigUpdatable configUpdatable, WorkingDirectories workingDirectories, File file, int n2, StartupTiming startupTiming) {
        String string = configUpdatable.getOrNull(ConfigProperty.DELAYED_STARTUP_STRATEGY);
        if (string == null || DELAYED_ACTIVATION_STRATEGY.equalsIgnoreCase(string)) {
            ContrastEngine contrastEngine = ContrastAgent.startup(instrumentation, cpuInfo, c2Compiler, configUpdatable, workingDirectories, file, startupTiming);
            if (contrastEngine == null) {
                return;
            }
            h h2 = new h(bl2, contrastEngine, n2, contrastEngine.getErrorEmitter());
            h2.setDaemon(true);
            h2.start();
        } else if (ContrastAgent.isDelayedBoot(string)) {
            i i2 = new i(bl2, n2, cpuInfo, c2Compiler, instrumentation, configUpdatable, workingDirectories, file, startupTiming);
            i2.setDaemon(true);
            i2.start();
        } else {
            PreConfigUtil.err("Invalid delayed startup strategy (" + string + ")");
        }
    }

    public static int getStartupDelay(Config config) {
        int n2 = 0;
        try {
            n2 = config.getInt(ConfigProperty.DELAYED_STARTUP);
        }
        catch (ContrastConfigurationException contrastConfigurationException) {
            // empty catch block
        }
        return Math.max(n2, 0);
    }

    public static ContrastEngine startup(Instrumentation instrumentation, CpuInfo cpuInfo, C2Compiler c2Compiler, ConfigUpdatable configUpdatable, WorkingDirectories workingDirectories, File file, StartupTiming startupTiming) {
        D d2 = E.b();
        PreConfigUtil.out("Starting Contrast (build " + ContrastVersion.VERSION + ") Pat. 8,458,789 B2");
        com.contrastsecurity.agent.services.b b2 = new com.contrastsecurity.agent.services.b();
        com.contrastsecurity.agent.h.b b3 = com.contrastsecurity.agent.h.b.a((Config)configUpdatable, file);
        c c2 = com.contrastsecurity.agent.logging.log4j2.f.a(configUpdatable, b3, b2);
        Logger logger = LoggerFactory.getLogger(ContrastAgent.class);
        try {
            cpuInfo.onLoggerInitialized();
            c2Compiler.onLoggerInitialized(configUpdatable);
            k k2 = new k();
            ObjectShare.initGson(configUpdatable, k2);
            SystemClock systemClock = new SystemClock();
            Memoizer<List<com.contrastsecurity.agent.a.a>> memoizer = Suppliers.memoize(() -> com.contrastsecurity.agent.a.a.a(VMArguments.getVMArguments()));
            com.contrastsecurity.agent.telemetry.i i2 = com.contrastsecurity.agent.telemetry.i.a(configUpdatable, b3, systemClock, memoizer, c2Compiler);
            TelemetryMetrics telemetryMetrics = i2.a();
            c2.a(b2, telemetryMetrics);
            com.contrastsecurity.agent.telemetry.c c3 = new com.contrastsecurity.agent.telemetry.c(telemetryMetrics.isEnabled());
            com.contrastsecurity.agent.p.b b4 = com.contrastsecurity.agent.p.b.a();
            ContrastEngine contrastEngine = ContrastAgent.createContrastEngine(instrumentation, configUpdatable, cpuInfo, new com.contrastsecurity.agent.plugins.apps.f(), c2, startupTiming, b3, b2, systemClock, i2, c3, b4, k2, memoizer, c2Compiler, workingDirectories);
            d2.b();
            String string = "JVM uptime time before agent: " + startupTiming.getJvmUptimeAtPremainMs() + "ms";
            PerfUtil.printStartupTimingMessage(string);
            long l2 = TimeUnit.NANOSECONDS.toMillis(startupTiming.getTimeForJarTmpInjectionNs());
            PerfUtil.printStartupTimingMessage(PerfUtil.a.a, "jar-injection", l2);
            c3.a(PerfUtil.a.a, "load-config", startupTiming.configLoadMs());
            c3.a(PerfUtil.a.a, "primordial", d2);
            contrastEngine.start(startupTiming);
            return contrastEngine;
        }
        catch (FatalStartupException fatalStartupException) {
            PreConfigUtil.err("Unexpected error starting up. Continuing without Contrast");
            PreConfigUtil.err(fatalStartupException.getMessage());
            logger.error("Unexpected error starting up. Continuing without Contrast", fatalStartupException);
            return null;
        }
    }

    @q
    static void patchLiferayLocaleErrors() {
        String string = n.b("java.locale.providers");
        if (string == null || string.isEmpty()) {
            return;
        }
        String string2 = string.toUpperCase(Locale.ROOT);
        if (!string2.contains("COMPAT")) {
            return;
        }
        String[] stringArray = string2.split(",");
        StringBuilder stringBuilder = new StringBuilder();
        for (String string3 : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            }
            if (string3.trim().equals("COMPAT")) {
                stringBuilder.append("JRE");
                continue;
            }
            stringBuilder.append(string3.trim());
        }
        n.a("java.locale.providers", stringBuilder.toString());
    }

    @q
    static ContrastEngine createContrastEngine(Instrumentation instrumentation, ConfigUpdatable configUpdatable, CpuInfo cpuInfo, com.contrastsecurity.agent.plugins.apps.f f2, c c2, StartupTiming startupTiming, com.contrastsecurity.agent.h.b b2, com.contrastsecurity.agent.services.b b3, Clock clock, com.contrastsecurity.agent.telemetry.i i2, com.contrastsecurity.agent.telemetry.c c3, com.contrastsecurity.agent.p.b b4, k k2, Supplier<List<com.contrastsecurity.agent.a.a>> supplier, C2Compiler c2Compiler, WorkingDirectories workingDirectories) throws FatalStartupException {
        b b5 = new b(f2, b4, clock, configUpdatable, cpuInfo, b3, instrumentation, c2, k2, b2, startupTiming, c3, i2, workingDirectories, supplier, c2Compiler);
        com.contrastsecurity.agent.m.a a2 = b5.j();
        PluginManager pluginManager = b5.e();
        o o2 = i2.d();
        f2.addListener(configUpdatable);
        List<com.contrastsecurity.agent.services.a> list = b5.n();
        f f3 = b5.m();
        List<x> list2 = b5.o();
        return new ContrastEngine(instrumentation, b2, configUpdatable, list2, clock, list, pluginManager, f3, workingDirectories, i2.a(), o2, a2.a(), c2, b3, c3, b5.l(), b5.p(), c2Compiler);
    }

    public static boolean isDelayedBoot(Config config) {
        return ContrastAgent.getStartupDelay(config) > 0 && ContrastAgent.isDelayedBoot(config.getOrNull(ConfigProperty.DELAYED_STARTUP_STRATEGY));
    }

    private static boolean isDelayedBoot(String string) {
        return DELAYED_BOOT_STRATEGY.equalsIgnoreCase(string);
    }
}

