/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.injection;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.injection.Injector;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

final class MethodHandlesInjector
implements Injector {
    private Method defineClassMethod;
    private Object privateLookupObject;

    MethodHandlesInjector() {
        Method privateLookupIn;
        Class<?> lookup;
        Class<?> methodHandles;
        try {
            methodHandles = Class.forName("java.lang.invoke.MethodHandles");
            lookup = Class.forName("java.lang.invoke.MethodHandles$Lookup");
        }
        catch (ClassNotFoundException e2) {
            throw new IllegalStateException("Cannot use MethodHandles class definition without MethodHandles class", e2);
        }
        try {
            privateLookupIn = methodHandles.getMethod("privateLookupIn", Class.class, lookup);
        }
        catch (NoSuchMethodException e3) {
            throw new IllegalStateException("Cannot use MethodHandles class definition without required method", e3);
        }
        privateLookupIn.setAccessible(true);
        try {
            this.privateLookupObject = privateLookupIn.invoke(null, Object.class, methodHandles.getMethod("lookup", new Class[0]).invoke(null, new Object[0]));
            this.defineClassMethod = this.privateLookupObject.getClass().getMethod("defineClass", byte[].class);
        }
        catch (IllegalAccessException e4) {
            throw new IllegalStateException("Unexpected IllegalAccessException. Should never happen because we call setAccessible(true)", e4);
        }
        catch (InvocationTargetException e5) {
            throw (RuntimeException)Throwables.propagate(e5, null);
        }
        catch (NoSuchMethodException e6) {
            throw new IllegalStateException("Cannot use MethodHandles class definition without required method", e6);
        }
        this.defineClassMethod.setAccessible(true);
    }

    @Override
    public void inject(String typeName, byte[] bytecode) throws Exception {
        this.defineClassMethod.invoke(this.privateLookupObject, new Object[]{bytecode});
    }
}

