/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.frameworks.jersey;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Maps;
import com.contrastsecurity.agent.commons.Sets;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.contrastapi_v1_0.RequestMethod;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.logging.a;
import com.contrastsecurity.agent.messages.routes.DiscoveredRoute;
import com.contrastsecurity.agent.messages.routes.RouteType;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.frameworks.jaxrs.c;
import com.contrastsecurity.agent.plugins.route.RouteCoverageUtil;
import com.contrastsecurity.agent.plugins.route.RouteObservationProcessor;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.reflection.Reflect;
import com.contrastsecurity.agent.reflection.ReflectionUtil;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

@o
@DontObfuscate
final class ContrastJerseyRouteDispatcherImpl
implements ContrastJerseyRouteDispatcher {
    private final Config config;
    private final RouteObservationProcessor routeObservationProcessor;
    private static final Set<String> JERSEY_CONTEXT_PATH_DENYLIST = Sets.of("/lifecycle", "/tenant-monitoring", "/elasticity-monitoring", "/weblogic", "/wls");
    private static final Set<String> GLASSFISH_ADMIN_METHODS = Sets.of("org.glassfish.admin.rest.resources.admin.CommandResource", "org.glassfish.jersey.server.wadl.processor.OptionsMethodProcessor$GenericOptionsInflector", "org.glassfish.jersey.server.wadl.processor.OptionsMethodProcessor$PlainTextOptionsInflector");
    private static final Map<String, Set<String>> JERSEY_CLASS_DENYLIST = Maps.builder().add("//{command:.*}/", GLASSFISH_ADMIN_METHODS).add("//{command:.*}/manpage", GLASSFISH_ADMIN_METHODS).build();
    private static final Annotation[] EMPTY_ANNOTATION_ARRAY = new Annotation[0];
    private static final Logger logger = LoggerFactory.getLogger(ContrastJerseyRouteDispatcherImpl.class);

    public ContrastJerseyRouteDispatcherImpl(RouteObservationProcessor routeObservationProcessor, Config config) {
        this.config = config;
        this.routeObservationProcessor = routeObservationProcessor;
    }

    public void onRoutesDiscovered(Object object2, Object object3, Class<?> clazz, Class<?> clazz2, Class<?> clazz3, Class<?> clazz4) {
        Class<?> clazz5;
        if (object3 == null) {
            logger.debug("Jersey route discovery unavailable, ApplicationHandler was null");
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object2;
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Jersey route discovery unavailable, no application was found to which attach routes");
            return;
        }
        try {
            clazz5 = n.a("org.glassfish.jersey.server.internal.JerseyResourceContext", true, object3.getClass().getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.debug("Could not find class org.glassfish.jersey.server.internal.JerseyResourceContext", classNotFoundException);
            return;
        }
        Reflect reflect = Reflect.reflect(logger);
        Function<Class<?>, Collection<?>> function = ContrastJerseyRouteDispatcherImpl.getServiceLocator(reflect, object3);
        if (function == null) {
            logger.debug("Could not find the ServiceLocator, unable to perform route discovery");
            return;
        }
        Collection<?> collection = function.apply(clazz5);
        if (collection.isEmpty()) {
            logger.debug("Jersey route coverage unavailable, JerseyResourceContext was null");
            return;
        }
        HashSet hashSet = new HashSet();
        reflect.reset(collection.iterator().next()).invoke("getResourceModel").invoke("getResources").asOptional(List.class).ifPresent(list -> list.forEach(object -> hashSet.addAll(ContrastJerseyRouteDispatcherImpl.processResource(object, "", Reflect.reflect(logger)))));
        if (this.config.getBoolean(ConfigProperty.ROUTE_DISCOVERY_MIDDLEWARE_ENABLED)) {
            boolean bl2 = clazz.getName().contains("jakarta");
            function.apply(clazz).forEach(object -> hashSet.add(c.a.a(object.getClass().getName(), DiscoveredRoute.Framework.JERSEY, bl2)));
            function.apply(clazz2).forEach(object -> hashSet.add(c.b.a(object.getClass().getName(), DiscoveredRoute.Framework.JERSEY, bl2)));
            function.apply(clazz3).forEach(object -> hashSet.add(c.c.a(object.getClass().getName(), DiscoveredRoute.Framework.JERSEY, bl2)));
            function.apply(clazz4).forEach(object -> hashSet.add(c.d.a(object.getClass().getName(), DiscoveredRoute.Framework.JERSEY, bl2)));
        }
        application.addDiscoveredRoutes(Collections.unmodifiableCollection(hashSet));
    }

    public void onEnterRouteObserved(Object object, Object object2, Object object3) {
        if (object2 == null) {
            a.a("JERSEY_ROUTE_OBSERVATION_INVALID_PARAMS", logger, "Cannot observe route since the Jersey invocable is null.");
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        HttpRequest httpRequest = contrastContext.http().getRequest();
        if (httpRequest == null) {
            return;
        }
        Reflect.reflect(object2, logger).invoke("getHandlingMethod").asOptional(Method.class).ifPresent(method -> this.routeObservationProcessor.onRouteStart(contrastContext, RouteCoverageUtil.buildRouteSignature(method, RouteCoverageUtil::stripGeneratedProxySignatures), ContrastJerseyRouteDispatcherImpl.extractTemplate(object3), RouteType.HTTP));
    }

    @q
    static String extractTemplate(Object object) {
        Reflect reflect = Reflect.reflect(logger);
        List list = reflect.reset(object).invoke("getMatchedTemplates").as(List.class, Collections.emptyList());
        StringBuilder stringBuilder = new StringBuilder();
        for (Object t2 : list) {
            String string = reflect.reset(t2).invoke("getTemplate").asString();
            if (string.isEmpty() || "/".equals(string)) continue;
            string = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            stringBuilder.insert(0, string);
        }
        return stringBuilder.toString();
    }

    private static String normalizePath(String string) {
        return string != null ? (string.startsWith("/") ? string : "/" + string) : null;
    }

    private static Function<Class<?>, Collection<?>> getServiceLocator(Reflect reflect, Object object) {
        Object object2 = reflect.reset(object).invoke("getInjectionManager").invoke("getServiceLocator").asOptional(Object.class).orElseGet(() -> reflect.reset(object).invoke("getServiceLocator").asNullable(Object.class));
        if (object2 == null) {
            return null;
        }
        Method method = ReflectionUtil.findPublicMethod(object2.getClass(), "getAllServices", Class.class, Annotation[].class);
        if (method == null) {
            return null;
        }
        return clazz -> {
            Object object2 = ReflectionUtil.invoke(method, object2, clazz, EMPTY_ANNOTATION_ARRAY);
            if (!(object2 instanceof List)) {
                logger.debug("JerseyInjectionManager could not find any objects of type: {}", clazz);
                return Collections.emptyList();
            }
            return (Collection)object2;
        };
    }

    private static Collection<DiscoveredRoute> processResource(Object object, String string, Reflect reflect) {
        Object object2;
        String string2;
        if (object == null) {
            return Collections.emptySet();
        }
        int n2 = (string = ContrastJerseyRouteDispatcherImpl.normalizePath(string + reflect.reset(object).invokePublic("getPath").asString(""))).indexOf("/", 1);
        String string3 = string2 = n2 != -1 ? string.substring(0, n2) : string;
        if (JERSEY_CONTEXT_PATH_DENYLIST.contains(string2)) {
            return Collections.emptySet();
        }
        HashSet hashSet = new HashSet();
        List<Object> list = reflect.reset(object).invoke("getResourceMethods").as(List.class, Collections.emptyList());
        if (list.isEmpty() && (object2 = reflect.reset(object).invoke("getResourceLocator").asNullable(Object.class)) != null) {
            list = Collections.singletonList(object2);
        }
        object2 = string;
        list.forEach(arg_0 -> ContrastJerseyRouteDispatcherImpl.lambda$processResource$11(reflect, (String)object2, hashSet, arg_0));
        reflect.reset(object).invoke("getChildResources").asOptional(List.class).ifPresent(arg_0 -> ContrastJerseyRouteDispatcherImpl.lambda$processResource$12(hashSet, (String)object2, reflect, arg_0));
        return Collections.unmodifiableSet(hashSet);
    }

    private static /* synthetic */ void lambda$processResource$12(Set set, String string, Reflect reflect, List list) {
        for (Object e2 : list) {
            set.addAll(ContrastJerseyRouteDispatcherImpl.processResource(e2, string, reflect));
        }
    }

    private static /* synthetic */ void lambda$processResource$11(Reflect reflect, String string, Set set, Object object) {
        RequestMethod requestMethod = RequestMethod.of(reflect.reset(object).invokePublic("getHttpMethod").asNullableString());
        reflect.reset(object).invokePublic("getInvocable").invoke("getHandlingMethod").asOptional(Method.class).filter(method -> {
            Set<String> set = JERSEY_CLASS_DENYLIST.get(string);
            return set == null || !set.contains(method.getDeclaringClass().getName());
        }).ifPresent(method -> set.add(DiscoveredRoute.builder().framework(DiscoveredRoute.Framework.JERSEY).requestMethod(requestMethod).signature(RouteCoverageUtil.buildRouteSignature(method, RouteCoverageUtil::stripGeneratedProxySignatures)).url(string).build()));
    }
}

