/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.protect;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.apps.exclusions.b;
import com.contrastsecurity.agent.apps.exclusions.d;
import com.contrastsecurity.agent.commons.NVP;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.http.HttpRequest;
import com.contrastsecurity.agent.http.d;
import com.contrastsecurity.agent.messages.app.activity.protect.details.UserInputDTM;
import com.contrastsecurity.agent.messages.app.settings.ExceptionInputTypeDTM;
import com.contrastsecurity.agent.plugins.protect.B;
import com.contrastsecurity.agent.plugins.protect.CookieScanner;
import com.contrastsecurity.agent.plugins.protect.HeaderScanner;
import com.contrastsecurity.agent.plugins.protect.I;
import com.contrastsecurity.agent.plugins.protect.ProtectContext;
import com.contrastsecurity.agent.plugins.protect.ProtectManager;
import com.contrastsecurity.agent.plugins.protect.ProtectRuleId;
import com.contrastsecurity.agent.plugins.protect.QueryStringUriScanner;
import com.contrastsecurity.agent.plugins.protect.k.a;
import com.contrastsecurity.agent.plugins.protect.rules.i;
import com.contrastsecurity.agent.plugins.protect.rules.k;
import com.contrastsecurity.agent.plugins.protect.rules.p;
import com.contrastsecurity.agent.t.c;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

@DontObfuscate
final class ProtectRequestStartHandler {
    private final ContrastContext contrastContext;
    private final List<k> inputAwareRules;
    private final com.contrastsecurity.agent.apps.exclusions.i exclusionProcessor;
    private final b exclusionCache;
    private final HttpRequest request;
    private final boolean metricsEnabled;
    private final ProtectManager manager;
    private final c serverExclusionProcessor;
    private final CookieScanner cookieAnalyzer;
    private final HeaderScanner headerAnalyzer;
    private final QueryStringUriScanner queryStringAnalyzer;
    private boolean queryAndURICached;
    private boolean hasQueryStringExceptions;
    private String queryString;
    private Supplier<String> queryStringSupplier;
    private Supplier<String> uriSupplier;
    private static final Logger logger = LoggerFactory.getLogger(ProtectRequestStartHandler.class);

    ProtectRequestStartHandler(ContrastContext contrastContext, ProtectManager protectManager, c c2, boolean bl2, B b2) {
        this.contrastContext = contrastContext;
        this.manager = protectManager;
        this.serverExclusionProcessor = c2;
        this.inputAwareRules = protectManager.getEnabledInputRulesCalculated(contrastContext);
        Application application = contrastContext.application().current();
        this.exclusionProcessor = application.getExclusionProcessor();
        this.request = contrastContext.http().getRequest();
        this.exclusionCache = com.contrastsecurity.agent.apps.exclusions.c.a(application, this.request);
        this.metricsEnabled = bl2;
        this.cookieAnalyzer = b2.a;
        this.headerAnalyzer = b2.b;
        this.queryStringAnalyzer = b2.c;
    }

    void doRequestStart() {
        if (!this.metricsEnabled) {
            this.contrastContext.protect().markRuleDisabled(ProtectRuleId.METRIC_GATHERING);
        }
        for (p p2 : this.manager.getEnabledRules(this.contrastContext)) {
            this.onStartForRule(p2);
        }
        this.onInputAwareRules();
    }

    private void onStartForRule(p p2) {
        String string = p2.getRuleId().id();
        ProtectContext protectContext = this.contrastContext.protect();
        if (this.exclusionCache.a(d.a.b, string)) {
            logger.debug("Not inspecting {} rule for {} due to exclusion", (Object)string, (Object)this.request.getUri());
            protectContext.markRuleDisabled(p2.getRuleId());
            return;
        }
        if (p2 instanceof k) {
            this.cacheForQueryAndURI();
            k k2 = (k)p2;
            this.onQueryString(k2);
            this.onURI(k2);
        }
        if (p2 instanceof i) {
            ((i)p2).a(this.contrastContext);
        }
    }

    private void onInputAwareRules() {
        if (this.inputAwareRules.isEmpty()) {
            return;
        }
        this.onCookies();
        this.onHeaders();
    }

    private void onCookies() {
        NVP[] nVPArray = this.getCookies(this.request);
        boolean bl2 = this.exclusionProcessor.hasCookieExclusions(d.a.b);
        for (NVP nVP : nVPArray) {
            this.onCookie(bl2, nVP);
        }
    }

    private NVP[] getCookies(HttpRequest httpRequest) {
        String string = httpRequest.getCookie();
        if (string == null || string.isEmpty()) {
            return d.a;
        }
        return d.a(string);
    }

    private void onCookie(boolean bl2, NVP nVP) {
        if (this.serverExclusionProcessor.a(nVP.getName())) {
            return;
        }
        Supplier<String> supplier = a.b(nVP.getName(), UserInputDTM.InputType.COOKIE_NAME);
        Supplier<String> supplier2 = a.b(nVP.getValue(), UserInputDTM.InputType.COOKIE_VALUE);
        String string = nVP.getName();
        String string2 = this.request.getUri();
        for (k k2 : this.inputAwareRules) {
            String string3 = k2.getRuleId().id();
            if (this.isCookieExcluded(bl2, k2, string)) {
                logger.debug("Ignoring cookie names and values for {} on {} due to exception", (Object)string3, (Object)string2);
                continue;
            }
            if (this.isRuleRequiredForInput(k2, UserInputDTM.InputType.COOKIE_NAME, string)) {
                this.cookieAnalyzer.scanCookie(this.contrastContext, k2, supplier.get(), supplier2.get(), UserInputDTM.InputType.COOKIE_NAME);
            }
            if (!this.isRuleRequiredForInput(k2, UserInputDTM.InputType.COOKIE_VALUE, nVP.getValue())) continue;
            this.cookieAnalyzer.scanCookie(this.contrastContext, k2, supplier.get(), supplier2.get(), UserInputDTM.InputType.COOKIE_VALUE);
        }
    }

    private void onHeaders() {
        Map<String, String[]> map = this.request.getHeaders();
        if (map == null) {
            return;
        }
        boolean bl2 = this.exclusionProcessor.hasHeaderExclusions(d.a.b);
        for (String string : map.keySet()) {
            this.onHeader(string, map.get(string), bl2);
        }
    }

    private void onHeader(String string, String[] stringArray, boolean bl2) {
        if ("Cookie".equalsIgnoreCase(string) || this.serverExclusionProcessor.b(string)) {
            return;
        }
        for (String string2 : stringArray) {
            if (I.a(string, string2)) continue;
            this.onHeaderValue(string, string2, bl2);
        }
    }

    private void onHeaderValue(String string, String string2, boolean bl2) {
        Supplier<String> supplier = a.b(string2, UserInputDTM.InputType.HEADER);
        for (k k2 : this.inputAwareRules) {
            if (!this.isRuleRequiredForInput(k2, UserInputDTM.InputType.HEADER, string2) || bl2 && this.exclusionCache.a(d.a.b, k2.getRuleId().id(), ExceptionInputTypeDTM.HEADER, string)) continue;
            this.headerAnalyzer.scanHeader(this.contrastContext, k2, string, supplier.get());
        }
    }

    private boolean isCookieExcluded(boolean bl2, k k2, String string) {
        return bl2 && this.exclusionCache.a(d.a.b, k2.getRuleId().id(), ExceptionInputTypeDTM.COOKIE, string);
    }

    private boolean isRuleRequiredForInput(k k2, UserInputDTM.InputType inputType, String string) {
        return k2.appliesToInputType(inputType) && StringUtils.isNotEmpty(string) && this.contrastContext.protect().isRuleEnabled(k2.getRuleId());
    }

    private void cacheForQueryAndURI() {
        if (this.queryAndURICached) {
            return;
        }
        this.hasQueryStringExceptions = this.exclusionProcessor.hasQuerystringExclusions(d.a.b);
        this.queryString = this.request.getQueryString();
        this.queryStringSupplier = Suppliers.memoize(() -> this.queryString == null ? null : a.a(this.queryString.trim(), UserInputDTM.InputType.QUERYSTRING));
        this.uriSupplier = Suppliers.memoize(() -> this.request.getUri() == null ? null : a.a(this.request.getUri().trim(), UserInputDTM.InputType.URI));
        this.queryAndURICached = true;
    }

    private void onQueryString(k k2) {
        String string = k2.getRuleId().id();
        if (!this.allowedToScanQuerystring(k2, this.queryString)) {
            return;
        }
        String string2 = this.request.getUri();
        if (this.hasQueryStringExceptions && this.exclusionCache.a(d.a.b, string, ExceptionInputTypeDTM.QUERYSTRING)) {
            logger.debug("Ignoring querystring for {} on {} due to exception", (Object)string, (Object)string2);
            return;
        }
        this.queryStringAnalyzer.scanQueryString(this.contrastContext, k2, this.queryStringSupplier.get());
    }

    private boolean allowedToScanQuerystring(k k2, String string) {
        return !StringUtils.isEmpty(string) && k2.appliesToInputType(UserInputDTM.InputType.QUERYSTRING) && !this.manager.isScanParameterAsAnything();
    }

    private void onURI(k k2) {
        if (k2.appliesToInputType(UserInputDTM.InputType.URI)) {
            this.queryStringAnalyzer.scanUriValue(this.contrastContext, k2, this.uriSupplier.get());
        }
    }
}

