/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.sessiontimeout;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.apps.Application;
import com.contrastsecurity.agent.commons.Suppliers;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.context.ApplicationExecutionContext;
import com.contrastsecurity.agent.context.ContrastContext;
import com.contrastsecurity.agent.context.ExecutionContext;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.plugins.frameworks.j2ee.e;
import com.contrastsecurity.agent.plugins.security.j;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.ProviderUtil;
import com.contrastsecurity.agent.plugins.security.policy.rules.providers.internal.sessiontimeout.b;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.w.i;
import com.contrastsecurity.thirdparty.nn3nx.IXMLElement;
import com.contrastsecurity.thirdparty.nn3nx.XMLElement;
import com.contrastsecurity.thirdparty.nn3nx.XMLException;
import com.contrastsecurity.thirdparty.oa4j.commons.io.IOUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.lang3.StringUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.function.Supplier;

@DontObfuscate
@o
final class ContrastSessionTimeoutRuleDispatcherImpl
implements ContrastSessionTimeoutRuleDispatcher {
    private static final ExecutionContext.Key<Supplier> SESSION_TIMEOUT_REPORTER = ExecutionContext.Key.create(Supplier.class);
    private final ProviderUtil providerUtil;
    private final e reflector;
    private final long maxAllowedTimeoutInSeconds;
    private final j.b configurationHasher;
    private static final Logger logger = LoggerFactory.getLogger(ContrastSessionTimeoutRuleDispatcherImpl.class);

    public ContrastSessionTimeoutRuleDispatcherImpl(ProviderUtil providerUtil, e e2, Config config, j j2) {
        this.providerUtil = providerUtil;
        this.reflector = e2;
        this.maxAllowedTimeoutInSeconds = b.a(config);
        this.configurationHasher = j2.a();
    }

    @q
    static int timeoutInMinutes(int n2) {
        if (n2 == 0) {
            return 0;
        }
        if (n2 % 60 == 0) {
            return n2 / 60;
        }
        if (n2 < 0) {
            return n2 / 60 - 1;
        }
        return n2 / 60 + 1;
    }

    @q
    static String getEvidenceFromWebXml(e e2, int n2, Object object, Application application) {
        IXMLElement iXMLElement = ContrastSessionTimeoutRuleDispatcherImpl.getSessionTimeout(e2, object, application);
        if (iXMLElement == null) {
            return null;
        }
        return ContrastSessionTimeoutRuleDispatcherImpl.validateSessionTimeout(n2, iXMLElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IXMLElement getSessionTimeout(e e2, Object object, Application application) {
        InputStreamReader inputStreamReader;
        InputStream inputStream;
        block8: {
            IXMLElement iXMLElement;
            XMLElement xMLElement;
            block7: {
                Object object2 = e2.d(object);
                if (object2 == null) {
                    return null;
                }
                inputStream = e2.a(object2, "/WEB-INF/web.xml");
                if (inputStream == null) {
                    return null;
                }
                inputStreamReader = null;
                inputStreamReader = new InputStreamReader(inputStream);
                xMLElement = i.a(inputStreamReader);
                if (xMLElement != null) break block7;
                IXMLElement iXMLElement2 = null;
                IOUtils.closeQuietly(inputStream, inputStreamReader);
                return iXMLElement2;
            }
            try {
                IXMLElement iXMLElement3 = xMLElement.getFirstChildNamed("session-config");
                if (iXMLElement3 == null) break block8;
                iXMLElement = iXMLElement3.getFirstChildNamed("session-timeout");
            }
            catch (XMLException xMLException) {
                try {
                    logger.debug("Unable to parse /WEB-INF/web.xml for app with name={}.", (Object)application, (Object)xMLException);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inputStream, inputStreamReader);
                    throw throwable;
                }
                IOUtils.closeQuietly(inputStream, inputStreamReader);
            }
            IOUtils.closeQuietly(inputStream, inputStreamReader);
            return iXMLElement;
        }
        IOUtils.closeQuietly(inputStream, inputStreamReader);
        return null;
    }

    private static String validateSessionTimeout(int n2, IXMLElement iXMLElement) {
        int n3;
        String string = StringUtils.trimToNull(iXMLElement.getContent());
        if (string == null) {
            return null;
        }
        try {
            n3 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        if (n2 == n3) {
            return ContrastSessionTimeoutRuleDispatcherImpl.generateLineSnippet(iXMLElement);
        }
        if (!(n2 != 0 && n2 != -1 || n3 != 0 && n3 != -1)) {
            return ContrastSessionTimeoutRuleDispatcherImpl.generateLineSnippet(iXMLElement);
        }
        return null;
    }

    private static String generateLineSnippet(IXMLElement iXMLElement) {
        return iXMLElement.getLineNr() + ": <" + iXMLElement.getName() + ">" + StringUtils.trimToEmpty(iXMLElement.getContent()) + "</" + iXMLElement.getName() + ">\n";
    }

    public void onSessionObtained(Object object, Object object2) {
        if (object2 == null) {
            logger.debug("Session provided to {} was null. Skipping checks for overly-long session timeout.", (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
            return;
        }
        ContrastContext contrastContext = (ContrastContext)object;
        Application application = contrastContext.application().current();
        if (application == null) {
            logger.debug("Current application provided to {} was null. Skipping checks for overly-long session timeout.", (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
            return;
        }
        if (!application.getState().isResolved()) {
            logger.debug("Current application {} provided to {} was not resolved. Skipping checks for overly-long session timeout.", (Object)application, (Object)ContrastSessionTimeoutRuleDispatcherImpl.class.getName());
            return;
        }
        ApplicationExecutionContext applicationExecutionContext = application.context();
        if (applicationExecutionContext.get(SESSION_TIMEOUT_REPORTER) != null) {
            return;
        }
        Integer n2 = this.reflector.c(object2);
        if (n2 == null) {
            logger.debug("HttpSession.getMaxInactiveInterval() threw an error or returned null. Skipping checks for overly-long session timeout.");
            return;
        }
        applicationExecutionContext.putIfAbsent(SESSION_TIMEOUT_REPORTER, Suppliers.memoize(() -> {
            boolean bl2;
            boolean bl3 = bl2 = n2 < 1;
            if (bl2 || (long)n2.intValue() > this.maxAllowedTimeoutInSeconds) {
                long l2 = this.configurationHasher.a("session-timeout", application.getResolvedFilePath() + File.separatorChar + "WEB-INF" + File.separatorChar + "web.xml");
                int n3 = ContrastSessionTimeoutRuleDispatcherImpl.timeoutInMinutes(n2);
                String string = ContrastSessionTimeoutRuleDispatcherImpl.getEvidenceFromWebXml(this.reflector, n3, object2, application);
                boolean bl4 = string == null;
                this.providerUtil.reportFinding(contrastContext, "session-timeout", null, l2, bl4 ? "servletContext.setSessionTimeout(" + n3 + ")" : string, false);
                logger.debug("Found vulnerable session timeout value {} (a timeout of zero or less indicates an unlimited timeout) for application: {}. Session timeout values must be less than configured value of {} from {}.", new Object[]{n2, application, this.maxAllowedTimeoutInSeconds, ConfigProperty.WEB_SESSION_TIMEOUT});
            } else {
                logger.debug("Found safe session timeout value {} for application: {}. Session timeout values must be less than configured value of {} from {}.", new Object[]{n2, application, this.maxAllowedTimeoutInSeconds, ConfigProperty.WEB_SESSION_TIMEOUT});
            }
            return null;
        }));
        applicationExecutionContext.get(SESSION_TIMEOUT_REPORTER).get();
    }
}

