/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.telemetry.metrics;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.telemetry.metrics.MetricBuilder;
import com.contrastsecurity.agent.telemetry.metrics.TelemetryMetrics;
import com.contrastsecurity.agent.telemetry.metrics.f;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@DontObfuscate
public interface Counter
extends f {
    public void increment();

    public void increment(double var1);

    public double count();

    @DontObfuscate
    public static class Builder
    implements MetricBuilder<Counter> {
        private final TelemetryMetrics metrics;
        private final String name;
        private final TelemetryMetrics.TelemetryCategory category;
        private String description;
        private String baseUnit;
        private final Map<String, String> tags;
        private long expirationDate;

        public Builder(TelemetryMetrics telemetryMetrics, String string, TelemetryMetrics.TelemetryCategory telemetryCategory) {
            this.metrics = Objects.requireNonNull(telemetryMetrics);
            this.name = Preconditions.checkNotEmpty(string);
            this.category = Objects.requireNonNull(telemetryCategory);
            this.tags = new HashMap<String, String>(2);
            this.expirationDate = 7258118400000L;
        }

        public Builder withTag(String string, String string2) {
            this.tags.put(string, string2);
            return this;
        }

        @Override
        public Class<Counter> typeBuilt() {
            return Counter.class;
        }

        public Builder withDescription(String string) {
            this.description = string;
            return this;
        }

        public Builder withBaseUnit(String string) {
            this.baseUnit = string;
            return this;
        }

        @Override
        public String getName() {
            return this.name;
        }

        public TelemetryMetrics.TelemetryCategory getCategory() {
            return this.category;
        }

        public String getDescription() {
            return this.description;
        }

        public String getBaseUnit() {
            return this.baseUnit;
        }

        @Override
        public Map<String, String> getTags() {
            return this.tags;
        }

        public long getExpirationTimeMs() {
            return this.expirationDate;
        }

        public Builder withExpiration(LocalDate localDate) {
            this.expirationDate = localDate.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
            return this;
        }

        @q
        public Builder withExpirationTimeMs(long l2) {
            this.expirationDate = l2;
            return this;
        }

        @Override
        @q
        public Counter register(TelemetryMetrics telemetryMetrics) {
            return telemetryMetrics.register(this);
        }

        @Override
        public Counter register() {
            return this.register(this.metrics);
        }
    }
}

