/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.test.routecoverage;

import com.contrastsecurity.agent.DontObfuscate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DontObfuscate
public class AntPathMatcher {
    public static final String DEFAULT_PATH_SEPARATOR = "/";
    private static final int CACHE_TURNOFF_THRESHOLD = 65536;
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\{[^/]+?\\}");
    private static final char[] WILDCARD_CHARS = new char[]{'*', '?', '{'};
    private String pathSeparator;
    private PathSeparatorPatternCache pathSeparatorPatternCache;
    private boolean caseSensitive = true;
    private boolean trimTokens;
    private volatile Boolean cachePatterns;
    private final Map<String, String[]> tokenizedPatternCache = new ConcurrentHashMap<String, String[]>(256);
    final Map<String, AntPathStringMatcher> stringMatcherCache = new ConcurrentHashMap<String, AntPathStringMatcher>(256);
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public AntPathMatcher() {
        this.pathSeparator = DEFAULT_PATH_SEPARATOR;
        this.pathSeparatorPatternCache = new PathSeparatorPatternCache(DEFAULT_PATH_SEPARATOR);
    }

    public AntPathMatcher(String string) {
        this.pathSeparator = string;
        this.pathSeparatorPatternCache = new PathSeparatorPatternCache(string);
    }

    public void setPathSeparator(String string) {
        this.pathSeparator = string != null ? string : DEFAULT_PATH_SEPARATOR;
        this.pathSeparatorPatternCache = new PathSeparatorPatternCache(this.pathSeparator);
    }

    public void setCaseSensitive(boolean bl2) {
        this.caseSensitive = bl2;
    }

    public void setTrimTokens(boolean bl2) {
        this.trimTokens = bl2;
    }

    public void setCachePatterns(boolean bl2) {
        this.cachePatterns = bl2;
    }

    private void deactivatePatternCache() {
        this.cachePatterns = false;
        this.tokenizedPatternCache.clear();
        this.stringMatcherCache.clear();
    }

    public boolean isPattern(String string) {
        if (string == null) {
            return false;
        }
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '*' || c2 == '?') {
                return true;
            }
            if (c2 == '{') {
                bl2 = true;
                continue;
            }
            if (c2 != '}' || !bl2) continue;
            return true;
        }
        return false;
    }

    public boolean match(String string, String string2) {
        return this.doMatch(string, string2, true, null);
    }

    public boolean matchStart(String string, String string2) {
        return this.doMatch(string, string2, false, null);
    }

    protected boolean doMatch(String string, String string2, boolean bl2, Map<String, String> map) {
        String string3;
        int n2;
        if (string2 == null || string2.startsWith(this.pathSeparator) != string.startsWith(this.pathSeparator)) {
            return false;
        }
        String[] stringArray = this.tokenizePattern(string);
        if (bl2 && this.caseSensitive && !this.isPotentialMatch(string2, stringArray)) {
            return false;
        }
        String[] stringArray2 = this.tokenizePath(string2);
        int n3 = 0;
        int n4 = stringArray.length - 1;
        int n5 = stringArray2.length - 1;
        for (n2 = 0; n3 <= n4 && n2 <= n5 && !"**".equals(string3 = stringArray[n3]); ++n3, ++n2) {
            if (this.matchStrings(string3, stringArray2[n2], map)) continue;
            return false;
        }
        if (n2 > n5) {
            if (n3 > n4) {
                return string.endsWith(this.pathSeparator) == string2.endsWith(this.pathSeparator);
            }
            if (!bl2) {
                return true;
            }
            if (n3 == n4 && stringArray[n3].equals("*") && string2.endsWith(this.pathSeparator)) {
                return true;
            }
            for (int i2 = n3; i2 <= n4; ++i2) {
                if (stringArray[i2].equals("**")) continue;
                return false;
            }
            return true;
        }
        if (n3 > n4) {
            return false;
        }
        if (!bl2 && "**".equals(stringArray[n3])) {
            return true;
        }
        while (n3 <= n4 && n2 <= n5 && !"**".equals(string3 = stringArray[n4])) {
            if (!this.matchStrings(string3, stringArray2[n5], map)) {
                return false;
            }
            if (n4 == stringArray.length - 1 && string.endsWith(this.pathSeparator) != string2.endsWith(this.pathSeparator)) {
                return false;
            }
            --n4;
            --n5;
        }
        if (n2 > n5) {
            for (int i3 = n3; i3 <= n4; ++i3) {
                if (stringArray[i3].equals("**")) continue;
                return false;
            }
            return true;
        }
        while (n3 != n4 && n2 <= n5) {
            int n6;
            int n7 = -1;
            for (n6 = n3 + 1; n6 <= n4; ++n6) {
                if (!stringArray[n6].equals("**")) continue;
                n7 = n6;
                break;
            }
            if (n7 == n3 + 1) {
                ++n3;
                continue;
            }
            n6 = n7 - n3 - 1;
            int n8 = n5 - n2 + 1;
            int n9 = -1;
            block6: for (int i4 = 0; i4 <= n8 - n6; ++i4) {
                for (int i5 = 0; i5 < n6; ++i5) {
                    String string4 = stringArray[n3 + i5 + 1];
                    String string5 = stringArray2[n2 + i4 + i5];
                    if (!this.matchStrings(string4, string5, map)) continue block6;
                }
                n9 = n2 + i4;
                break;
            }
            if (n9 == -1) {
                return false;
            }
            n3 = n7;
            n2 = n9 + n6;
        }
        for (int i6 = n3; i6 <= n4; ++i6) {
            if (stringArray[i6].equals("**")) continue;
            return false;
        }
        return true;
    }

    private boolean isPotentialMatch(String string, String[] stringArray) {
        if (!this.trimTokens) {
            int n2 = 0;
            for (String string2 : stringArray) {
                int n3 = this.skipSeparator(string, n2, this.pathSeparator);
                if ((n3 = this.skipSegment(string, n2 += n3, string2)) < string2.length()) {
                    return n3 > 0 || string2.length() > 0 && this.isWildcardChar(string2.charAt(0));
                }
                n2 += n3;
            }
        }
        return true;
    }

    private int skipSegment(String string, int n2, String string2) {
        int n3 = 0;
        for (int i2 = 0; i2 < string2.length(); ++i2) {
            char c2 = string2.charAt(i2);
            if (this.isWildcardChar(c2)) {
                return n3;
            }
            int n4 = n2 + n3;
            if (n4 >= string.length()) {
                return 0;
            }
            if (c2 != string.charAt(n4)) continue;
            ++n3;
        }
        return n3;
    }

    private int skipSeparator(String string, int n2, String string2) {
        int n3 = 0;
        while (string.startsWith(string2, n2 + n3)) {
            n3 += string2.length();
        }
        return n3;
    }

    private boolean isWildcardChar(char c2) {
        for (char c3 : WILDCARD_CHARS) {
            if (c2 != c3) continue;
            return true;
        }
        return false;
    }

    protected String[] tokenizePattern(String string) {
        String[] stringArray = null;
        Boolean bl2 = this.cachePatterns;
        if (bl2 == null || bl2.booleanValue()) {
            stringArray = this.tokenizedPatternCache.get(string);
        }
        if (stringArray == null) {
            stringArray = this.tokenizePath(string);
            if (bl2 == null && this.tokenizedPatternCache.size() >= 65536) {
                this.deactivatePatternCache();
                return stringArray;
            }
            if (bl2 == null || bl2.booleanValue()) {
                this.tokenizedPatternCache.put(string, stringArray);
            }
        }
        return stringArray;
    }

    protected String[] tokenizePath(String string) {
        return AntPathMatcher.tokenizeToStringArray(string, this.pathSeparator, this.trimTokens, true);
    }

    private boolean matchStrings(String string, String string2, Map<String, String> map) {
        return this.getStringMatcher(string).matchStrings(string2, map);
    }

    public AntPathStringMatcher getStringMatcher(String string) {
        AntPathStringMatcher antPathStringMatcher = null;
        Boolean bl2 = this.cachePatterns;
        if (bl2 == null || bl2.booleanValue()) {
            antPathStringMatcher = this.stringMatcherCache.get(string);
        }
        if (antPathStringMatcher == null) {
            antPathStringMatcher = new AntPathStringMatcher(string, this.caseSensitive);
            if (bl2 == null && this.stringMatcherCache.size() >= 65536) {
                this.deactivatePatternCache();
                return antPathStringMatcher;
            }
            if (bl2 == null || bl2.booleanValue()) {
                this.stringMatcherCache.put(string, antPathStringMatcher);
            }
        }
        return antPathStringMatcher;
    }

    public static String[] tokenizeToStringArray(String string, String string2, boolean bl2, boolean bl3) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (bl2) {
                string3 = string3.trim();
            }
            if (bl3 && string3.length() <= 0) continue;
            arrayList.add(string3);
        }
        return AntPathMatcher.toStringArray(arrayList);
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection != null && !collection.isEmpty() ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public String extractPathWithinPattern(String string, String string2) {
        String[] stringArray = AntPathMatcher.tokenizeToStringArray(string, this.pathSeparator, this.trimTokens, true);
        String[] stringArray2 = AntPathMatcher.tokenizeToStringArray(string2, this.pathSeparator, this.trimTokens, true);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl2 = false;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string3 = stringArray[i2];
            if (string3.indexOf(42) <= -1 && string3.indexOf(63) <= -1) continue;
            while (i2 < stringArray2.length) {
                if (bl2 || i2 == 0 && !string.startsWith(this.pathSeparator)) {
                    stringBuilder.append(this.pathSeparator);
                }
                stringBuilder.append(stringArray2[i2]);
                bl2 = true;
                ++i2;
            }
        }
        return stringBuilder.toString();
    }

    public Map<String, String> extractUriTemplateVariables(String string, String string2) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        boolean bl2 = this.doMatch(string, string2, true, linkedHashMap);
        if (!bl2) {
            throw new IllegalStateException("Pattern \"" + string + "\" is not a match for \"" + string2 + "\"");
        }
        return linkedHashMap;
    }

    public static boolean hasText(String string) {
        return string != null && !string.isEmpty() && AntPathMatcher.containsText(string);
    }

    private static boolean containsText(CharSequence charSequence) {
        int n2 = charSequence.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (Character.isWhitespace(charSequence.charAt(i2))) continue;
            return true;
        }
        return false;
    }

    public String combine(String string, String string2) {
        boolean bl2;
        boolean bl3;
        if (!AntPathMatcher.hasText(string) && !AntPathMatcher.hasText(string2)) {
            return "";
        }
        if (!AntPathMatcher.hasText(string)) {
            return string2;
        }
        if (!AntPathMatcher.hasText(string2)) {
            return string;
        }
        boolean bl4 = bl3 = string.indexOf(123) != -1;
        if (!string.equals(string2) && !bl3 && this.match(string, string2)) {
            return string2;
        }
        if (string.endsWith(this.pathSeparatorPatternCache.getEndsOnWildCard())) {
            return this.concat(string.substring(0, string.length() - 2), string2);
        }
        if (string.endsWith(this.pathSeparatorPatternCache.getEndsOnDoubleWildCard())) {
            return this.concat(string, string2);
        }
        int n2 = string.indexOf("*.");
        if (bl3 || n2 == -1 || ".".equals(this.pathSeparator)) {
            return this.concat(string, string2);
        }
        String string3 = string.substring(n2 + 1);
        int n3 = string2.indexOf(46);
        String string4 = n3 == -1 ? string2 : string2.substring(0, n3);
        String string5 = n3 == -1 ? "" : string2.substring(n3);
        boolean bl5 = ".*".equals(string3) || string3.isEmpty();
        boolean bl6 = bl2 = ".*".equals(string5) || string5.isEmpty();
        if (!bl5 && !bl2) {
            throw new IllegalArgumentException("Cannot combine patterns: " + string + " vs " + string2);
        }
        String string6 = bl5 ? string5 : string3;
        return string4 + string6;
    }

    private String concat(String string, String string2) {
        boolean bl2 = string.endsWith(this.pathSeparator);
        boolean bl3 = string2.startsWith(this.pathSeparator);
        if (bl2 && bl3) {
            return string + string2.substring(1);
        }
        if (bl2 || bl3) {
            return string + string2;
        }
        return string + this.pathSeparator + string2;
    }

    public Comparator<String> getPatternComparator(String string) {
        return new AntPatternComparator(string);
    }

    @DontObfuscate
    private static class PathSeparatorPatternCache {
        private final String endsOnWildCard;
        private final String endsOnDoubleWildCard;

        public PathSeparatorPatternCache(String string) {
            this.endsOnWildCard = string + "*";
            this.endsOnDoubleWildCard = string + "**";
        }

        public String getEndsOnWildCard() {
            return this.endsOnWildCard;
        }

        public String getEndsOnDoubleWildCard() {
            return this.endsOnDoubleWildCard;
        }
    }

    @DontObfuscate
    public static class AntPathStringMatcher {
        private static final Pattern GLOB_PATTERN = Pattern.compile("\\?|\\*|\\{((?:\\{[^/]+?\\}|[^/{}]|\\\\[{}])+?)\\}");
        private static final String DEFAULT_VARIABLE_PATTERN = "((?s).*)";
        private final String rawPattern;
        private final boolean caseSensitive;
        private final boolean exactMatch;
        private final Pattern pattern;
        private final List<String> variableNames = new ArrayList<String>();

        public AntPathStringMatcher(String string) {
            this(string, true);
        }

        public AntPathStringMatcher(String string, boolean bl2) {
            this.rawPattern = string;
            this.caseSensitive = bl2;
            StringBuilder stringBuilder = new StringBuilder();
            Matcher matcher = GLOB_PATTERN.matcher(string);
            int n2 = 0;
            while (matcher.find()) {
                stringBuilder.append(this.quote(string, n2, matcher.start()));
                String string2 = matcher.group();
                if ("?".equals(string2)) {
                    stringBuilder.append('.');
                } else if ("*".equals(string2)) {
                    stringBuilder.append(".*");
                } else if (string2.startsWith("{") && string2.endsWith("}")) {
                    int n3 = string2.indexOf(58);
                    if (n3 == -1) {
                        stringBuilder.append(DEFAULT_VARIABLE_PATTERN);
                        this.variableNames.add(matcher.group(1));
                    } else {
                        String string3 = string2.substring(n3 + 1, string2.length() - 1);
                        stringBuilder.append('(');
                        stringBuilder.append(string3);
                        stringBuilder.append(')');
                        String string4 = string2.substring(1, n3);
                        this.variableNames.add(string4);
                    }
                }
                n2 = matcher.end();
            }
            if (n2 == 0) {
                this.exactMatch = true;
                this.pattern = null;
            } else {
                this.exactMatch = false;
                stringBuilder.append(this.quote(string, n2, string.length()));
                this.pattern = Pattern.compile(stringBuilder.toString(), 0x20 | (this.caseSensitive ? 0 : 2));
            }
        }

        private String quote(String string, int n2, int n3) {
            if (n2 == n3) {
                return "";
            }
            return Pattern.quote(string.substring(n2, n3));
        }

        public boolean matchStrings(String string, Map<String, String> map) {
            Matcher matcher;
            if (this.exactMatch) {
                return this.caseSensitive ? this.rawPattern.equals(string) : this.rawPattern.equalsIgnoreCase(string);
            }
            if (this.pattern != null && (matcher = this.pattern.matcher(string)).matches()) {
                if (map != null) {
                    if (this.variableNames.size() != matcher.groupCount()) {
                        throw new IllegalArgumentException("The number of capturing groups in the pattern segment " + this.pattern + " does not match the number of URI template variables it defines, which can occur if capturing groups are used in a URI template regex. Use non-capturing groups instead.");
                    }
                    for (int i2 = 1; i2 <= matcher.groupCount(); ++i2) {
                        String string2 = this.variableNames.get(i2 - 1);
                        if (string2.startsWith("*")) {
                            throw new IllegalArgumentException("Capturing patterns (" + string2 + ") are not supported by the AntPathMatcher. Use the PathPatternParser instead.");
                        }
                        String string3 = matcher.group(i2);
                        map.put(string2, string3);
                    }
                }
                return true;
            }
            return false;
        }
    }

    @DontObfuscate
    protected static class AntPatternComparator
    implements Comparator<String> {
        private final String path;

        public AntPatternComparator(String string) {
            this.path = string;
        }

        @Override
        public int compare(String string, String string2) {
            a a2 = new a(string);
            a a3 = new a(string2);
            if (a2.e() && a3.e()) {
                return 0;
            }
            if (a2.e()) {
                return 1;
            }
            if (a3.e()) {
                return -1;
            }
            boolean bl2 = string.equals(this.path);
            boolean bl3 = string2.equals(this.path);
            if (bl2 && bl3) {
                return 0;
            }
            if (bl2) {
                return -1;
            }
            if (bl3) {
                return 1;
            }
            if (a2.f() && a3.f()) {
                return a3.h() - a2.h();
            }
            if (a2.f() && a3.d() == 0) {
                return 1;
            }
            if (a3.f() && a2.d() == 0) {
                return -1;
            }
            if (a2.g() != a3.g()) {
                return a2.g() - a3.g();
            }
            if (a2.h() != a3.h()) {
                return a3.h() - a2.h();
            }
            if (a2.c() < a3.c()) {
                return -1;
            }
            if (a3.c() < a2.c()) {
                return 1;
            }
            if (a2.b() < a3.b()) {
                return -1;
            }
            if (a3.b() < a2.b()) {
                return 1;
            }
            return 0;
        }

        private static class a {
            private final String a;
            private int b;
            private int c;
            private int d;
            private boolean e;
            private boolean f;
            private Integer g;

            public a(String string) {
                this.a = string;
                if (this.a != null) {
                    this.a();
                    this.e = "/**".equals(this.a);
                    boolean bl2 = this.f = !this.e && this.a.endsWith("/**");
                }
                if (this.b == 0) {
                    this.g = this.a != null ? this.a.length() : 0;
                }
            }

            protected void a() {
                int n2 = 0;
                if (this.a != null) {
                    while (n2 < this.a.length()) {
                        if (this.a.charAt(n2) == '{') {
                            ++this.b;
                            ++n2;
                            continue;
                        }
                        if (this.a.charAt(n2) == '*') {
                            if (n2 + 1 < this.a.length() && this.a.charAt(n2 + 1) == '*') {
                                ++this.d;
                                n2 += 2;
                                continue;
                            }
                            if (n2 > 0 && !this.a.substring(n2 - 1).equals(".*")) {
                                ++this.c;
                                ++n2;
                                continue;
                            }
                            ++n2;
                            continue;
                        }
                        ++n2;
                    }
                }
            }

            public int b() {
                return this.b;
            }

            public int c() {
                return this.c;
            }

            public int d() {
                return this.d;
            }

            public boolean e() {
                return this.a == null || this.e;
            }

            public boolean f() {
                return this.f;
            }

            public int g() {
                return this.b + this.c + 2 * this.d;
            }

            public int h() {
                if (this.g == null) {
                    this.g = this.a != null ? VARIABLE_PATTERN.matcher(this.a).replaceAll("#").length() : 0;
                }
                return this.g;
            }
        }
    }
}

