/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.agent.util;

import com.contrastsecurity.agent.DontObfuscate;
import com.contrastsecurity.agent.commons.Assert;
import com.contrastsecurity.agent.commons.BooleanOrDefault;
import com.contrastsecurity.agent.commons.Empty;
import com.contrastsecurity.agent.commons.Preconditions;
import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.config.Config;
import com.contrastsecurity.agent.config.ConfigProperty;
import com.contrastsecurity.agent.core.ContrastAgent;
import com.contrastsecurity.agent.n;
import com.contrastsecurity.agent.o;
import com.contrastsecurity.agent.q;
import com.contrastsecurity.agent.util.CpuInfo;
import com.contrastsecurity.agent.util.FileUtil;
import com.contrastsecurity.agent.util.JVMUtils;
import com.contrastsecurity.thirdparty.oa4j.commons.io.FileUtils;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import javax.management.ObjectName;

@o
@DontObfuscate
public final class C2Compiler {
    private final boolean shouldReEnable;
    private final ObjectName diagnosticCommandObjectName;
    private final AtomicBoolean alreadyReEnabled;
    private final AtomicReference<Exception> configurationException;
    public static final C2Compiler NO_OP = new C2Compiler(false, null);
    public static final double AUTOMATIC_C2_DELAY_CPU_THRESHOLD = 1.5;
    public static final double WARN_C2_DELAY_CPU_THRESHOLD = 2.0;
    private static final String DIAGNOSTIC_COMMAND_OBJECT_NAME_STRING = "com.sun.management:type=DiagnosticCommand";
    private static final String CONTRAST_DISABLE_C2_DIRECTIVE_ID = "contrastDisableC2Directive";
    private static final byte[] DISABLE_C2_DIRECTIVE_CONTENTS = "[{\"match\":[\"*.*\",\"contrastDisableC2Directive.contrastDisableC2Directive\"],\"c2\":{\"Exclude\":true}}]".getBytes(StandardCharsets.UTF_8);
    private static final String[] STRING_ARRAY_DESCRIPTOR = new String[]{"[Ljava.lang.String;"};

    @q
    C2Compiler(boolean bl2, ObjectName objectName) {
        if (bl2) {
            Objects.requireNonNull(objectName);
        } else {
            Preconditions.check(objectName == null, "diagnosticCommandObjectName must be null when the C2Compiler does not need to be re-enabled.");
        }
        this.shouldReEnable = bl2;
        this.diagnosticCommandObjectName = objectName;
        this.alreadyReEnabled = new AtomicBoolean(false);
        this.configurationException = new AtomicReference<Object>(null);
    }

    @q
    boolean shouldReEnable() {
        return this.shouldReEnable && !this.alreadyReEnabled.get();
    }

    public boolean c2CompilationDelayed() {
        return this.shouldReEnable;
    }

    public void onLoggerInitialized(Config config) {
        Exception exception = this.configurationException.getAndSet(null);
        if (exception == null) {
            if (this.shouldReEnable) {
                b.a.info("Successfully disabled the JVM C2 compiler for startup. It will be re-enabled after the first request or {}ms.", (Object)config.getLong(ConfigProperty.DELAYED_C2_COMPILATION_TIMEOUT_MS));
            }
            return;
        }
        b.a.debug("", exception);
        b.a.warn("Failed to delay C2 compilation. Disabling {}. Enable debug logs for details.", (Object)ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull());
    }

    private C2Compiler configurationException(String string, Throwable throwable) {
        final class A
        extends Exception {
            A(String string, Throwable throwable) {
                super(string, throwable);
            }

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        }
        A a2 = new A(string, throwable);
        if (!this.configurationException.compareAndSet(null, a2)) {
            Exception exception = this.configurationException.get();
            exception.addSuppressed(a2);
            Assert.fail("Multiple configuration errors occurred when attempting to configure C2 Compiler.", exception);
        }
        return this;
    }

    public static C2Compiler configureC2Compilation(Config config, CpuInfo cpuInfo) {
        BooleanOrDefault booleanOrDefault = config.getEnum(BooleanOrDefault.class, ConfigProperty.DELAYED_C2_COMPILATION);
        if (booleanOrDefault == BooleanOrDefault.FALSE) {
            return NO_OP;
        }
        if (JVMUtils.isJava8()) {
            if (booleanOrDefault == BooleanOrDefault.TRUE) {
                config.invalidLog().a(ConfigProperty.DELAYED_C2_COMPILATION, "Java 8 does not support delayed C2 compilation.");
            }
            return NO_OP;
        }
        if (ContrastAgent.getStartupDelay(config) > 0) {
            if (booleanOrDefault == BooleanOrDefault.TRUE) {
                config.invalidLog().a(ConfigProperty.DELAYED_C2_COMPILATION, ConfigProperty.DELAYED_STARTUP.commonConfigPathOrNull() + " is enabled and takes precedence over " + ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull() + ". Disabling " + ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull());
            }
            return NO_OP;
        }
        if (config.getLong(ConfigProperty.DELAYED_C2_COMPILATION_TIMEOUT_MS) < 1L) {
            if (booleanOrDefault == BooleanOrDefault.TRUE) {
                config.invalidLog().a(ConfigProperty.DELAYED_C2_COMPILATION_TIMEOUT_MS, ConfigProperty.DELAYED_C2_COMPILATION_TIMEOUT_MS.commonConfigPathOrNull() + " was less than 1. Disabling " + ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull());
            }
            return NO_OP;
        }
        double d2 = cpuInfo.cpuLimit();
        if (booleanOrDefault == BooleanOrDefault.DEFAULT && d2 > 1.5) {
            return NO_OP;
        }
        return System.getSecurityManager() == null ? C2Compiler.disableC2CompilationIfPossible() : n.a(C2Compiler::disableC2CompilationIfPossible);
    }

    private static C2Compiler disableC2CompilationIfPossible() {
        File file;
        ObjectName objectName;
        try {
            objectName = C2Compiler.newDiagnosticCommandObjectName();
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            return NO_OP.configurationException("Failed to delay C2 compilation. Failed to create ObjectName for com.sun.management:type=DiagnosticCommand", throwable2);
        }
        try {
            file = FileUtil.deleteOnExit(File.createTempFile(CONTRAST_DISABLE_C2_DIRECTIVE_ID, ".json", FileUtils.getTempDirectory()));
            Files.write(file.toPath(), DISABLE_C2_DIRECTIVE_CONTENTS, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException iOException) {
            return NO_OP.configurationException("Failed to delay C2 compilation. Failed to set up contrastDisableC2Directive.json.", iOException);
        }
        Object[] objectArray = C2Compiler.toCompilerDirectivesAddCommandArgs(file);
        Throwable throwable = C2Compiler.pushCompilerDirective(objectName, objectArray);
        if (throwable != null) {
            return NO_OP.configurationException("Failed to delay C2 compilation. Failed to push compiler directive.", throwable);
        }
        return new C2Compiler(true, objectName);
    }

    public void reEnableC2CompilationIfNecessary(ScheduledExecutorService scheduledExecutorService, long l2) {
        if (!this.shouldReEnable()) {
            return;
        }
        Consumer<Throwable> consumer = throwable -> b.a.error("Failed to re-enable C2 compiler. Your application's code will not be optimized. Please disable {} in your environment and restart your application.", (Object)ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull(), throwable);
        try {
            scheduledExecutorService.schedule(() -> {
                switch (this._reEnableC2CompilationIfNecessary()) {
                    case a: {
                        return;
                    }
                    case b: {
                        consumer.accept(null);
                        return;
                    }
                    case c: {
                        b.a.info("Successfully re-enabled JVM C2 compiler.");
                    }
                }
            }, l2, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            consumer.accept(rejectedExecutionException);
        }
    }

    @q
    boolean reEnableC2CompilationIfNecessary() {
        return this._reEnableC2CompilationIfNecessary() == c.c;
    }

    private c _reEnableC2CompilationIfNecessary() {
        Throwable throwable;
        boolean bl2;
        if (!this.shouldReEnable) {
            return c.a;
        }
        if (!this.alreadyReEnabled.compareAndSet(false, true)) {
            b.a.debug("The Contrast C2Compiler API does not currently support re-enabling the C2 compiler multiple times.");
            return c.a;
        }
        String string = this.getCompilerDirectives();
        if (string != null) {
            bl2 = string.contains(CONTRAST_DISABLE_C2_DIRECTIVE_ID);
            if (!bl2) {
                if (Assert.ENABLED) {
                    Assert.fail("contrastDisableC2Directive was not pushed.");
                }
                b.a.debug("{} was not pushed.", (Object)CONTRAST_DISABLE_C2_DIRECTIVE_ID);
                return c.b;
            }
        } else {
            bl2 = false;
            if (Assert.ENABLED) {
                Assert.fail("Failed to verify if contrastDisableC2Directive was added.");
            }
            b.a.debug("Failed to verify if {} was added.", (Object)CONTRAST_DISABLE_C2_DIRECTIVE_ID);
        }
        if ((throwable = this.popCompilerDirective()) != null) {
            b.a.debug("Failed to re-enable C2 compiler. Your application's code will not be optimized. Please disable {} in your environment and restart your application.", (Object)ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull(), (Object)throwable);
            return c.b;
        }
        if (bl2) {
            String string2 = this.getCompilerDirectives();
            if (string2 == null) {
                if (Assert.ENABLED) {
                    Assert.fail("Failed to verify if contrastDisableC2Directive was removed.");
                }
                b.a.debug("Failed to verify if {} was removed.", (Object)CONTRAST_DISABLE_C2_DIRECTIVE_ID);
                return c.c;
            }
            if (string2.contains(CONTRAST_DISABLE_C2_DIRECTIVE_ID)) {
                b.a.debug("Failed to re-enable C2 compiler. {} is not compatible with dynamic compiler directives. Please disable {} in your environment and restart your application.", (Object)ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull(), (Object)ConfigProperty.DELAYED_C2_COMPILATION.commonConfigPathOrNull());
                return c.b;
            }
        }
        return c.c;
    }

    @q
    static ObjectName newDiagnosticCommandObjectName() throws Throwable {
        return new ObjectName(DIAGNOSTIC_COMMAND_OBJECT_NAME_STRING);
    }

    private static Object[] toCompilerDirectivesAddCommandArgs(File file) {
        return new Object[]{new String[]{file.getAbsolutePath()}};
    }

    @q
    Throwable pushCompilerDirective(File file) {
        return C2Compiler.pushCompilerDirective(this.diagnosticCommandObjectName, C2Compiler.toCompilerDirectivesAddCommandArgs(file));
    }

    private static Throwable pushCompilerDirective(ObjectName objectName, Object[] objectArray) {
        if (objectName == null) {
            return new IllegalStateException("Contrast compiler directive utilities are disabled.");
        }
        try {
            ManagementFactory.getPlatformMBeanServer().invoke(objectName, "compilerDirectivesAdd", objectArray, STRING_ARRAY_DESCRIPTOR);
            return null;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            return throwable2;
        }
    }

    private Throwable popCompilerDirective() {
        if (this.diagnosticCommandObjectName == null) {
            return new IllegalStateException("Contrast compiler directive utilities are disabled.");
        }
        try {
            ManagementFactory.getPlatformMBeanServer().invoke(this.diagnosticCommandObjectName, "compilerDirectivesRemove", Empty.STRING_ARRAY, Empty.STRING_ARRAY);
            return null;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            return throwable2;
        }
    }

    private String getCompilerDirectives() {
        if (this.diagnosticCommandObjectName == null) {
            return null;
        }
        try {
            Object object = ManagementFactory.getPlatformMBeanServer().invoke(this.diagnosticCommandObjectName, "compilerDirectivesPrint", Empty.STRING_ARRAY, Empty.STRING_ARRAY);
            return object != null ? object.toString() : null;
        }
        catch (Throwable throwable) {
            Throwables.throwIfCritical(throwable);
            Throwable throwable2 = throwable;
            b.a.debug("Failed to print compiler directives.", throwable2);
            return null;
        }
    }

    public static boolean shouldLogWarnings(Config config) {
        return !JVMUtils.isJava8() && ContrastAgent.getStartupDelay(config) <= 0;
    }

    static final class b {
        static final Logger a = LoggerFactory.getLogger(C2Compiler.class);

        private b() {
        }
    }

    private static enum c {
        a,
        b,
        c;

    }
}

