/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cesyb;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.cesyb.Beans;
import com.contrastsecurity.thirdparty.cesyb.YamlConfig;
import com.contrastsecurity.thirdparty.cesyb.YamlException;
import com.contrastsecurity.thirdparty.cesyb.document.YamlElement;
import com.contrastsecurity.thirdparty.cesyb.emitter.Emitter;
import com.contrastsecurity.thirdparty.cesyb.emitter.EmitterException;
import com.contrastsecurity.thirdparty.cesyb.parser.AliasEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.DocumentEndEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.DocumentStartEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.Event;
import com.contrastsecurity.thirdparty.cesyb.parser.MappingStartEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.ScalarEvent;
import com.contrastsecurity.thirdparty.cesyb.parser.SequenceStartEvent;
import com.contrastsecurity.thirdparty.cesyb.scalar.ScalarSerializer;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class YamlWriter
implements AutoCloseable {
    private final YamlConfig config;
    private final Emitter emitter;
    private boolean started;
    private Map<Class, Object> defaultValuePrototypes = new IdentityHashMap<Class, Object>();
    private final List queuedObjects = new ArrayList();
    private final Map<Object, Integer> referenceCount = new IdentityHashMap<Object, Integer>();
    private final Map<Object, String> anchoredObjects = new HashMap<Object, String>();
    private int nextAnchor = 1;
    private boolean isRoot;

    public YamlWriter(Writer writer) {
        this(writer, new YamlConfig());
    }

    public YamlWriter(Writer writer, YamlConfig yamlConfig) {
        this.config = yamlConfig;
        this.emitter = new Emitter(writer, yamlConfig.writeConfig.emitterConfig);
    }

    public void setAlias(Object object, String string) {
        this.anchoredObjects.put(object, string);
    }

    public void write(Object object) throws YamlException {
        if (this.config.writeConfig.autoAnchor) {
            this.countObjectReferences(object);
            this.queuedObjects.add(object);
            return;
        }
        this.writeInternal(object);
    }

    public YamlConfig getConfig() {
        return this.config;
    }

    private void writeInternal(Object object) throws YamlException {
        try {
            if (!this.started) {
                this.emitter.emit(Event.STREAM_START);
                this.started = true;
            }
            this.emitter.emit(new DocumentStartEvent(this.config.writeConfig.explicitFirstDocument, this.config.writeConfig.version, this.config.writeConfig.tags));
            this.isRoot = true;
            this.writeValue(object, this.config.writeConfig.writeRootTags ? null : object.getClass(), null, null);
            this.emitter.emit(new DocumentEndEvent(this.config.writeConfig.explicitEndDocument));
        }
        catch (EmitterException emitterException) {
            throw new YamlException("Error writing YAML.", emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException("Error writing YAML.", iOException);
        }
    }

    public void clearAnchors() throws YamlException {
        for (Object e2 : this.queuedObjects) {
            this.writeInternal(e2);
        }
        this.queuedObjects.clear();
        this.referenceCount.clear();
        this.nextAnchor = 1;
    }

    public void close() throws YamlException {
        this.clearAnchors();
        this.defaultValuePrototypes.clear();
        try {
            this.emitter.emit(Event.STREAM_END);
            this.emitter.close();
        }
        catch (EmitterException emitterException) {
            throw new YamlException(emitterException);
        }
        catch (IOException iOException) {
            throw new YamlException(iOException);
        }
    }

    private void writeValue(Object object, Class clazz, Class clazz2, Class clazz3) throws EmitterException, IOException, YamlException {
        Object object2;
        Map.Entry<Class, ScalarSerializer> entry2;
        Object object3;
        boolean bl2;
        boolean bl3 = this.isRoot;
        this.isRoot = false;
        if (object instanceof YamlElement) {
            ((YamlElement)object).emitEvent(this.emitter, this.config.writeConfig);
            return;
        }
        if (object == null) {
            this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, null, this.config.writeConfig.quote.c));
            return;
        }
        Class<?> clazz4 = object.getClass();
        boolean bl4 = bl2 = clazz == null;
        if (bl2) {
            clazz = clazz4;
        }
        String string = null;
        if (!Beans.isScalar(clazz4) && !(object instanceof Enum)) {
            string = this.anchoredObjects.get(object);
            if (this.config.writeConfig.autoAnchor) {
                object3 = this.referenceCount.get(object);
                if (object3 == null) {
                    this.emitter.emit(new AliasEvent(string));
                    return;
                }
                if ((Integer)object3 > 1) {
                    this.referenceCount.remove(object);
                    if (string == null) {
                        string = String.valueOf(this.nextAnchor++);
                        this.anchoredObjects.put(object, string);
                    }
                }
            }
        }
        object3 = null;
        boolean bl5 = false;
        if ((bl2 || clazz4 != clazz || this.config.writeConfig.writeClassName == YamlConfig.WriteClassName.ALWAYS) && this.config.writeConfig.writeClassName != YamlConfig.WriteClassName.NEVER) {
            bl5 = true;
            if ((bl2 || clazz == List.class) && clazz4 == ArrayList.class) {
                bl5 = false;
            }
            if ((bl2 || clazz == Map.class) && clazz4 == HashMap.class) {
                bl5 = false;
            }
            if (clazz == Set.class && clazz4 == HashSet.class) {
                bl5 = false;
            }
            if (clazz4 == clazz3) {
                bl5 = false;
            }
            if (bl5 && (object3 = this.config.classNameToTag.get(clazz4.getName())) == null) {
                object3 = clazz4.getName();
            }
        }
        for (Map.Entry<Class, ScalarSerializer> entry2 : this.config.scalarSerializers.entrySet()) {
            if (!entry2.getKey().isAssignableFrom(clazz4)) continue;
            ScalarSerializer scalarSerializer = entry2.getValue();
            this.emitter.emit(new ScalarEvent(null, (String)object3, new boolean[]{object3 == null, object3 == null}, scalarSerializer.write(object), this.config.writeConfig.quote.c));
            return;
        }
        if (Beans.isScalar(clazz4)) {
            this.emitter.emit(new ScalarEvent(null, (String)object3, new boolean[]{true, true}, String.valueOf(object), this.config.writeConfig.quote.c));
            return;
        }
        if (object instanceof Enum) {
            this.emitter.emit(new ScalarEvent(null, object.getClass().getName(), new boolean[]{object.getClass().equals(clazz), object.getClass().equals(clazz)}, ((Enum)object).name(), this.config.writeConfig.quote.c));
            return;
        }
        if (object instanceof Collection) {
            this.emitter.emit(new SequenceStartEvent(string, (String)object3, !bl5, this.config.writeConfig.isFlowStyle()));
            for (Map.Entry<Class, ScalarSerializer> entry2 : (Collection)object) {
                if (bl3 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = entry2.getClass();
                }
                this.writeValue(entry2, clazz2, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        if (object instanceof Map) {
            this.emitter.emit(new MappingStartEvent(string, (String)object3, !bl5, this.config.writeConfig.isFlowStyle()));
            object2 = (Map)object;
            entry2 = object2.entrySet().iterator();
            while (entry2.hasNext()) {
                Map.Entry entry3;
                Map.Entry entry4 = entry3 = entry2.next();
                Object k2 = entry4.getKey();
                Object v2 = entry4.getValue();
                if (bl3 && !this.config.writeConfig.writeRootElementTags) {
                    clazz2 = v2.getClass();
                }
                if (this.config.tagSuffix != null && k2 instanceof String) {
                    Object v3;
                    if (((String)k2).endsWith(this.config.tagSuffix)) continue;
                    if (v2 instanceof String && (v3 = object2.get(k2 + this.config.tagSuffix)) instanceof String) {
                        this.writeValue(k2, null, null, null);
                        this.emitter.emit(new ScalarEvent(null, (String)v3, new boolean[]{false, false}, (String)v2, this.config.writeConfig.quote.c));
                        continue;
                    }
                }
                this.writeValue(k2, null, null, null);
                this.writeValue(v2, clazz2, null, null);
            }
            this.emitter.emit(Event.MAPPING_END);
            return;
        }
        if (clazz.isArray()) {
            clazz2 = clazz.getComponentType();
            this.emitter.emit(new SequenceStartEvent(string, null, true, this.config.writeConfig.isFlowStyle()));
            int n2 = Array.getLength(object);
            for (int i2 = 0; i2 < n2; ++i2) {
                this.writeValue(Array.get(object, i2), clazz2, null, null);
            }
            this.emitter.emit(Event.SEQUENCE_END);
            return;
        }
        object2 = null;
        if (!this.config.writeConfig.writeDefaultValues && clazz4 != Class.class && (object2 = this.defaultValuePrototypes.get(clazz4)) == null && Beans.getDeferredConstruction(clazz4, this.config) == null) {
            try {
                object2 = Beans.createObject(clazz4, this.config.privateConstructors);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwables.throwIfCritical(invocationTargetException);
                entry2 = invocationTargetException;
                throw new YamlException("Error creating object prototype to determine default values.", (Throwable)((Object)entry2));
            }
            this.defaultValuePrototypes.put(clazz4, object2);
        }
        entry2 = Beans.getProperties(clazz4, this.config.beanProperties, this.config.privateFields, this.config);
        this.emitter.emit(new MappingStartEvent(string, (String)object3, !bl5, this.config.writeConfig.isFlowStyle()));
        Iterator iterator = entry2.iterator();
        while (iterator.hasNext()) {
            Object object4;
            Beans.Property property = (Beans.Property)iterator.next();
            try {
                Object object5;
                object4 = property.get(object);
                if (object2 != null) {
                    object5 = property.get(object2);
                    if (object4 == null && object5 == null || object4 != null && object5 != null && object5.equals(object4)) continue;
                }
                this.emitter.emit(new ScalarEvent(null, null, new boolean[]{true, true}, property.getName(), this.config.writeConfig.quote.c));
                object5 = this.config.propertyToElementType.get(property);
                Class clazz5 = this.config.propertyToDefaultType.get(property);
                this.writeValue(object4, property.getType(), (Class)object5, clazz5);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                object4 = exception;
                throw new YamlException("Error getting property '" + property + "' on class: " + clazz4.getName(), (Throwable)object4);
            }
        }
        this.emitter.emit(Event.MAPPING_END);
    }

    private void countObjectReferences(Object object) throws YamlException {
        if (object == null || Beans.isScalar(object.getClass())) {
            return;
        }
        Integer n2 = this.referenceCount.get(object);
        if (n2 != null) {
            this.referenceCount.put(object, n2 + 1);
            return;
        }
        this.referenceCount.put(object, 1);
        if (object instanceof Collection) {
            for (Object e2 : (Collection)object) {
                this.countObjectReferences(e2);
            }
            return;
        }
        if (object instanceof Map) {
            for (Object v2 : ((Map)object).values()) {
                this.countObjectReferences(v2);
            }
            return;
        }
        if (object.getClass().isArray()) {
            int n3 = Array.getLength(object);
            for (int i2 = 0; i2 < n3; ++i2) {
                this.countObjectReferences(Array.get(object, i2));
            }
            return;
        }
        Set<Beans.Property> set = Beans.getProperties(object.getClass(), this.config.beanProperties, this.config.privateFields, this.config);
        for (Beans.Property property : set) {
            Object object2;
            if (Beans.isScalar(property.getType())) continue;
            try {
                object2 = property.get(object);
            }
            catch (Exception exception) {
                Throwables.throwIfCritical(exception);
                Exception exception2 = exception;
                throw new YamlException("Error getting property '" + property + "' on class: " + object.getClass().getName(), exception2);
            }
            this.countObjectReferences(object2);
        }
    }
}

