/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.cggl.protobuf;

import java.util.Arrays;

public final class TextFormatParseLocation {
    public static final TextFormatParseLocation EMPTY = new TextFormatParseLocation(-1, -1);
    private final int line;
    private final int column;

    static TextFormatParseLocation create(int n2, int n3) {
        if (n2 == -1 && n3 == -1) {
            return EMPTY;
        }
        if (n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException(String.format("line and column values must be >= 0: line %d, column: %d", n2, n3));
        }
        return new TextFormatParseLocation(n2, n3);
    }

    private TextFormatParseLocation(int n2, int n3) {
        this.line = n2;
        this.column = n3;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        return String.format("ParseLocation{line=%d, column=%d}", this.line, this.column);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TextFormatParseLocation)) {
            return false;
        }
        TextFormatParseLocation textFormatParseLocation = (TextFormatParseLocation)object;
        return this.line == textFormatParseLocation.getLine() && this.column == textFormatParseLocation.getColumn();
    }

    public int hashCode() {
        int[] nArray = new int[]{this.line, this.column};
        return Arrays.hashCode(nArray);
    }
}

