/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client;

import com.contrastsecurity.thirdparty.crmq.client.ConnectionFactory;
import com.contrastsecurity.thirdparty.crmq.client.LongString;
import com.contrastsecurity.thirdparty.crmq.client.SaslConfig;
import com.contrastsecurity.thirdparty.crmq.client.SaslMechanism;
import com.contrastsecurity.thirdparty.crmq.client.impl.LongStringHelper;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

public class JDKSaslConfig
implements SaslConfig {
    private static final String[] DEFAULT_PREFERRED_MECHANISMS = new String[]{"PLAIN"};
    private final ConnectionFactory factory;
    private final List<String> mechanisms;
    private final CallbackHandler callbackHandler;

    public JDKSaslConfig(ConnectionFactory connectionFactory) {
        this(connectionFactory, DEFAULT_PREFERRED_MECHANISMS);
    }

    public JDKSaslConfig(ConnectionFactory connectionFactory, String[] stringArray) {
        this.factory = connectionFactory;
        this.callbackHandler = new UsernamePasswordCallbackHandler(connectionFactory);
        this.mechanisms = Arrays.asList(stringArray);
    }

    @Override
    public SaslMechanism getSaslMechanism(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        for (String string : this.mechanisms) {
            if (!hashSet.contains(string)) continue;
            try {
                SaslClient saslClient = Sasl.createSaslClient(new String[]{string}, null, "AMQP", this.factory.getHost(), null, this.callbackHandler);
                if (saslClient == null) continue;
                return new JDKSaslMechanism(saslClient);
            }
            catch (SaslException saslException) {
                throw new RuntimeException(saslException);
            }
        }
        return null;
    }

    private class UsernamePasswordCallbackHandler
    implements CallbackHandler {
        private final ConnectionFactory factory;

        public UsernamePasswordCallbackHandler(ConnectionFactory connectionFactory) {
            this.factory = connectionFactory;
        }

        @Override
        public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbackArray) {
                Callback callback2;
                if (callback instanceof NameCallback) {
                    callback2 = (NameCallback)callback;
                    ((NameCallback)callback2).setName(this.factory.getUsername());
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    callback2 = (PasswordCallback)callback;
                    ((PasswordCallback)callback2).setPassword(this.factory.getPassword().toCharArray());
                    continue;
                }
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
        }
    }

    private class JDKSaslMechanism
    implements SaslMechanism {
        private final SaslClient client;

        public JDKSaslMechanism(SaslClient saslClient) {
            this.client = saslClient;
        }

        @Override
        public String getName() {
            return this.client.getMechanismName();
        }

        @Override
        public LongString handleChallenge(LongString longString, String string, String string2) {
            try {
                return LongStringHelper.asLongString(this.client.evaluateChallenge(longString.getBytes()));
            }
            catch (SaslException saslException) {
                throw new RuntimeException(saslException);
            }
        }
    }
}

