/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.client;

import com.contrastsecurity.thirdparty.crmq.client.SocketConfigurators;
import com.contrastsecurity.thirdparty.crmq.client.SslEngineConfigurator;
import java.io.IOException;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;

public abstract class SslEngineConfigurators {
    public static AbstractSslEngineConfigurator DEFAULT = new AbstractSslEngineConfigurator(){

        @Override
        public void configure(SSLEngine sSLEngine) {
        }
    };
    public static AbstractSslEngineConfigurator ENABLE_HOSTNAME_VERIFICATION = new AbstractSslEngineConfigurator(){

        @Override
        public void configure(SSLEngine sSLEngine) throws IOException {
            SSLParameters sSLParameters = SocketConfigurators.enableHostnameVerification(sSLEngine.getSSLParameters());
            sSLEngine.setSSLParameters(sSLParameters);
        }
    };

    public static AbstractSslEngineConfigurator defaultConfigurator() {
        return DEFAULT;
    }

    public static AbstractSslEngineConfigurator enableHostnameVerification() {
        return ENABLE_HOSTNAME_VERIFICATION;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AbstractSslEngineConfigurator configurator = new AbstractSslEngineConfigurator(){

            @Override
            public void configure(SSLEngine sSLEngine) {
            }
        };

        public Builder defaultConfigurator() {
            this.configurator = this.configurator.andThen(DEFAULT);
            return this;
        }

        public Builder enableHostnameVerification() {
            this.configurator = this.configurator.andThen(ENABLE_HOSTNAME_VERIFICATION);
            return this;
        }

        public Builder add(SslEngineConfigurator sslEngineConfigurator) {
            this.configurator = this.configurator.andThen(sslEngineConfigurator);
            return this;
        }

        public SslEngineConfigurator build() {
            return this.configurator;
        }
    }

    public static abstract class AbstractSslEngineConfigurator
    implements SslEngineConfigurator {
        public AbstractSslEngineConfigurator andThen(final SslEngineConfigurator sslEngineConfigurator) {
            if (sslEngineConfigurator == null) {
                throw new NullPointerException();
            }
            return new AbstractSslEngineConfigurator(){

                @Override
                public void configure(SSLEngine sSLEngine) throws IOException {
                    AbstractSslEngineConfigurator.this.configure(sSLEngine);
                    sslEngineConfigurator.configure(sSLEngine);
                }
            };
        }
    }
}

