/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.crmq.tools.jsonrpc;

import com.contrastsecurity.thirdparty.cfx.jackson.core.JsonParser;
import com.contrastsecurity.thirdparty.cfx.jackson.core.JsonProcessingException;
import com.contrastsecurity.thirdparty.cfx.jackson.core.JsonToken;
import com.contrastsecurity.thirdparty.cfx.jackson.core.TreeNode;
import com.contrastsecurity.thirdparty.cfx.jackson.databind.MappingJsonFactory;
import com.contrastsecurity.thirdparty.cfx.jackson.databind.ObjectMapper;
import com.contrastsecurity.thirdparty.cfx.jackson.databind.node.ValueNode;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.JsonRpcException;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.JsonRpcMapper;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.JsonRpcMappingException;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ProcedureDescription;
import com.contrastsecurity.thirdparty.crmq.tools.jsonrpc.ServiceDescription;
import com.contrastsecurity.thirdparty.os4j.Logger;
import com.contrastsecurity.thirdparty.os4j.LoggerFactory;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;

public class JacksonJsonRpcMapper
implements JsonRpcMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(JacksonJsonRpcMapper.class);
    private final ObjectMapper mapper;

    public JacksonJsonRpcMapper(ObjectMapper objectMapper) {
        this.mapper = objectMapper;
    }

    public JacksonJsonRpcMapper() {
        this(new ObjectMapper());
    }

    @Override
    public JsonRpcMapper.JsonRpcRequest parse(String string, ServiceDescription serviceDescription) {
        Method method;
        Object object;
        Object object2;
        MappingJsonFactory mappingJsonFactory = new MappingJsonFactory();
        String string2 = null;
        String string3 = null;
        ArrayList<TreeNode> arrayList = new ArrayList<TreeNode>();
        Object object3 = null;
        JsonParser jsonParser = null;
        try {
            jsonParser = mappingJsonFactory.createParser(string);
            while (jsonParser.nextToken() != null) {
                object2 = jsonParser.currentToken();
                if (object2 != JsonToken.FIELD_NAME) continue;
                object = jsonParser.currentName();
                object2 = jsonParser.nextToken();
                if ("method".equals(object)) {
                    string2 = jsonParser.getValueAsString();
                    continue;
                }
                if ("id".equals(object)) {
                    method = jsonParser.readValueAsTree();
                    if (method instanceof ValueNode) {
                        ValueNode valueNode = (ValueNode)method;
                        if (valueNode.isNull()) {
                            object3 = null;
                            continue;
                        }
                        if (valueNode.isTextual()) {
                            object3 = valueNode.asText();
                            continue;
                        }
                        if (valueNode.isNumber()) {
                            object3 = valueNode.asLong();
                            continue;
                        }
                        LOGGER.warn("ID type not null, text, or number {}, ignoring", (Object)valueNode);
                        continue;
                    }
                    LOGGER.warn("ID not a scalar value {}, ignoring", (Object)method);
                    continue;
                }
                if ("version".equals(object)) {
                    string3 = jsonParser.getValueAsString();
                    continue;
                }
                if (!"params".equals(object)) continue;
                if (object2 == JsonToken.START_ARRAY) {
                    while (jsonParser.nextToken() != JsonToken.END_ARRAY) {
                        arrayList.add(jsonParser.readValueAsTree());
                    }
                    continue;
                }
                throw new IllegalStateException("Field params must be an array");
            }
        }
        catch (IOException iOException) {
            throw new JsonRpcMappingException("Error during JSON parsing", iOException);
        }
        finally {
            if (jsonParser != null) {
                try {
                    jsonParser.close();
                }
                catch (IOException iOException) {
                    throw new JsonRpcMappingException("Error while closing JSON parser", iOException);
                }
            }
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Could not find method to invoke in request");
        }
        object2 = new ArrayList(arrayList.size());
        if (!arrayList.isEmpty()) {
            object = serviceDescription.getProcedure(string2, arrayList.size());
            method = ((ProcedureDescription)object).internal_getMethod();
            for (int i2 = 0; i2 < method.getParameterTypes().length; ++i2) {
                TreeNode treeNode = (TreeNode)arrayList.get(i2);
                try {
                    Class<?> clazz = method.getParameterTypes()[i2];
                    Object object4 = this.convert(treeNode, clazz);
                    object2.add(object4);
                    continue;
                }
                catch (IOException iOException) {
                    throw new JsonRpcMappingException("Error during parameter conversion", iOException);
                }
            }
        }
        return new JsonRpcMapper.JsonRpcRequest(object3, string3, string2, object2.toArray());
    }

    @Override
    public JsonRpcMapper.JsonRpcResponse parse(String string, Class<?> clazz) {
        MappingJsonFactory mappingJsonFactory = new MappingJsonFactory();
        Object object = null;
        JsonRpcException jsonRpcException = null;
        Map map = null;
        JsonParser jsonParser = null;
        try {
            jsonParser = mappingJsonFactory.createParser(string);
            while (jsonParser.nextToken() != null) {
                JsonToken jsonToken = jsonParser.currentToken();
                if (jsonToken != JsonToken.FIELD_NAME) continue;
                String string2 = jsonParser.currentName();
                if ("result".equals(string2)) {
                    jsonParser.nextToken();
                    if (clazz == Void.TYPE) {
                        object = null;
                        continue;
                    }
                    object = this.convert(jsonParser.readValueAsTree(), clazz);
                    continue;
                }
                if (!"error".equals(string2)) continue;
                map = (Map)this.convert(jsonParser.readValueAsTree(), Map.class);
                jsonRpcException = new JsonRpcException(map.toString(), (String)map.get("name"), map.get("code") == null ? 0 : (Integer)map.get("code"), (String)map.get("message"), map);
            }
        }
        catch (IOException iOException) {
            throw new JsonRpcMappingException("Error during JSON parsing", iOException);
        }
        finally {
            if (jsonParser != null) {
                try {
                    jsonParser.close();
                }
                catch (IOException iOException) {
                    throw new JsonRpcMappingException("Error while closing JSON parser", iOException);
                }
            }
        }
        return new JsonRpcMapper.JsonRpcResponse(object, map, jsonRpcException);
    }

    @Override
    public String write(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw new JsonRpcMappingException("Error during JSON serialization", jsonProcessingException);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convert(TreeNode treeNode, Class<?> clazz) throws IOException {
        if (!clazz.isPrimitive()) return this.mapper.readValue(treeNode.traverse(), clazz);
        ValueNode valueNode = (ValueNode)treeNode;
        if (clazz == Boolean.TYPE) {
            return valueNode.booleanValue();
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf(valueNode.textValue().charAt(0));
        }
        if (clazz == Short.TYPE) {
            return valueNode.shortValue();
        }
        if (clazz == Integer.TYPE) {
            return valueNode.intValue();
        }
        if (clazz == Long.TYPE) {
            return valueNode.longValue();
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(valueNode.floatValue());
        }
        if (clazz != Double.TYPE) throw new IllegalArgumentException("Primitive type not supported: " + clazz);
        return valueNode.doubleValue();
    }
}

