/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.db4j.automaton;

import com.contrastsecurity.thirdparty.db4j.automaton.Automaton;
import com.contrastsecurity.thirdparty.db4j.automaton.RegExp;
import com.contrastsecurity.thirdparty.db4j.automaton.RunAutomaton;
import com.contrastsecurity.thirdparty.db4j.automaton.RunAutomatonElements;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Objects;

public class MatchOnlyRunAutomaton
implements Serializable {
    static final long serialVersionUID = 50001L;
    private final RunAutomaton automaton;
    private final int internalFlags;
    private static final Automaton WILDCARD_ZERO_OR_MORE = new RegExp(".*").toAutomaton(true);
    private static final int ACCEPTED_STATE = -2;
    private static final char WHITESPACE_CHAR = ' ';

    public MatchOnlyRunAutomaton(Automaton automaton) {
        this(automaton, true);
    }

    public MatchOnlyRunAutomaton(Automaton automaton, boolean bl2) {
        Objects.requireNonNull(automaton);
        this.automaton = new RunAutomaton(MatchOnlyRunAutomaton.addWildcard(automaton), bl2, (Integer)-2);
        this.internalFlags = 0;
    }

    public MatchOnlyRunAutomaton(Automaton automaton, int n2) {
        this(automaton, n2, 0);
    }

    public MatchOnlyRunAutomaton(Automaton automaton, boolean bl2, int n2) {
        Objects.requireNonNull(automaton);
        this.automaton = new RunAutomaton(MatchOnlyRunAutomaton.addWildcard(automaton), bl2, (Integer)-2);
        this.internalFlags = n2;
    }

    public MatchOnlyRunAutomaton(Automaton automaton, int n2, int n3) {
        Objects.requireNonNull(automaton);
        this.automaton = new RunAutomaton(MatchOnlyRunAutomaton.addWildcard(automaton), n2, (Integer)-2);
        this.internalFlags = n3;
    }

    public MatchOnlyRunAutomaton(RunAutomatonElements runAutomatonElements, int n2) {
        this.automaton = new RunAutomaton(runAutomatonElements);
        this.internalFlags = n2;
    }

    public RunAutomaton getAutomaton() {
        return this.automaton;
    }

    public boolean matches(CharSequence charSequence) {
        if (charSequence == null) {
            return false;
        }
        if (this.internalFlags == 0) {
            return this.doMatch(charSequence, 0);
        }
        return this.doMatchWordBoundaryStartEndMatch(charSequence, 0);
    }

    public boolean matches(CharSequence charSequence, int n2) {
        if (charSequence == null) {
            return false;
        }
        if (n2 < 0 || n2 > charSequence.length() - 1 && n2 != 0) {
            throw new IllegalArgumentException("pos cannot be negative or larger than the input len");
        }
        if (this.internalFlags == 0) {
            return this.doMatch(charSequence, n2);
        }
        return this.doMatchWordBoundaryStartEndMatch(charSequence, n2);
    }

    private boolean doMatch(CharSequence charSequence, int n2) {
        int n3;
        int n4 = charSequence.length();
        int n5 = n3 = this.automaton.getInitialState();
        for (int i2 = n2; i2 < n4; ++i2) {
            if ((n5 = this.automaton.step(n5, charSequence.charAt(i2))) == -1) {
                n5 = n3;
                continue;
            }
            if (n5 != -2) continue;
            return true;
        }
        return this.automaton.isAccept(n5);
    }

    private boolean doMatchWordBoundaryStartEndMatch(CharSequence charSequence, int n2) {
        int n3;
        if (charSequence == null) {
            return false;
        }
        int n4 = n3 = this.automaton.getInitialState();
        int n5 = charSequence.length();
        if (n5 > 0 && (this.internalFlags & 1) != 0) {
            if ((n4 = this.automaton.step(n4, ' ')) == -2) {
                return true;
            }
            if (n4 == -1) {
                n4 = n3;
            }
        }
        for (int i2 = n2; i2 < n5; ++i2) {
            if ((n4 = this.automaton.step(n4, charSequence.charAt(i2))) == -1) {
                n4 = n3;
                continue;
            }
            if (n4 != -2) continue;
            return true;
        }
        if (n5 > 0 && (this.internalFlags & 2) != 0 && (n4 = this.automaton.step(n4, ' ')) == -2) {
            return true;
        }
        return this.automaton.isAccept(n4);
    }

    public static MatchOnlyRunAutomaton load(InputStream inputStream) throws IOException, ClassCastException, ClassNotFoundException {
        ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
        return (MatchOnlyRunAutomaton)objectInputStream.readObject();
    }

    public void store(OutputStream outputStream) throws IOException {
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(this);
        objectOutputStream.flush();
    }

    public String toString() {
        return this.automaton.toString();
    }

    public int getFlags() {
        return this.internalFlags;
    }

    private static Automaton addWildcard(Automaton automaton) {
        return WILDCARD_ZERO_OR_MORE.concatenate(automaton);
    }
}

