/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.db4j.automaton;

import com.contrastsecurity.thirdparty.db4j.automaton.Automaton;
import com.contrastsecurity.thirdparty.db4j.automaton.BasicOperations;
import com.contrastsecurity.thirdparty.db4j.automaton.State;
import com.contrastsecurity.thirdparty.db4j.automaton.StatePair;
import com.contrastsecurity.thirdparty.db4j.automaton.Transition;
import com.contrastsecurity.thirdparty.db4j.automaton.TransitionComparator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public final class ShuffleOperations {
    private ShuffleOperations() {
    }

    public static Automaton shuffle(Automaton automaton, Automaton automaton2) {
        State state;
        automaton.determinize();
        automaton2.determinize();
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        Transition[][] transitionArray2 = Automaton.getSortedTransitions(automaton2.getStates());
        Automaton automaton3 = new Automaton();
        LinkedList<StatePair> linkedList = new LinkedList<StatePair>();
        HashMap<StatePair, StatePair> hashMap = new HashMap<StatePair, StatePair>();
        automaton3.initial = state = new State();
        StatePair statePair = new StatePair(state, automaton.initial, automaton2.initial);
        linkedList.add(statePair);
        hashMap.put(statePair, statePair);
        while (linkedList.size() > 0) {
            StatePair statePair2;
            statePair = (StatePair)linkedList.removeFirst();
            statePair.s.accept = statePair.s1.accept && statePair.s2.accept;
            Transition[] transitionArray3 = transitionArray[statePair.s1.number];
            for (int i2 = 0; i2 < transitionArray3.length; ++i2) {
                StatePair statePair3 = new StatePair(transitionArray3[i2].to, statePair.s2);
                statePair2 = (StatePair)hashMap.get(statePair3);
                if (statePair2 == null) {
                    statePair3.s = new State();
                    linkedList.add(statePair3);
                    hashMap.put(statePair3, statePair3);
                    statePair2 = statePair3;
                }
                statePair.s.transitions.add(new Transition(transitionArray3[i2].min, transitionArray3[i2].max, statePair2.s));
            }
            Transition[] transitionArray4 = transitionArray2[statePair.s2.number];
            for (int i3 = 0; i3 < transitionArray4.length; ++i3) {
                statePair2 = new StatePair(statePair.s1, transitionArray4[i3].to);
                StatePair statePair4 = (StatePair)hashMap.get(statePair2);
                if (statePair4 == null) {
                    statePair2.s = new State();
                    linkedList.add(statePair2);
                    hashMap.put(statePair2, statePair2);
                    statePair4 = statePair2;
                }
                statePair.s.transitions.add(new Transition(transitionArray4[i3].min, transitionArray4[i3].max, statePair4.s));
            }
        }
        automaton3.deterministic = false;
        automaton3.removeDeadTransitions();
        automaton3.checkMinimizeAlways();
        return automaton3;
    }

    public static String shuffleSubsetOf(Collection<Automaton> collection, Automaton automaton, Character c2, Character c3) {
        Serializable serializable2;
        Transition[][][] transitionArrayArray;
        if (collection.size() == 0) {
            return null;
        }
        if (collection.size() == 1) {
            transitionArrayArray = collection.iterator().next();
            if (transitionArrayArray.isSingleton()) {
                if (automaton.run(transitionArrayArray.singleton)) {
                    return null;
                }
                return transitionArrayArray.singleton;
            }
            if (transitionArrayArray == automaton) {
                return null;
            }
        }
        automaton.determinize();
        transitionArrayArray = new Transition[collection.size()][][];
        int n2 = 0;
        for (Serializable serializable2 : collection) {
            transitionArrayArray[n2++] = Automaton.getSortedTransitions(serializable2.getStates());
        }
        Transition[][] transitionArray = Automaton.getSortedTransitions(automaton.getStates());
        serializable2 = new TransitionComparator(false);
        ShuffleConfiguration shuffleConfiguration = new ShuffleConfiguration(collection, automaton);
        LinkedList<ShuffleConfiguration> linkedList = new LinkedList<ShuffleConfiguration>();
        HashSet<ShuffleConfiguration> hashSet = new HashSet<ShuffleConfiguration>();
        linkedList.add(shuffleConfiguration);
        hashSet.add(shuffleConfiguration);
        block1: while (!linkedList.isEmpty()) {
            ShuffleConfiguration shuffleConfiguration2 = (ShuffleConfiguration)linkedList.removeFirst();
            boolean bl2 = true;
            for (int i2 = 0; i2 < collection.size(); ++i2) {
                if (shuffleConfiguration2.ca_states[i2].accept) continue;
                bl2 = false;
                break;
            }
            if (shuffleConfiguration2.a_state.accept) {
                bl2 = false;
            }
            if (bl2) {
                StringBuilder stringBuilder = new StringBuilder();
                while (shuffleConfiguration2.prev != null) {
                    stringBuilder.append(shuffleConfiguration2.min);
                    shuffleConfiguration2 = shuffleConfiguration2.prev;
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                for (int i3 = stringBuilder.length() - 1; i3 >= 0; --i3) {
                    stringBuilder2.append(stringBuilder.charAt(i3));
                }
                return stringBuilder2.toString();
            }
            Transition[] transitionArray2 = transitionArray[shuffleConfiguration2.a_state.number];
            for (int i4 = 0; i4 < collection.size(); ++i4) {
                if (shuffleConfiguration2.shuffle_suspended) {
                    i4 = shuffleConfiguration2.suspended1;
                }
                block6: for (Transition transition : transitionArrayArray[i4][shuffleConfiguration2.ca_states[i4].number]) {
                    int n3;
                    char c4;
                    Transition[] transitionArray3;
                    ArrayList<Transition> arrayList = new ArrayList<Transition>();
                    int n4 = Arrays.binarySearch(transitionArray2, transition, serializable2);
                    if (n4 < 0) {
                        n4 = -n4 - 1;
                    }
                    if (n4 > 0 && transitionArray2[n4 - 1].max >= transition.min) {
                        --n4;
                    }
                    while (n4 < transitionArray2.length) {
                        transitionArray3 = transitionArray2[n4++];
                        c4 = transition.min;
                        n3 = transition.max;
                        if (transitionArray3.min > c4) {
                            c4 = transitionArray3.min;
                        }
                        if (transitionArray3.max < n3) {
                            n3 = transitionArray3.max;
                        }
                        if (c4 > n3) break;
                        ShuffleOperations.add(c2, c3, linkedList, hashSet, shuffleConfiguration2, i4, transition, (Transition)transitionArray3, c4, (char)n3);
                        arrayList.add(new Transition(c4, (char)n3, null));
                    }
                    transitionArray3 = arrayList.toArray(new Transition[arrayList.size()]);
                    Arrays.sort(transitionArray3, serializable2);
                    c4 = transition.min;
                    for (n3 = 0; n3 < transitionArray3.length && transitionArray3[n3].min <= c4; ++n3) {
                        if (transitionArray3[n3].max >= transition.max) continue block6;
                        c4 = (char)(transitionArray3[n3].max + '\u0001');
                    }
                    ShuffleConfiguration shuffleConfiguration3 = new ShuffleConfiguration(shuffleConfiguration2, i4, transition.to, c4);
                    StringBuilder stringBuilder = new StringBuilder();
                    ShuffleConfiguration shuffleConfiguration4 = shuffleConfiguration3;
                    while (shuffleConfiguration4.prev != null) {
                        stringBuilder.append(shuffleConfiguration4.min);
                        shuffleConfiguration4 = shuffleConfiguration4.prev;
                    }
                    StringBuilder stringBuilder3 = new StringBuilder();
                    for (int i5 = stringBuilder.length() - 1; i5 >= 0; --i5) {
                        stringBuilder3.append(stringBuilder.charAt(i5));
                    }
                    if (shuffleConfiguration2.shuffle_suspended) {
                        stringBuilder3.append(BasicOperations.getShortestExample(shuffleConfiguration3.ca_states[shuffleConfiguration2.suspended1], true));
                    }
                    for (i4 = 0; i4 < collection.size(); ++i4) {
                        if (shuffleConfiguration2.shuffle_suspended && i4 == shuffleConfiguration2.suspended1) continue;
                        stringBuilder3.append(BasicOperations.getShortestExample(shuffleConfiguration3.ca_states[i4], true));
                    }
                    return stringBuilder3.toString();
                }
                if (shuffleConfiguration2.shuffle_suspended) continue block1;
            }
        }
        return null;
    }

    private static void add(Character c2, Character c3, LinkedList<ShuffleConfiguration> linkedList, Set<ShuffleConfiguration> set, ShuffleConfiguration shuffleConfiguration, int n2, Transition transition, Transition transition2, char c4, char c5) {
        int n3 = 55296;
        int n4 = 56319;
        if (c2 != null && c4 <= c2.charValue() && c2.charValue() <= c5 && c4 != c5) {
            if (c4 < c2.charValue()) {
                ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, c4, (char)(c2.charValue() - '\u0001'));
            }
            ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, c2.charValue(), c2.charValue());
            if (c2.charValue() < c5) {
                ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, (char)(c2.charValue() + '\u0001'), c5);
            }
        } else if (c3 != null && c4 <= c3.charValue() && c3.charValue() <= c5 && c4 != c5) {
            if (c4 < c3.charValue()) {
                ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, c4, (char)(c3.charValue() - '\u0001'));
            }
            ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, c3.charValue(), c3.charValue());
            if (c3.charValue() < c5) {
                ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, (char)(c3.charValue() + '\u0001'), c5);
            }
        } else if (c4 < '\ud800' && c5 >= '\ud800') {
            ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, c4, '\ud7ff');
            ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, '\ud800', c5);
        } else if (c4 <= '\udbff' && c5 > '\udbff') {
            ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, c4, '\udbff');
            ShuffleOperations.add(c2, c3, linkedList, set, shuffleConfiguration, n2, transition, transition2, '\udc00', c5);
        } else {
            ShuffleConfiguration shuffleConfiguration2 = new ShuffleConfiguration(shuffleConfiguration, n2, transition.to, transition2.to, c4);
            if (c2 != null && c4 == c2.charValue()) {
                shuffleConfiguration2.shuffle_suspended = true;
                shuffleConfiguration2.suspended1 = n2;
            } else if (c3 != null && c4 == c3.charValue()) {
                shuffleConfiguration2.shuffle_suspended = false;
            }
            if (c4 >= '\ud800' && c4 <= '\ud800') {
                shuffleConfiguration2.shuffle_suspended = true;
                shuffleConfiguration2.suspended1 = n2;
                shuffleConfiguration2.surrogate = true;
            }
            if (!set.contains(shuffleConfiguration2)) {
                linkedList.add(shuffleConfiguration2);
                set.add(shuffleConfiguration2);
            }
        }
    }

    static class ShuffleConfiguration {
        ShuffleConfiguration prev;
        State[] ca_states;
        State a_state;
        char min;
        int hash;
        boolean shuffle_suspended;
        boolean surrogate;
        int suspended1;

        private ShuffleConfiguration() {
        }

        ShuffleConfiguration(Collection<Automaton> collection, Automaton automaton) {
            this.ca_states = new State[collection.size()];
            int n2 = 0;
            for (Automaton automaton2 : collection) {
                this.ca_states[n2++] = automaton2.getInitialState();
            }
            this.a_state = automaton.getInitialState();
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration shuffleConfiguration, int n2, State state, char c2) {
            this.prev = shuffleConfiguration;
            this.ca_states = (State[])shuffleConfiguration.ca_states.clone();
            this.a_state = shuffleConfiguration.a_state;
            this.ca_states[n2] = state;
            this.min = c2;
            this.computeHash();
        }

        ShuffleConfiguration(ShuffleConfiguration shuffleConfiguration, int n2, State state, State state2, char c2) {
            this.prev = shuffleConfiguration;
            this.ca_states = (State[])shuffleConfiguration.ca_states.clone();
            this.a_state = shuffleConfiguration.a_state;
            this.ca_states[n2] = state;
            this.a_state = state2;
            this.min = c2;
            if (!this.surrogate) {
                this.shuffle_suspended = shuffleConfiguration.shuffle_suspended;
                this.suspended1 = shuffleConfiguration.suspended1;
            }
            this.computeHash();
        }

        public boolean equals(Object object) {
            if (object instanceof ShuffleConfiguration) {
                ShuffleConfiguration shuffleConfiguration = (ShuffleConfiguration)object;
                return this.shuffle_suspended == shuffleConfiguration.shuffle_suspended && this.surrogate == shuffleConfiguration.surrogate && this.suspended1 == shuffleConfiguration.suspended1 && Arrays.equals(this.ca_states, shuffleConfiguration.ca_states) && this.a_state == shuffleConfiguration.a_state;
            }
            return false;
        }

        public int hashCode() {
            return this.hash;
        }

        private void computeHash() {
            this.hash = 0;
            for (int i2 = 0; i2 < this.ca_states.length; ++i2) {
                this.hash ^= this.ca_states[i2].hashCode();
            }
            this.hash ^= this.a_state.hashCode() * 100;
            if (this.shuffle_suspended || this.surrogate) {
                this.hash += this.suspended1;
            }
        }
    }
}

