/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.grpc;

import com.contrastsecurity.thirdparty.imm.core.instrument.Counter;
import io.grpc.ForwardingServerCallListener;
import io.grpc.ServerCall;
import io.grpc.Status;
import java.util.function.Consumer;
import java.util.function.Supplier;

class MetricCollectingServerCallListener<Q>
extends ForwardingServerCallListener.SimpleForwardingServerCallListener<Q> {
    private final Counter requestCounter;
    private final Supplier<Status.Code> responseCodeSupplier;
    private final Consumer<Status.Code> responseStatusTiming;

    public MetricCollectingServerCallListener(ServerCall.Listener<Q> listener, Counter counter, Supplier<Status.Code> supplier, Consumer<Status.Code> consumer) {
        super(listener);
        this.requestCounter = counter;
        this.responseCodeSupplier = supplier;
        this.responseStatusTiming = consumer;
    }

    public void onMessage(Q q2) {
        this.requestCounter.increment();
        super.onMessage(q2);
    }

    public void onComplete() {
        this.report(this.responseCodeSupplier.get());
        super.onComplete();
    }

    public void onCancel() {
        this.report(Status.Code.CANCELLED);
        super.onCancel();
    }

    private void report(Status.Code code) {
        this.responseStatusTiming.accept(code);
    }
}

