/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.hystrix;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.HystrixThreadPoolMetrics;
import com.netflix.hystrix.HystrixThreadPoolProperties;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherThreadPool;

@NonNullApi
@NonNullFields
public class MicrometerMetricsPublisherThreadPool
implements HystrixMetricsPublisherThreadPool {
    private static final String NAME_HYSTRIX_THREADPOOL = "hystrix.threadpool";
    private final MeterRegistry meterRegistry;
    private final HystrixThreadPoolMetrics metrics;
    private final HystrixThreadPoolProperties properties;
    private final HystrixMetricsPublisherThreadPool metricsPublisherForThreadPool;
    private final Tags tags;

    public MicrometerMetricsPublisherThreadPool(MeterRegistry meterRegistry, HystrixThreadPoolKey hystrixThreadPoolKey, HystrixThreadPoolMetrics hystrixThreadPoolMetrics, HystrixThreadPoolProperties hystrixThreadPoolProperties, HystrixMetricsPublisherThreadPool hystrixMetricsPublisherThreadPool) {
        this.meterRegistry = meterRegistry;
        this.metrics = hystrixThreadPoolMetrics;
        this.properties = hystrixThreadPoolProperties;
        this.metricsPublisherForThreadPool = hystrixMetricsPublisherThreadPool;
        this.tags = Tags.of("key", hystrixThreadPoolKey.name());
    }

    public void initialize() {
        this.metricsPublisherForThreadPool.initialize();
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("threads.active.current.count"), () -> ((HystrixThreadPoolMetrics)this.metrics).getCurrentActiveCount()).description("The approximate number of threads that are actively executing tasks.").tags(this.tags).register(this.meterRegistry);
        FunctionCounter.builder(MicrometerMetricsPublisherThreadPool.metricName("threads.cumulative.count"), this.metrics, HystrixThreadPoolMetrics::getCumulativeCountThreadsExecuted).description("Cumulative count of number of threads since the start of the application.").tags(this.tags.and(Tag.of("type", "executed"))).register(this.meterRegistry);
        FunctionCounter.builder(MicrometerMetricsPublisherThreadPool.metricName("threads.cumulative.count"), this.metrics, HystrixThreadPoolMetrics::getCumulativeCountThreadsRejected).description("Cumulative count of number of threads since the start of the application.").tags(this.tags.and(Tag.of("type", "rejected"))).register(this.meterRegistry);
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("threads.pool.current.size"), () -> ((HystrixThreadPoolMetrics)this.metrics).getCurrentPoolSize()).description("The current number of threads in the pool.").tags(this.tags).register(this.meterRegistry);
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("threads.largest.pool.current.size"), () -> ((HystrixThreadPoolMetrics)this.metrics).getCurrentLargestPoolSize()).description("The largest number of threads that have ever simultaneously been in the pool.").tags(this.tags).register(this.meterRegistry);
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("threads.max.pool.current.size"), () -> ((HystrixThreadPoolMetrics)this.metrics).getCurrentMaximumPoolSize()).description("The maximum allowed number of threads.").tags(this.tags).register(this.meterRegistry);
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("threads.core.pool.current.size"), () -> ((HystrixThreadPoolMetrics)this.metrics).getCurrentCorePoolSize()).description("The core number of threads.").tags(this.tags).register(this.meterRegistry);
        FunctionCounter.builder(MicrometerMetricsPublisherThreadPool.metricName("tasks.cumulative.count"), this.metrics, hystrixThreadPoolMetrics -> hystrixThreadPoolMetrics.getCurrentCompletedTaskCount().longValue()).description("The approximate total number of tasks since the start of the application.").tags(this.tags.and(Tag.of("type", "completed"))).register(this.meterRegistry);
        FunctionCounter.builder(MicrometerMetricsPublisherThreadPool.metricName("tasks.cumulative.count"), this.metrics, hystrixThreadPoolMetrics -> hystrixThreadPoolMetrics.getCurrentTaskCount().longValue()).description("The approximate total number of tasks since the start of the application.").tags(this.tags.and(Tag.of("type", "scheduled"))).register(this.meterRegistry);
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("queue.current.size"), () -> ((HystrixThreadPoolMetrics)this.metrics).getCurrentQueueSize()).description("Current size of BlockingQueue used by the thread-pool.").tags(this.tags).register(this.meterRegistry);
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("queue.max.size"), () -> (Number)this.properties.maxQueueSize().get()).description("Max size of BlockingQueue used by the thread-pool.").tags(this.tags).register(this.meterRegistry);
        Gauge.builder(MicrometerMetricsPublisherThreadPool.metricName("queue.rejection.threshold.size"), () -> (Number)this.properties.queueSizeRejectionThreshold().get()).description("Artificial max size at which rejections will occur even if maxQueueSize has not been reached.").tags(this.tags).register(this.meterRegistry);
    }

    private static String metricName(String string) {
        return String.join((CharSequence)".", NAME_HYSTRIX_THREADPOOL, string);
    }
}

