/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server;

import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.DefaultJerseyObservationConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyContext;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyObservationConvention;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.jersey.server.JerseyObservationDocumentation;
import com.contrastsecurity.thirdparty.imm.observation.Observation;
import com.contrastsecurity.thirdparty.imm.observation.ObservationRegistry;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.monitoring.RequestEvent;
import org.glassfish.jersey.server.monitoring.RequestEventListener;

public class ObservationRequestEventListener
implements RequestEventListener {
    private final Map<ContainerRequest, ObservationScopeAndContext> observations = Collections.synchronizedMap(new IdentityHashMap());
    private final ObservationRegistry registry;
    private final JerseyObservationConvention customConvention;
    private final String metricName;
    private final JerseyObservationConvention defaultConvention;

    public ObservationRequestEventListener(ObservationRegistry observationRegistry, String string) {
        this(observationRegistry, string, null);
    }

    public ObservationRequestEventListener(ObservationRegistry observationRegistry, String string, JerseyObservationConvention jerseyObservationConvention) {
        this.registry = Objects.requireNonNull(observationRegistry);
        this.metricName = Objects.requireNonNull(string);
        this.customConvention = jerseyObservationConvention;
        this.defaultConvention = new DefaultJerseyObservationConvention(this.metricName);
    }

    public void onEvent(RequestEvent requestEvent) {
        ContainerRequest containerRequest = requestEvent.getContainerRequest();
        switch (requestEvent.getType()) {
            case ON_EXCEPTION: {
                if (!this.isNotFoundException(requestEvent)) break;
            }
            case REQUEST_MATCHED: {
                JerseyContext jerseyContext = new JerseyContext(requestEvent);
                Observation observation = JerseyObservationDocumentation.DEFAULT.start(this.customConvention, this.defaultConvention, () -> jerseyContext, this.registry);
                Observation.Scope scope = observation.openScope();
                this.observations.put(requestEvent.getContainerRequest(), new ObservationScopeAndContext(scope, jerseyContext));
                break;
            }
            case RESP_FILTERS_START: {
                ObservationScopeAndContext observationScopeAndContext = this.observations.get(containerRequest);
                if (observationScopeAndContext == null) break;
                observationScopeAndContext.jerseyContext.setResponse(requestEvent.getContainerResponse());
                observationScopeAndContext.jerseyContext.setRequestEvent(requestEvent);
                break;
            }
            case FINISHED: {
                ObservationScopeAndContext observationScopeAndContext = this.observations.remove(containerRequest);
                if (observationScopeAndContext == null) break;
                observationScopeAndContext.jerseyContext.setRequestEvent(requestEvent);
                Observation.Scope scope = observationScopeAndContext.observationScope;
                scope.close();
                scope.getCurrentObservation().stop();
                break;
            }
        }
    }

    private boolean isNotFoundException(RequestEvent requestEvent) {
        Throwable throwable = requestEvent.getException();
        if (throwable == null) {
            return false;
        }
        String string = throwable.getClass().getCanonicalName();
        return string.equals("jakarta.ws.rs.NotFoundException") || string.equals("javax.ws.rs.NotFoundException");
    }

    private static class ObservationScopeAndContext {
        final Observation.Scope observationScope;
        final JerseyContext jerseyContext;

        ObservationScopeAndContext(Observation.Scope scope, JerseyContext jerseyContext) {
            this.observationScope = scope;
            this.jerseyContext = jerseyContext;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ObservationScopeAndContext observationScopeAndContext = (ObservationScopeAndContext)object;
            return Objects.equals(this.observationScope, observationScopeAndContext.observationScope) && Objects.equals(this.jerseyContext, observationScopeAndContext.jerseyContext);
        }

        public int hashCode() {
            return Objects.hash(this.observationScope, this.jerseyContext);
        }
    }
}

