/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.binder.kafka;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullApi;
import com.contrastsecurity.thirdparty.imm.common.lang.NonNullFields;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLogger;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.InternalLoggerFactory;
import com.contrastsecurity.thirdparty.imm.common.util.internal.logging.WarnThenDebugLogger;
import com.contrastsecurity.thirdparty.imm.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.imm.core.instrument.FunctionCounter;
import com.contrastsecurity.thirdparty.imm.core.instrument.Gauge;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tag;
import com.contrastsecurity.thirdparty.imm.core.instrument.Tags;
import com.contrastsecurity.thirdparty.imm.core.instrument.binder.MeterBinder;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.NamedThreadFactory;
import com.contrastsecurity.thirdparty.oa4j.kafka.common.Metric;
import com.contrastsecurity.thirdparty.oa4j.kafka.common.MetricName;
import com.contrastsecurity.thirdparty.oa4j.kafka.common.metrics.KafkaMetric;
import com.contrastsecurity.thirdparty.oa4j.kafka.common.metrics.Measurable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collectors;

@NonNullApi
@NonNullFields
@Incubating(since="1.4.0")
class KafkaMetrics
implements MeterBinder,
AutoCloseable {
    private static final InternalLogger log = InternalLoggerFactory.getInstance(KafkaMetrics.class);
    private static final WarnThenDebugLogger warnThenDebugLogger = new WarnThenDebugLogger(KafkaMetrics.class);
    static final String METRIC_NAME_PREFIX = "kafka.";
    static final String METRIC_GROUP_APP_INFO = "app-info";
    static final String METRIC_GROUP_METRICS_COUNT = "kafka-metrics-count";
    static final String VERSION_METRIC_NAME = "version";
    static final String START_TIME_METRIC_NAME = "start-time-ms";
    static final Duration DEFAULT_REFRESH_INTERVAL = Duration.ofSeconds(60L);
    static final String KAFKA_VERSION_TAG_NAME = "kafka.version";
    static final String DEFAULT_VALUE = "unknown";
    private static final Set<Class<?>> counterMeasurableClasses = new HashSet();
    private final Supplier<Map<MetricName, ? extends Metric>> metricsSupplier;
    private final AtomicReference<Map<MetricName, ? extends Metric>> metrics = new AtomicReference();
    private final Iterable<Tag> extraTags;
    private final Duration refreshInterval;
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new NamedThreadFactory("micrometer-kafka-metrics"));
    @Nullable
    private Iterable<Tag> commonTags;
    private volatile Set<MetricName> currentMeters = new HashSet<MetricName>();
    private String kafkaVersion = "unknown";
    @Nullable
    private volatile MeterRegistry registry;
    private final Set<Meter.Id> registeredMeterIds = ConcurrentHashMap.newKeySet();

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> supplier) {
        this(supplier, Collections.emptyList());
    }

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> supplier, Iterable<Tag> iterable) {
        this(supplier, iterable, DEFAULT_REFRESH_INTERVAL);
    }

    KafkaMetrics(Supplier<Map<MetricName, ? extends Metric>> supplier, Iterable<Tag> iterable, Duration duration) {
        this.metricsSupplier = supplier;
        this.extraTags = iterable;
        this.refreshInterval = duration;
    }

    @Override
    public void bindTo(MeterRegistry meterRegistry) {
        this.registry = meterRegistry;
        this.commonTags = this.getCommonTags(meterRegistry);
        this.prepareToBindMetrics(meterRegistry);
        this.checkAndBindMetrics(meterRegistry);
        this.scheduler.scheduleAtFixedRate(() -> this.checkAndBindMetrics(meterRegistry), this.getRefreshIntervalInMillis(), this.getRefreshIntervalInMillis(), TimeUnit.MILLISECONDS);
    }

    private Iterable<Tag> getCommonTags(MeterRegistry meterRegistry) {
        Meter.Id id = Meter.builder("delete.this", Meter.Type.OTHER, Collections.emptyList()).register(meterRegistry).getId();
        meterRegistry.remove(id);
        return id.getTags();
    }

    void prepareToBindMetrics(MeterRegistry meterRegistry) {
        this.metrics.set(this.metricsSupplier.get());
        Map<MetricName, ? extends Metric> map = this.metrics.get();
        Metric metric = null;
        for (Map.Entry<MetricName, ? extends Metric> entry : map.entrySet()) {
            MetricName metricName = entry.getKey();
            if (!METRIC_GROUP_APP_INFO.equals(metricName.group())) continue;
            if (VERSION_METRIC_NAME.equals(metricName.name())) {
                this.kafkaVersion = (String)entry.getValue().metricValue();
                continue;
            }
            if (!START_TIME_METRIC_NAME.equals(metricName.name())) continue;
            metric = entry.getValue();
        }
        if (metric != null) {
            MetricName metricName = metric.metricName();
            this.bindMeter(meterRegistry, metric, this.meterName(metricName), this.meterTags(metricName));
        }
    }

    private long getRefreshIntervalInMillis() {
        return this.refreshInterval.toMillis();
    }

    void checkAndBindMetrics(MeterRegistry meterRegistry) {
        try {
            Map<MetricName, ? extends Metric> map = this.metricsSupplier.get();
            this.metrics.set(map);
            if (!this.currentMeters.equals(map.keySet())) {
                Set set = this.currentMeters.stream().filter(metricName -> !map.containsKey(metricName)).collect(Collectors.toSet());
                for (MetricName metricName2 : set) {
                    Meter.Id id = this.meterIdForComparison(metricName2);
                    meterRegistry.remove(id);
                    this.registeredMeterIds.remove(id);
                }
                this.currentMeters = new HashSet<MetricName>(map.keySet());
                Map<String, List<Meter>> map2 = meterRegistry.getMeters().stream().collect(Collectors.groupingBy(meter -> meter.getId().getName()));
                map.forEach((metricName, metric) -> {
                    Object object;
                    Object object22;
                    if (!(metric.metricValue() instanceof Number) || METRIC_GROUP_APP_INFO.equals(metricName.group()) || METRIC_GROUP_METRICS_COUNT.equals(metricName.group())) {
                        return;
                    }
                    String string2 = this.meterName((MetricName)metricName);
                    boolean bl2 = false;
                    for (Object object22 : map2.getOrDefault(string2, Collections.emptyList())) {
                        object = object22.getId();
                        List<Tag> list = ((Meter.Id)object).getTags();
                        List<Tag> list2 = this.meterTags((MetricName)metricName, true);
                        if (list.size() < list2.size()) {
                            meterRegistry.remove((Meter.Id)object);
                            this.registeredMeterIds.remove(object);
                            continue;
                        }
                        if (list.size() == list2.size()) {
                            if (!list.containsAll(list2)) break;
                            return;
                        }
                        bl2 = true;
                    }
                    if (bl2) {
                        return;
                    }
                    List<Tag> list = this.meterTags((MetricName)metricName);
                    try {
                        object22 = this.bindMeter(meterRegistry, (Metric)metric, string2, (Iterable<Tag>)list);
                        object = map2.computeIfAbsent(string2, string -> new ArrayList());
                        object.add(object22);
                    }
                    catch (Exception exception) {
                        Throwables.throwIfCritical(exception);
                        object22 = exception;
                        object = ((Throwable)object22).getMessage();
                        if (object != null && ((String)object).contains("Prometheus requires")) {
                            warnThenDebugLogger.log(() -> "Failed to bind meter: " + string2 + " " + list + ". However, this could happen and might be restored in the next refresh.");
                        }
                        log.warn("Failed to bind meter: " + string2 + " " + list + ".", (Throwable)object22);
                    }
                });
            }
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            log.warn("Failed to bind KafkaMetric", exception2);
        }
    }

    private Meter bindMeter(MeterRegistry meterRegistry, Metric metric, String string, Iterable<Tag> iterable) {
        Meter meter = this.registerMeter(meterRegistry, metric, string, iterable);
        this.registeredMeterIds.add(meter.getId());
        return meter;
    }

    private Meter registerMeter(MeterRegistry meterRegistry, Metric metric, String string, Iterable<Tag> iterable) {
        MetricName metricName = metric.metricName();
        Class<? extends Measurable> clazz = KafkaMetrics.getMeasurableClass(metric);
        if (clazz == null && string.endsWith("total") || clazz != null && counterMeasurableClasses.contains(clazz)) {
            return this.registerCounter(meterRegistry, metricName, string, iterable);
        }
        return this.registerGauge(meterRegistry, metricName, string, iterable);
    }

    @Nullable
    private static Class<? extends Measurable> getMeasurableClass(Metric metric) {
        if (!(metric instanceof KafkaMetric)) {
            return null;
        }
        try {
            return ((KafkaMetric)metric).measurable().getClass();
        }
        catch (IllegalStateException illegalStateException) {
            return null;
        }
    }

    private Gauge registerGauge(MeterRegistry meterRegistry, MetricName metricName, String string, Iterable<Tag> iterable) {
        return Gauge.builder(string, this.metrics, this.toMetricValue(metricName)).tags(iterable).description(metricName.description()).register(meterRegistry);
    }

    private FunctionCounter registerCounter(MeterRegistry meterRegistry, MetricName metricName, String string, Iterable<Tag> iterable) {
        return FunctionCounter.builder(string, this.metrics, this.toMetricValue(metricName)).tags(iterable).description(metricName.description()).register(meterRegistry);
    }

    private ToDoubleFunction<AtomicReference<Map<MetricName, ? extends Metric>>> toMetricValue(MetricName metricName) {
        return atomicReference -> this.toDouble((Metric)((Map)atomicReference.get()).get(metricName));
    }

    private double toDouble(@Nullable Metric metric) {
        return metric != null ? ((Number)metric.metricValue()).doubleValue() : Double.NaN;
    }

    private List<Tag> meterTags(MetricName metricName, boolean bl2) {
        ArrayList<Tag> arrayList = new ArrayList<Tag>();
        metricName.tags().forEach((string, string2) -> arrayList.add(Tag.of(string.replaceAll("-", "."), string2)));
        arrayList.add(Tag.of(KAFKA_VERSION_TAG_NAME, this.kafkaVersion));
        this.extraTags.forEach(arrayList::add);
        if (bl2) {
            this.commonTags.forEach(arrayList::add);
        }
        return arrayList;
    }

    private List<Tag> meterTags(MetricName metricName) {
        return this.meterTags(metricName, false);
    }

    private String meterName(MetricName metricName) {
        String string = METRIC_NAME_PREFIX + metricName.group() + "." + metricName.name();
        return string.replaceAll("-metrics", "").replaceAll("-", ".");
    }

    private Meter.Id meterIdForComparison(MetricName metricName) {
        return new Meter.Id(this.meterName(metricName), Tags.of(this.meterTags(metricName, true)), null, null, Meter.Type.OTHER);
    }

    @Override
    public void close() {
        this.scheduler.shutdownNow();
        for (Meter.Id id : this.registeredMeterIds) {
            this.registry.remove(id);
        }
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("com.contrastsecurity.thirdparty.oa4j.kafka.common.metrics.stats.CumulativeSum");
        hashSet.add("com.contrastsecurity.thirdparty.oa4j.kafka.common.metrics.stats.CumulativeCount");
        for (String string : hashSet) {
            try {
                counterMeasurableClasses.add(Class.forName(string));
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }
}

