/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.config.validate;

import com.contrastsecurity.thirdparty.imm.common.lang.NonNull;
import com.contrastsecurity.thirdparty.imm.common.lang.Nullable;
import com.contrastsecurity.thirdparty.imm.common.util.StringUtils;
import com.contrastsecurity.thirdparty.imm.core.annotation.Incubating;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.validate.InvalidReason;
import com.contrastsecurity.thirdparty.imm.core.instrument.config.validate.ValidationException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@Incubating(since="1.5.0")
public interface Validated<T>
extends Iterable<Validated<T>> {
    public boolean isValid();

    default public boolean isInvalid() {
        return !this.isValid();
    }

    default public List<Invalid<?>> failures() {
        return StreamSupport.stream(this.spliterator(), false).filter(Validated::isInvalid).map((? super T validated) -> (Invalid)validated).collect(Collectors.toList());
    }

    public static Secret validSecret(String string, String string2) {
        return new Secret(string, string2);
    }

    public static <T> None<T> none() {
        return new None();
    }

    public static <T> Valid<T> valid(String string, @Nullable T t2) {
        return new Valid<T>(string, t2);
    }

    public static <T> Invalid<T> invalid(String string, @Nullable Object object, String string2, InvalidReason invalidReason) {
        return Validated.invalid(string, object, string2, invalidReason, null);
    }

    public static <T> Invalid<T> invalid(String string, @Nullable Object object, String string2, InvalidReason invalidReason, @Nullable Throwable throwable) {
        return new Invalid(string, object, string2, invalidReason, throwable);
    }

    default public Validated<?> and(Validated<?> validated) {
        if (this instanceof None) {
            return validated;
        }
        return new Either(this, validated);
    }

    public <U> Validated<U> map(Function<T, U> var1);

    public <U> Validated<U> flatMap(BiFunction<T, Valid<T>, Validated<U>> var1);

    default public <U> Validated<U> flatMap(Function<T, Validated<U>> function) {
        return this.flatMap((T object, Valid<T> valid) -> (Validated)function.apply(object));
    }

    default public Validated<T> invalidateWhen(Predicate<T> predicate, String string, InvalidReason invalidReason) {
        return this.flatMap((T object, Valid<T> valid) -> predicate.test(object) ? Validated.invalid(valid.property, object, string, invalidReason) : valid);
    }

    default public Validated<T> required() {
        return this.invalidateWhen(Objects::isNull, "is required", InvalidReason.MISSING);
    }

    default public Validated<T> nonBlank() {
        return this.invalidateWhen(object -> StringUtils.isBlank(object.toString()), "cannot be blank", InvalidReason.MISSING);
    }

    public T get() throws ValidationException;

    default public T orElse(@Nullable T t2) throws ValidationException {
        return (T)this.orElseGet(() -> t2);
    }

    public T orElseGet(Supplier<T> var1) throws ValidationException;

    public void orThrow() throws ValidationException;

    public static class Secret
    extends Valid<String> {
        public Secret(String string, String string2) {
            super(string, string2);
        }

        @Override
        public String toString() {
            return "Secret{property='" + this.property + '\'' + '}';
        }
    }

    public static class None<T>
    implements Validated<T> {
        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public <U> Validated<U> map(Function<T, U> function) {
            return this;
        }

        @Override
        public <U> Validated<U> flatMap(BiFunction<T, Valid<T>, Validated<U>> biFunction) {
            return this;
        }

        @Override
        public T get() {
            return null;
        }

        @Override
        public T orElseGet(Supplier<T> supplier) {
            return null;
        }

        @Override
        public void orThrow() {
        }

        @Override
        @NonNull
        public Iterator<Validated<T>> iterator() {
            return Collections.emptyIterator();
        }
    }

    public static class Valid<T>
    implements Validated<T> {
        protected final String property;
        private final T value;

        public Valid(String string, T t2) {
            this.property = string;
            this.value = t2;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        @NonNull
        public Iterator<Validated<T>> iterator() {
            return Stream.of(this).iterator();
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void orThrow() {
        }

        @Override
        public T orElseGet(Supplier<T> supplier) {
            return this.value == null ? supplier.get() : this.value;
        }

        @Override
        public <U> Validated<U> map(Function<T, U> function) {
            return new Valid<U>(this.property, function.apply(this.value));
        }

        @Override
        public <U> Validated<U> flatMap(BiFunction<T, Valid<T>, Validated<U>> biFunction) {
            return biFunction.apply(this.value, this);
        }

        public String getProperty() {
            return this.property;
        }

        public String toString() {
            return "Valid{property='" + this.property + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }

    public static class Invalid<T>
    implements Validated<T> {
        private final String property;
        @Nullable
        private final Object value;
        private final String message;
        private final InvalidReason reason;
        @Nullable
        private final Throwable exception;

        public Invalid(String string, @Nullable Object object, String string2, InvalidReason invalidReason, @Nullable Throwable throwable) {
            this.property = string;
            this.value = object;
            this.message = string2;
            this.reason = invalidReason;
            this.exception = throwable;
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        @NonNull
        public Iterator<Validated<T>> iterator() {
            return Stream.of(this).iterator();
        }

        public String getMessage() {
            return this.message;
        }

        public InvalidReason getReason() {
            return this.reason;
        }

        @Nullable
        public Throwable getException() {
            return this.exception;
        }

        @Override
        public T get() throws ValidationException {
            throw new ValidationException(this);
        }

        @Override
        public T orElseGet(Supplier<T> supplier) throws ValidationException {
            throw new ValidationException(this);
        }

        @Override
        public void orThrow() throws ValidationException {
            throw new ValidationException(this);
        }

        @Override
        public <U> Validated<U> map(Function<T, U> function) {
            return this;
        }

        @Override
        public <U> Validated<U> flatMap(BiFunction<T, Valid<T>, Validated<U>> biFunction) {
            return this;
        }

        public String getProperty() {
            return this.property;
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "Invalid{property='" + this.property + '\'' + ", value='" + this.value + '\'' + ", message='" + this.message + '\'' + '}';
        }
    }

    public static class Either
    implements Validated<Object> {
        private final Validated<?> left;
        private final Validated<?> right;

        public Either(Validated<?> validated, Validated<?> validated2) {
            this.left = validated;
            this.right = validated2;
        }

        @Override
        public boolean isValid() {
            return this.left.isValid() && this.right.isValid();
        }

        @Override
        public Object get() {
            throw new UnsupportedOperationException("get not supported on more than one Validated object");
        }

        @Override
        public Object orElseGet(Supplier<Object> supplier) throws ValidationException {
            throw new UnsupportedOperationException("orElse not supported on more than one Validated object");
        }

        @Override
        public void orThrow() throws ValidationException {
            List<Invalid<?>> list = this.failures();
            if (!list.isEmpty()) {
                throw new ValidationException(this);
            }
        }

        @Override
        public <U> Validated<U> map(Function<Object, U> function) {
            throw new UnsupportedOperationException("cannot invoke map on more than one Validated object");
        }

        @Override
        public <U> Validated<U> flatMap(BiFunction<Object, Valid<Object>, Validated<U>> biFunction) {
            throw new UnsupportedOperationException("cannot invoke flatMap on more than one Validated object");
        }

        @Override
        @NonNull
        public Iterator<Validated<Object>> iterator() {
            return Stream.concat(StreamSupport.stream(this.left.spliterator(), false).map((? super T validated) -> validated.map((T object) -> object)), StreamSupport.stream(this.right.spliterator(), false).map((? super T validated) -> validated.map((T object) -> object))).iterator();
        }
    }
}

