/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.internal;

import com.contrastsecurity.thirdparty.imm.core.instrument.MeterRegistry;
import com.contrastsecurity.thirdparty.imm.core.instrument.Timer;
import java.util.concurrent.Callable;

class TimedCallable<V>
implements Callable<V> {
    private final MeterRegistry registry;
    private final Timer executionTimer;
    private final Timer idleTimer;
    private final Callable<V> callable;
    private final Timer.Sample idleSample;

    TimedCallable(MeterRegistry meterRegistry, Timer timer, Timer timer2, Callable<V> callable) {
        this.registry = meterRegistry;
        this.executionTimer = timer;
        this.idleTimer = timer2;
        this.callable = callable;
        this.idleSample = Timer.start(meterRegistry);
    }

    @Override
    public V call() throws Exception {
        this.idleSample.stop(this.idleTimer);
        Timer.Sample sample = Timer.start(this.registry);
        try {
            V v2 = this.callable.call();
            return v2;
        }
        finally {
            sample.stop(this.executionTimer);
        }
    }
}

