/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.step;

import com.contrastsecurity.thirdparty.imm.core.instrument.AbstractTimer;
import com.contrastsecurity.thirdparty.imm.core.instrument.Clock;
import com.contrastsecurity.thirdparty.imm.core.instrument.Meter;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.DistributionStatisticConfig;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.TimeWindowMax;
import com.contrastsecurity.thirdparty.imm.core.instrument.distribution.pause.PauseDetector;
import com.contrastsecurity.thirdparty.imm.core.instrument.step.StepMeter;
import com.contrastsecurity.thirdparty.imm.core.instrument.step.StepTuple2;
import com.contrastsecurity.thirdparty.imm.core.instrument.util.TimeUtils;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public class StepTimer
extends AbstractTimer
implements StepMeter {
    private final LongAdder count = new LongAdder();
    private final LongAdder total = new LongAdder();
    private final StepTuple2<Long, Long> countTotal;
    private final TimeWindowMax max;

    public StepTimer(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, PauseDetector pauseDetector, TimeUnit timeUnit, long l2, boolean bl2) {
        super(id, clock, distributionStatisticConfig, pauseDetector, timeUnit, bl2);
        this.countTotal = new StepTuple2<Long, Long>(clock, l2, 0L, 0L, this.count::sumThenReset, this.total::sumThenReset);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
    }

    @Override
    protected void recordNonNegative(long l2, TimeUnit timeUnit) {
        long l3 = (long)TimeUtils.convert(l2, timeUnit, TimeUnit.NANOSECONDS);
        this.count.add(1L);
        this.total.add(l3);
        this.max.record((double)l3);
    }

    @Override
    public long count() {
        return this.countTotal.poll1();
    }

    @Override
    public double totalTime(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.countTotal.poll2().longValue(), timeUnit);
    }

    @Override
    public double max(TimeUnit timeUnit) {
        return TimeUtils.nanosToUnit(this.max.poll(), timeUnit);
    }

    @Override
    public void _closingRollover() {
        this.countTotal._closingRollover();
    }
}

