/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public final class DoubleFormat {
    private static final ThreadLocal<NumberFormat> DECIMAL_OR_NAN = ThreadLocal.withInitial(() -> {
        NumberFormat numberFormat = NumberFormat.getInstance(Locale.US);
        numberFormat.setGroupingUsed(false);
        numberFormat.setMaximumFractionDigits(6);
        if (numberFormat instanceof DecimalFormat) {
            DecimalFormat decimalFormat = (DecimalFormat)numberFormat;
            DecimalFormatSymbols decimalFormatSymbols = decimalFormat.getDecimalFormatSymbols();
            decimalFormatSymbols.setNaN("NaN");
            decimalFormat.setDecimalFormatSymbols(decimalFormatSymbols);
        }
        return numberFormat;
    });
    private static final ThreadLocal<DecimalFormat> WHOLE_OR_DECIMAL = ThreadLocal.withInitial(() -> {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        return new DecimalFormat("##0.######", decimalFormatSymbols);
    });
    private static final ThreadLocal<DecimalFormat> DECIMAL = ThreadLocal.withInitial(() -> {
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols(Locale.US);
        return new DecimalFormat("##0.0#####", decimalFormatSymbols);
    });

    private DoubleFormat() {
    }

    public static String decimalOrNan(double d2) {
        return DECIMAL_OR_NAN.get().format(d2);
    }

    @Deprecated
    public static String decimalOrWhole(double d2) {
        return WHOLE_OR_DECIMAL.get().format(d2);
    }

    public static String decimal(double d2) {
        return DECIMAL.get().format(d2);
    }

    public static String wholeOrDecimal(double d2) {
        return WHOLE_OR_DECIMAL.get().format(d2);
    }
}

