/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.imm.core.instrument.util;

import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public final class TimeUtils {
    private static final Pattern PARSE_PATTERN = Pattern.compile("[,_ ]");
    private static final long C0 = 1L;
    private static final long C1 = 1000L;
    private static final long C2 = 1000000L;
    private static final long C3 = 1000000000L;
    private static final long C4 = 60000000000L;
    private static final long C5 = 3600000000000L;
    private static final long C6 = 86400000000000L;

    private TimeUtils() {
    }

    public static double convert(double d2, TimeUnit timeUnit, TimeUnit timeUnit2) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return TimeUtils.nanosToUnit(d2, timeUnit2);
            }
            case MICROSECONDS: {
                return TimeUtils.microsToUnit(d2, timeUnit2);
            }
            case MILLISECONDS: {
                return TimeUtils.millisToUnit(d2, timeUnit2);
            }
            case SECONDS: {
                return TimeUtils.secondsToUnit(d2, timeUnit2);
            }
            case MINUTES: {
                return TimeUtils.minutesToUnit(d2, timeUnit2);
            }
            case HOURS: {
                return TimeUtils.hoursToUnit(d2, timeUnit2);
            }
        }
        return TimeUtils.daysToUnit(d2, timeUnit2);
    }

    public static double nanosToUnit(double d2, TimeUnit timeUnit) {
        switch (timeUnit) {
            default: {
                return d2;
            }
            case MICROSECONDS: {
                return d2 / 1000.0;
            }
            case MILLISECONDS: {
                return d2 / 1000000.0;
            }
            case SECONDS: {
                return d2 / 1.0E9;
            }
            case MINUTES: {
                return d2 / 6.0E10;
            }
            case HOURS: {
                return d2 / 3.6E12;
            }
            case DAYS: 
        }
        return d2 / 8.64E13;
    }

    public static double microsToUnit(double d2, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return d2 * 1000.0;
            }
            default: {
                return d2;
            }
            case MILLISECONDS: {
                return d2 / 1000.0;
            }
            case SECONDS: {
                return d2 / 1000000.0;
            }
            case MINUTES: {
                return d2 / 6.0E7;
            }
            case HOURS: {
                return d2 / 3.6E9;
            }
            case DAYS: 
        }
        return d2 / 8.64E10;
    }

    public static double millisToUnit(double d2, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return d2 * 1000000.0;
            }
            case MICROSECONDS: {
                return d2 * 1000.0;
            }
            default: {
                return d2;
            }
            case SECONDS: {
                return d2 / 1000.0;
            }
            case MINUTES: {
                return d2 / 60000.0;
            }
            case HOURS: {
                return d2 / 3600000.0;
            }
            case DAYS: 
        }
        return d2 / 8.64E7;
    }

    public static double secondsToUnit(double d2, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return d2 * 1.0E9;
            }
            case MICROSECONDS: {
                return d2 * 1000000.0;
            }
            case MILLISECONDS: {
                return d2 * 1000.0;
            }
            default: {
                return d2;
            }
            case MINUTES: {
                return d2 / 60.0;
            }
            case HOURS: {
                return d2 / 3600.0;
            }
            case DAYS: 
        }
        return d2 / 86400.0;
    }

    public static double minutesToUnit(double d2, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return d2 * 6.0E10;
            }
            case MICROSECONDS: {
                return d2 * 6.0E7;
            }
            case MILLISECONDS: {
                return d2 * 60000.0;
            }
            case SECONDS: {
                return d2 * 60.0;
            }
            default: {
                return d2;
            }
            case HOURS: {
                return d2 / 60.0;
            }
            case DAYS: 
        }
        return d2 / 1440.0;
    }

    public static double hoursToUnit(double d2, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return d2 * 3.6E12;
            }
            case MICROSECONDS: {
                return d2 * 3.6E9;
            }
            case MILLISECONDS: {
                return d2 * 3600000.0;
            }
            case SECONDS: {
                return d2 * 3600.0;
            }
            case MINUTES: {
                return d2 * 60.0;
            }
            default: {
                return d2;
            }
            case DAYS: 
        }
        return d2 / 24.0;
    }

    public static double daysToUnit(double d2, TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return d2 * 8.64E13;
            }
            case MICROSECONDS: {
                return d2 * 8.64E10;
            }
            case MILLISECONDS: {
                return d2 * 8.64E7;
            }
            case SECONDS: {
                return d2 * 86400.0;
            }
            case MINUTES: {
                return d2 * 1440.0;
            }
            case HOURS: {
                return d2 * 24.0;
            }
        }
        return d2;
    }

    @Deprecated
    public static Duration simpleParse(String string) {
        String string2 = PARSE_PATTERN.matcher(string.toLowerCase()).replaceAll("");
        if (string2.endsWith("ns")) {
            return Duration.ofNanos(Long.parseLong(string2.substring(0, string2.length() - 2)));
        }
        if (string2.endsWith("ms")) {
            return Duration.ofMillis(Long.parseLong(string2.substring(0, string2.length() - 2)));
        }
        if (string2.endsWith("s")) {
            return Duration.ofSeconds(Long.parseLong(string2.substring(0, string2.length() - 1)));
        }
        if (string2.endsWith("m")) {
            return Duration.ofMinutes(Long.parseLong(string2.substring(0, string2.length() - 1)));
        }
        if (string2.endsWith("h")) {
            return Duration.ofHours(Long.parseLong(string2.substring(0, string2.length() - 1)));
        }
        if (string2.endsWith("d")) {
            return Duration.of(Long.parseLong(string2.substring(0, string2.length() - 1)), ChronoUnit.DAYS);
        }
        throw new DateTimeParseException("Unable to parse " + string + " into duration", string2, 0);
    }

    public static String format(Duration duration) {
        int n2 = (int)(duration.toMillis() / 1000L);
        int n3 = n2 % 60;
        int n4 = n2 / 60;
        int n5 = n4 % 60;
        int n6 = n4 / 60;
        StringBuilder stringBuilder = new StringBuilder();
        if (n6 > 0) {
            stringBuilder.append(n6);
            stringBuilder.append('h');
        }
        if (n5 > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(n5);
            stringBuilder.append('m');
        }
        int n7 = duration.getNano();
        if (n3 > 0 || n7 > 0) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(n3);
            if (n7 > 0) {
                stringBuilder.append('.');
                stringBuilder.append(String.format("%09d", n7).replaceFirst("0+$", ""));
            }
            stringBuilder.append('s');
        }
        return stringBuilder.toString();
    }
}

