/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.exporter.otlp.internal;

import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.trace.OtlpHttpSpanExporter;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.http.trace.OtlpHttpSpanExporterBuilder;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.internal.OtlpConfigUtil;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.trace.OtlpGrpcSpanExporter;
import com.contrastsecurity.thirdparty.iot.exporter.otlp.trace.OtlpGrpcSpanExporterBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.autoconfigure.spi.ConfigProperties;
import com.contrastsecurity.thirdparty.iot.sdk.autoconfigure.spi.ConfigurationException;
import com.contrastsecurity.thirdparty.iot.sdk.autoconfigure.spi.traces.ConfigurableSpanExporterProvider;
import com.contrastsecurity.thirdparty.iot.sdk.trace.export.SpanExporter;

public class OtlpSpanExporterProvider
implements ConfigurableSpanExporterProvider {
    @Override
    public SpanExporter createExporter(ConfigProperties configProperties) {
        String string = OtlpConfigUtil.getOtlpProtocol("traces", configProperties);
        if (string.equals("http/protobuf")) {
            OtlpHttpSpanExporterBuilder otlpHttpSpanExporterBuilder = this.httpBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", configProperties, otlpHttpSpanExporterBuilder::setEndpoint, otlpHttpSpanExporterBuilder::addHeader, otlpHttpSpanExporterBuilder::setCompression, otlpHttpSpanExporterBuilder::setTimeout, otlpHttpSpanExporterBuilder::setTrustedCertificates, otlpHttpSpanExporterBuilder::setClientTls, otlpHttpSpanExporterBuilder::setRetryPolicy);
            return otlpHttpSpanExporterBuilder.build();
        }
        if (string.equals("grpc")) {
            OtlpGrpcSpanExporterBuilder otlpGrpcSpanExporterBuilder = this.grpcBuilder();
            OtlpConfigUtil.configureOtlpExporterBuilder("traces", configProperties, otlpGrpcSpanExporterBuilder::setEndpoint, otlpGrpcSpanExporterBuilder::addHeader, otlpGrpcSpanExporterBuilder::setCompression, otlpGrpcSpanExporterBuilder::setTimeout, otlpGrpcSpanExporterBuilder::setTrustedCertificates, otlpGrpcSpanExporterBuilder::setClientTls, otlpGrpcSpanExporterBuilder::setRetryPolicy);
            return otlpGrpcSpanExporterBuilder.build();
        }
        throw new ConfigurationException("Unsupported OTLP traces protocol: " + string);
    }

    @Override
    public String getName() {
        return "otlp";
    }

    OtlpHttpSpanExporterBuilder httpBuilder() {
        return OtlpHttpSpanExporter.builder();
    }

    OtlpGrpcSpanExporterBuilder grpcBuilder() {
        return OtlpGrpcSpanExporter.builder();
    }
}

