/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.internal;

import com.contrastsecurity.thirdparty.iot.api.common.AttributeKey;
import com.contrastsecurity.thirdparty.iot.api.common.Attributes;
import com.contrastsecurity.thirdparty.iot.api.common.AttributesBuilder;
import com.contrastsecurity.thirdparty.iot.sdk.internal.AttributeUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;

public final class AttributesMap
extends HashMap<AttributeKey<?>, Object>
implements Attributes {
    private static final long serialVersionUID = -5072696312123632376L;
    private final long capacity;
    private final int lengthLimit;
    private int totalAddedValues = 0;

    private AttributesMap(long l2, int n2) {
        this.capacity = l2;
        this.lengthLimit = n2;
    }

    public static AttributesMap create(long l2, int n2) {
        return new AttributesMap(l2, n2);
    }

    @Override
    public <T> void put(AttributeKey<T> attributeKey, T t2) {
        ++this.totalAddedValues;
        if ((long)this.size() >= this.capacity && !this.containsKey(attributeKey)) {
            return;
        }
        super.put(attributeKey, AttributeUtil.applyAttributeLengthLimit(t2, this.lengthLimit));
    }

    public int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    @Override
    @Nullable
    public <T> T get(AttributeKey<T> attributeKey) {
        return (T)super.get(attributeKey);
    }

    @Override
    public Map<AttributeKey<?>, Object> asMap() {
        return Collections.unmodifiableMap(this);
    }

    @Override
    public AttributesBuilder toBuilder() {
        return Attributes.builder().putAll(this);
    }

    @Override
    public void forEach(BiConsumer<? super AttributeKey<?>, ? super Object> biConsumer) {
        super.forEach(biConsumer);
    }

    @Override
    public String toString() {
        return "AttributesMap{data=" + super.toString() + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    public Attributes immutableCopy() {
        return Attributes.builder().putAll(this).build();
    }
}

