/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.iot.sdk.logs.export;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.agent.logging.log4j2.e;
import com.contrastsecurity.thirdparty.iot.context.Context;
import com.contrastsecurity.thirdparty.iot.sdk.common.CompletableResultCode;
import com.contrastsecurity.thirdparty.iot.sdk.logs.LogRecordProcessor;
import com.contrastsecurity.thirdparty.iot.sdk.logs.ReadWriteLogRecord;
import com.contrastsecurity.thirdparty.iot.sdk.logs.data.LogRecordData;
import com.contrastsecurity.thirdparty.iot.sdk.logs.export.LogRecordExporter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public final class SimpleLogRecordProcessor
implements LogRecordProcessor {
    private static final e logger = e.a(SimpleLogRecordProcessor.class.getName());
    private final LogRecordExporter logRecordExporter;
    private final Set<CompletableResultCode> pendingExports = Collections.newSetFromMap(new ConcurrentHashMap());
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    public static LogRecordProcessor create(LogRecordExporter logRecordExporter) {
        Objects.requireNonNull(logRecordExporter, "exporter");
        return new SimpleLogRecordProcessor(logRecordExporter);
    }

    private SimpleLogRecordProcessor(LogRecordExporter logRecordExporter) {
        this.logRecordExporter = Objects.requireNonNull(logRecordExporter, "logRecordExporter");
    }

    @Override
    public void onEmit(Context context, ReadWriteLogRecord readWriteLogRecord) {
        try {
            List<LogRecordData> list = Collections.singletonList(readWriteLogRecord.toLogRecordData());
            CompletableResultCode completableResultCode = this.logRecordExporter.export(list);
            this.pendingExports.add(completableResultCode);
            completableResultCode.whenComplete(() -> {
                this.pendingExports.remove(completableResultCode);
                if (!completableResultCode.isSuccess()) {
                    logger.a(e.a.f, "Exporter failed");
                }
            });
        }
        catch (RuntimeException runtimeException) {
            Throwables.throwIfCritical(runtimeException);
            RuntimeException runtimeException2 = runtimeException;
            logger.a(e.a.c, "Exporter threw an Exception", runtimeException2);
        }
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        CompletableResultCode completableResultCode = new CompletableResultCode();
        CompletableResultCode completableResultCode2 = this.forceFlush();
        completableResultCode2.whenComplete(() -> {
            CompletableResultCode completableResultCode3 = this.logRecordExporter.shutdown();
            completableResultCode3.whenComplete(() -> {
                if (!completableResultCode2.isSuccess() || !completableResultCode3.isSuccess()) {
                    completableResultCode.fail();
                } else {
                    completableResultCode.succeed();
                }
            });
        });
        return completableResultCode;
    }

    @Override
    public CompletableResultCode forceFlush() {
        return CompletableResultCode.ofAll(this.pendingExports);
    }

    public String toString() {
        return "SimpleLogRecordProcessor{logRecordExporter=" + this.logRecordExporter + '}';
    }
}

