/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.http.protocol;

import com.contrastsecurity.thirdparty.oa4j.http.HttpException;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequest;
import com.contrastsecurity.thirdparty.oa4j.http.HttpRequestInterceptor;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.Contract;
import com.contrastsecurity.thirdparty.oa4j.http.annotation.ThreadingBehavior;
import com.contrastsecurity.thirdparty.oa4j.http.params.HttpParams;
import com.contrastsecurity.thirdparty.oa4j.http.protocol.HttpContext;
import com.contrastsecurity.thirdparty.oa4j.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestUserAgent
implements HttpRequestInterceptor {
    private final String userAgent;

    public RequestUserAgent(String string) {
        this.userAgent = string;
    }

    public RequestUserAgent() {
        this(null);
    }

    @Override
    public void process(HttpRequest httpRequest, HttpContext httpContext) throws HttpException, IOException {
        Args.notNull(httpRequest, "HTTP request");
        if (!httpRequest.containsHeader("User-Agent")) {
            String string = null;
            HttpParams httpParams = httpRequest.getParams();
            if (httpParams != null) {
                string = (String)httpParams.getParameter("http.useragent");
            }
            if (string == null) {
                string = this.userAgent;
            }
            if (string != null) {
                httpRequest.addHeader("User-Agent", string);
            }
        }
    }
}

