/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Filter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.AbstractOutputStreamAppender;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.OutputStreamManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Property;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.layout.PatternLayout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.CloseShieldOutputStream;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.NullOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

@Plugin(name="OutputStream", category="Core", elementType="appender", printObject=true)
public final class OutputStreamAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    private static OutputStreamManagerFactory factory = new OutputStreamManagerFactory();

    @PluginFactory
    public static OutputStreamAppender createAppender(Layout<? extends Serializable> patternLayout, Filter filter, OutputStream outputStream, String string, boolean bl2, boolean bl3) {
        if (string == null) {
            LOGGER.error("No name provided for OutputStreamAppender");
            return null;
        }
        if (patternLayout == null) {
            patternLayout = PatternLayout.createDefaultLayout();
        }
        return new OutputStreamAppender(string, (Layout<? extends Serializable>)patternLayout, filter, OutputStreamAppender.getManager(outputStream, bl2, patternLayout), bl3, null);
    }

    private static OutputStreamManager getManager(OutputStream outputStream, boolean bl2, Layout<? extends Serializable> layout) {
        OutputStream outputStream2 = outputStream == null ? NullOutputStream.getInstance() : new CloseShieldOutputStream(outputStream);
        OutputStream outputStream3 = outputStream == null ? outputStream2 : outputStream;
        String string = outputStream3.getClass().getName() + "@" + Integer.toHexString(outputStream3.hashCode()) + '.' + bl2;
        return OutputStreamManager.getManager(string, new FactoryData(outputStream2, string, layout), factory);
    }

    @PluginBuilderFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    private OutputStreamAppender(String string, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager outputStreamManager, boolean bl2, Property[] propertyArray) {
        super(string, layout, filter, bl2, true, propertyArray, outputStreamManager);
    }

    private static class OutputStreamManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private OutputStreamManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String string, FactoryData factoryData) {
            return new OutputStreamManager(factoryData.os, factoryData.name, factoryData.layout, true);
        }
    }

    private static class FactoryData {
        private final Layout<? extends Serializable> layout;
        private final String name;
        private final OutputStream os;

        public FactoryData(OutputStream outputStream, String string, Layout<? extends Serializable> layout) {
            this.os = outputStream;
            this.name = string;
            this.layout = layout;
        }
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<OutputStreamAppender> {
        private boolean follow = false;
        private final boolean ignoreExceptions = true;
        private OutputStream target;

        @Override
        public OutputStreamAppender build() {
            Layout<Serializable> layout = this.getOrCreateLayout();
            return new OutputStreamAppender(this.getName(), layout, this.getFilter(), OutputStreamAppender.getManager(this.target, this.follow, layout), true, this.getPropertyArray());
        }

        public B setFollow(boolean bl2) {
            this.follow = bl2;
            return (B)((Builder)this.asBuilder());
        }

        public B setTarget(OutputStream outputStream) {
            this.target = outputStream;
            return (B)((Builder)this.asBuilder());
        }
    }
}

