/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.AbstractRolloverStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.FileExtension;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.PatternProcessor;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.RollingFileManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.RolloverDescription;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.RolloverDescriptionImpl;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.Action;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.CompositeAction;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.FileRenameAction;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.PathCondition;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.PosixViewAttributeAction;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.Configuration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginBuilderFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginConfiguration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginElement;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.PluginFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.lookup.StrSubstitutor;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Integers;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;

@Plugin(name="DirectWriteRolloverStrategy", category="Core", printObject=true)
public class DirectWriteRolloverStrategy
extends AbstractRolloverStrategy
implements DirectFileRolloverStrategy {
    private static final int DEFAULT_MAX_FILES = 7;
    private final int maxFiles;
    private final int compressionLevel;
    private final List<Action> customActions;
    private final boolean stopCustomActionsOnError;
    private volatile String currentFileName;
    private int nextIndex = -1;
    private final PatternProcessor tempCompressedFilePattern;
    private volatile boolean usePrevTime = false;

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    @Deprecated
    @PluginFactory
    public static DirectWriteRolloverStrategy createStrategy(@PluginAttribute(value="maxFiles") String string, @PluginAttribute(value="compressionLevel") String string2, @PluginElement(value="Actions") Action[] actionArray, @PluginAttribute(value="stopCustomActionsOnError", defaultBoolean=true) boolean bl2, @PluginConfiguration Configuration configuration) {
        return DirectWriteRolloverStrategy.newBuilder().withMaxFiles(string).withCompressionLevelStr(string2).withCustomActions(actionArray).withStopCustomActionsOnError(bl2).withConfig(configuration).build();
    }

    @Deprecated
    protected DirectWriteRolloverStrategy(int n2, int n3, StrSubstitutor strSubstitutor, Action[] actionArray, boolean bl2) {
        this(n2, n3, strSubstitutor, actionArray, bl2, null);
    }

    protected DirectWriteRolloverStrategy(int n2, int n3, StrSubstitutor strSubstitutor, Action[] actionArray, boolean bl2, String string) {
        super(strSubstitutor);
        this.maxFiles = n2;
        this.compressionLevel = n3;
        this.stopCustomActionsOnError = bl2;
        this.customActions = actionArray == null ? Collections.emptyList() : Arrays.asList(actionArray);
        this.tempCompressedFilePattern = string != null ? new PatternProcessor(string) : null;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public List<Action> getCustomActions() {
        return this.customActions;
    }

    public int getMaxFiles() {
        return this.maxFiles;
    }

    public boolean isStopCustomActionsOnError() {
        return this.stopCustomActionsOnError;
    }

    public PatternProcessor getTempCompressedFilePattern() {
        return this.tempCompressedFilePattern;
    }

    private int purge(RollingFileManager rollingFileManager) {
        SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager);
        LOGGER.debug("Found {} eligible files, max is  {}", (Object)sortedMap.size(), (Object)this.maxFiles);
        while (sortedMap.size() >= this.maxFiles) {
            try {
                Integer n2 = sortedMap.firstKey();
                Files.delete((Path)sortedMap.get(n2));
                sortedMap.remove(n2);
            }
            catch (IOException iOException) {
                LOGGER.error("Unable to delete {}", (Object)sortedMap.firstKey(), (Object)iOException);
                break;
            }
        }
        return sortedMap.size() > 0 ? sortedMap.lastKey() : 1;
    }

    @Override
    public String getCurrentFileName(RollingFileManager rollingFileManager) {
        if (this.currentFileName == null) {
            String string;
            SortedMap<Integer, Path> sortedMap = this.getEligibleFiles(rollingFileManager);
            int n2 = sortedMap.size() > 0 ? (this.nextIndex > 0 ? this.nextIndex : sortedMap.lastKey()) : 1;
            StringBuilder stringBuilder = new StringBuilder(255);
            rollingFileManager.getPatternProcessor().setCurrentFileTime(System.currentTimeMillis());
            rollingFileManager.getPatternProcessor().formatFileName(this.strSubstitutor, stringBuilder, true, (Object)n2);
            int n3 = this.suffixLength(stringBuilder.toString());
            this.currentFileName = string = n3 > 0 ? stringBuilder.substring(0, stringBuilder.length() - n3) : stringBuilder.toString();
        }
        return this.currentFileName;
    }

    @Override
    public void clearCurrentFileName() {
        this.currentFileName = null;
    }

    @Override
    public RolloverDescription rollover(RollingFileManager rollingFileManager) throws SecurityException {
        Object object;
        String string;
        LOGGER.debug("Rolling " + this.currentFileName);
        if (this.maxFiles < 0) {
            return null;
        }
        long l2 = System.nanoTime();
        int n2 = this.purge(rollingFileManager);
        if (LOGGER.isTraceEnabled()) {
            double d2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - l2);
            LOGGER.trace("DirectWriteRolloverStrategy.purge() took {} milliseconds", (Object)d2);
        }
        Action action = null;
        String string2 = string = this.getCurrentFileName(rollingFileManager);
        this.currentFileName = null;
        this.nextIndex = n2 + 1;
        FileExtension fileExtension = rollingFileManager.getFileExtension();
        if (fileExtension != null) {
            string2 = string2 + fileExtension.getExtension();
            if (this.tempCompressedFilePattern != null) {
                object = new StringBuilder();
                this.tempCompressedFilePattern.formatFileName(this.strSubstitutor, (StringBuilder)object, (Object)n2);
                String string3 = ((StringBuilder)object).toString();
                File file = new File(string3);
                File file2 = file.getParentFile();
                if (file2 != null) {
                    file2.mkdirs();
                }
                action = new CompositeAction(Arrays.asList(fileExtension.createCompressAction(string, string3, true, this.compressionLevel), new FileRenameAction(file, new File(string2), true)), true);
            } else {
                action = fileExtension.createCompressAction(string, string2, true, this.compressionLevel);
            }
        }
        if (action != null && rollingFileManager.isAttributeViewEnabled()) {
            object = PosixViewAttributeAction.newBuilder().withBasePath(string2).withFollowLinks(false).withMaxDepth(1).withPathConditions(PathCondition.EMPTY_ARRAY).withSubst(this.getStrSubstitutor()).withFilePermissions(rollingFileManager.getFilePermissions()).withFileOwner(rollingFileManager.getFileOwner()).withFileGroup(rollingFileManager.getFileGroup()).build();
            action = new CompositeAction(Arrays.asList(action, object), false);
        }
        object = this.merge(action, this.customActions, this.stopCustomActionsOnError);
        return new RolloverDescriptionImpl(string, false, null, (Action)object);
    }

    public String toString() {
        return "DirectWriteRolloverStrategy(maxFiles=" + this.maxFiles + ')';
    }

    public static class Builder
    implements com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.Builder<DirectWriteRolloverStrategy> {
        @PluginBuilderAttribute(value="maxFiles")
        private String maxFiles;
        @PluginBuilderAttribute(value="compressionLevel")
        private String compressionLevelStr;
        @PluginElement(value="Actions")
        private Action[] customActions;
        @PluginBuilderAttribute(value="stopCustomActionsOnError")
        private boolean stopCustomActionsOnError = true;
        @PluginBuilderAttribute(value="tempCompressedFilePattern")
        private String tempCompressedFilePattern;
        @PluginConfiguration
        private Configuration config;

        @Override
        public DirectWriteRolloverStrategy build() {
            int n2 = Integer.MAX_VALUE;
            if (this.maxFiles != null) {
                n2 = Integers.parseInt(this.maxFiles);
                if (n2 < 0) {
                    n2 = Integer.MAX_VALUE;
                } else if (n2 < 2) {
                    AbstractRolloverStrategy.LOGGER.error("Maximum files too small. Limited to 7");
                    n2 = 7;
                }
            }
            int n3 = Integers.parseInt(this.compressionLevelStr, -1);
            return new DirectWriteRolloverStrategy(n2, n3, this.config.getStrSubstitutor(), this.customActions, this.stopCustomActionsOnError, this.tempCompressedFilePattern);
        }

        public String getMaxFiles() {
            return this.maxFiles;
        }

        public Builder withMaxFiles(String string) {
            this.maxFiles = string;
            return this;
        }

        public String getCompressionLevelStr() {
            return this.compressionLevelStr;
        }

        public Builder withCompressionLevelStr(String string) {
            this.compressionLevelStr = string;
            return this;
        }

        public Action[] getCustomActions() {
            return this.customActions;
        }

        public Builder withCustomActions(Action[] actionArray) {
            this.customActions = actionArray;
            return this;
        }

        public boolean isStopCustomActionsOnError() {
            return this.stopCustomActionsOnError;
        }

        public Builder withStopCustomActionsOnError(boolean bl2) {
            this.stopCustomActionsOnError = bl2;
            return this;
        }

        public String getTempCompressedFilePattern() {
            return this.tempCompressedFilePattern;
        }

        public Builder withTempCompressedFilePattern(String string) {
            this.tempCompressedFilePattern = string;
            return this;
        }

        public Configuration getConfig() {
            return this.config;
        }

        public Builder withConfig(Configuration configuration) {
            this.config = configuration;
            return this;
        }
    }
}

