/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FileSize {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final long KB = 1024L;
    private static final long MB = 0x100000L;
    private static final long GB = 0x40000000L;
    private static final long TB = 0x10000000000L;
    private static final Pattern VALUE_PATTERN = Pattern.compile("([0-9]+([.,][0-9]+)?)\\s*(|K|M|G|T)B?", 2);

    private FileSize() {
    }

    public static long parse(String string, long l2) {
        Matcher matcher = VALUE_PATTERN.matcher(string);
        if (matcher.matches()) {
            try {
                String string2 = matcher.group(1);
                double d2 = NumberFormat.getNumberInstance(Locale.ROOT).parse(string2).doubleValue();
                String string3 = matcher.group(3);
                if (string3 == null || string3.isEmpty()) {
                    return (long)d2;
                }
                if (string3.equalsIgnoreCase("K")) {
                    return (long)(d2 * 1024.0);
                }
                if (string3.equalsIgnoreCase("M")) {
                    return (long)(d2 * 1048576.0);
                }
                if (string3.equalsIgnoreCase("G")) {
                    return (long)(d2 * 1.073741824E9);
                }
                if (string3.equalsIgnoreCase("T")) {
                    return (long)(d2 * 1.099511627776E12);
                }
                LOGGER.error("FileSize units not recognized: " + string);
                return l2;
            }
            catch (ParseException parseException) {
                LOGGER.error("FileSize unable to parse numeric part: " + string, (Throwable)parseException);
                return l2;
            }
        }
        LOGGER.error("FileSize unable to parse bytes: " + string);
        return l2;
    }
}

