/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.convert;

import com.contrastsecurity.agent.commons.Throwables;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Logger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.rolling.action.Duration;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.convert.Base64Converter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.convert.HexConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.convert.TypeConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.convert.TypeConverterRegistry;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.util.CronExpression;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusLogger;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Constants;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.LoaderUtil;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Provider;
import java.security.Security;
import java.util.UUID;
import java.util.regex.Pattern;

public final class TypeConverters {
    public static final String CATEGORY = "TypeConverter";
    private static final Logger LOGGER = StatusLogger.getLogger();

    public static <T> T convert(String string, Class<? extends T> clazz, Object object) {
        TypeConverter<?> typeConverter = TypeConverterRegistry.getInstance().findCompatibleConverter(clazz);
        if (string == null) {
            return (T)TypeConverters.parseDefaultValue(typeConverter, object);
        }
        try {
            return (T)typeConverter.convert(string);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.warn("Error while converting string [{}] to type [{}]. Using default value [{}].", (Object)string, (Object)clazz, object, (Object)exception2);
            return (T)TypeConverters.parseDefaultValue(typeConverter, object);
        }
    }

    private static <T> T parseDefaultValue(TypeConverter<T> typeConverter, Object object) {
        if (object == null) {
            return null;
        }
        if (!(object instanceof String)) {
            return (T)object;
        }
        try {
            return typeConverter.convert((String)object);
        }
        catch (Exception exception) {
            Throwables.throwIfCritical(exception);
            Exception exception2 = exception;
            LOGGER.debug("Can't parse default value [{}] for type [{}].", object, (Object)typeConverter.getClass(), (Object)exception2);
            return null;
        }
    }

    @Plugin(name="UUID", category="TypeConverter")
    public static class UuidConverter
    implements TypeConverter<UUID> {
        @Override
        public UUID convert(String string) throws Exception {
            return UUID.fromString(string);
        }
    }

    @Plugin(name="URL", category="TypeConverter")
    public static class UrlConverter
    implements TypeConverter<URL> {
        @Override
        public URL convert(String string) throws MalformedURLException {
            return new URL(string);
        }
    }

    @Plugin(name="URI", category="TypeConverter")
    public static class UriConverter
    implements TypeConverter<URI> {
        @Override
        public URI convert(String string) throws URISyntaxException {
            return new URI(string);
        }
    }

    @Plugin(name="String", category="TypeConverter")
    public static class StringConverter
    implements TypeConverter<String> {
        @Override
        public String convert(String string) {
            return string;
        }
    }

    @Plugin(name="Short", category="TypeConverter")
    public static class ShortConverter
    implements TypeConverter<Short> {
        @Override
        public Short convert(String string) {
            return Short.valueOf(string);
        }
    }

    @Plugin(name="SecurityProvider", category="TypeConverter")
    public static class SecurityProviderConverter
    implements TypeConverter<Provider> {
        @Override
        public Provider convert(String string) {
            return Security.getProvider(string);
        }
    }

    @Plugin(name="Pattern", category="TypeConverter")
    public static class PatternConverter
    implements TypeConverter<Pattern> {
        @Override
        public Pattern convert(String string) {
            return Pattern.compile(string);
        }
    }

    @Plugin(name="Path", category="TypeConverter")
    public static class PathConverter
    implements TypeConverter<Path> {
        @Override
        public Path convert(String string) throws Exception {
            return Paths.get(string, new String[0]);
        }
    }

    @Plugin(name="Long", category="TypeConverter")
    public static class LongConverter
    implements TypeConverter<Long> {
        @Override
        public Long convert(String string) {
            return Long.valueOf(string);
        }
    }

    @Plugin(name="Level", category="TypeConverter")
    public static class LevelConverter
    implements TypeConverter<Level> {
        @Override
        public Level convert(String string) {
            return Level.valueOf(string);
        }
    }

    @Plugin(name="Integer", category="TypeConverter")
    public static class IntegerConverter
    implements TypeConverter<Integer> {
        @Override
        public Integer convert(String string) {
            return Integer.valueOf(string);
        }
    }

    @Plugin(name="InetAddress", category="TypeConverter")
    public static class InetAddressConverter
    implements TypeConverter<InetAddress> {
        @Override
        public InetAddress convert(String string) throws Exception {
            return InetAddress.getByName(string);
        }
    }

    @Plugin(name="Float", category="TypeConverter")
    public static class FloatConverter
    implements TypeConverter<Float> {
        @Override
        public Float convert(String string) {
            return Float.valueOf(string);
        }
    }

    @Plugin(name="File", category="TypeConverter")
    public static class FileConverter
    implements TypeConverter<File> {
        @Override
        public File convert(String string) {
            return new File(string);
        }
    }

    @Plugin(name="Duration", category="TypeConverter")
    public static class DurationConverter
    implements TypeConverter<Duration> {
        @Override
        public Duration convert(String string) {
            return Duration.parse(string);
        }
    }

    @Plugin(name="Double", category="TypeConverter")
    public static class DoubleConverter
    implements TypeConverter<Double> {
        @Override
        public Double convert(String string) {
            return Double.valueOf(string);
        }
    }

    @Plugin(name="CronExpression", category="TypeConverter")
    public static class CronExpressionConverter
    implements TypeConverter<CronExpression> {
        @Override
        public CronExpression convert(String string) throws Exception {
            return new CronExpression(string);
        }
    }

    @Plugin(name="Class", category="TypeConverter")
    public static class ClassConverter
    implements TypeConverter<Class<?>> {
        @Override
        public Class<?> convert(String string) throws ClassNotFoundException {
            switch (string.toLowerCase()) {
                case "boolean": {
                    return Boolean.TYPE;
                }
                case "byte": {
                    return Byte.TYPE;
                }
                case "char": {
                    return Character.TYPE;
                }
                case "double": {
                    return Double.TYPE;
                }
                case "float": {
                    return Float.TYPE;
                }
                case "int": {
                    return Integer.TYPE;
                }
                case "long": {
                    return Long.TYPE;
                }
                case "short": {
                    return Short.TYPE;
                }
                case "void": {
                    return Void.TYPE;
                }
            }
            return LoaderUtil.loadClass(string);
        }
    }

    @Plugin(name="Charset", category="TypeConverter")
    public static class CharsetConverter
    implements TypeConverter<Charset> {
        @Override
        public Charset convert(String string) {
            return Charset.forName(string);
        }
    }

    @Plugin(name="CharacterArray", category="TypeConverter")
    public static class CharArrayConverter
    implements TypeConverter<char[]> {
        @Override
        public char[] convert(String string) {
            return string.toCharArray();
        }
    }

    @Plugin(name="Character", category="TypeConverter")
    public static class CharacterConverter
    implements TypeConverter<Character> {
        @Override
        public Character convert(String string) {
            if (string.length() != 1) {
                throw new IllegalArgumentException("Character string must be of length 1: " + string);
            }
            return Character.valueOf(string.toCharArray()[0]);
        }
    }

    @Plugin(name="Byte", category="TypeConverter")
    public static class ByteConverter
    implements TypeConverter<Byte> {
        @Override
        public Byte convert(String string) {
            return Byte.valueOf(string);
        }
    }

    @Plugin(name="ByteArray", category="TypeConverter")
    public static class ByteArrayConverter
    implements TypeConverter<byte[]> {
        private static final String PREFIX_0x = "0x";
        private static final String PREFIX_BASE64 = "Base64:";

        @Override
        public byte[] convert(String string) {
            byte[] byArray;
            if (string == null || string.isEmpty()) {
                byArray = Constants.EMPTY_BYTE_ARRAY;
            } else if (string.startsWith(PREFIX_BASE64)) {
                String string2 = string.substring(PREFIX_BASE64.length());
                byArray = Base64Converter.parseBase64Binary(string2);
            } else if (string.startsWith(PREFIX_0x)) {
                String string3 = string.substring(PREFIX_0x.length());
                byArray = HexConverter.parseHexBinary(string3);
            } else {
                byArray = string.getBytes(Charset.defaultCharset());
            }
            return byArray;
        }
    }

    @Plugin(name="Boolean", category="TypeConverter")
    public static class BooleanConverter
    implements TypeConverter<Boolean> {
        @Override
        public Boolean convert(String string) {
            return Boolean.valueOf(string);
        }
    }

    @Plugin(name="BigInteger", category="TypeConverter")
    public static class BigIntegerConverter
    implements TypeConverter<BigInteger> {
        @Override
        public BigInteger convert(String string) {
            return new BigInteger(string);
        }
    }

    @Plugin(name="BigDecimal", category="TypeConverter")
    public static class BigDecimalConverter
    implements TypeConverter<BigDecimal> {
        @Override
        public BigDecimal convert(String string) {
            return new BigDecimal(string);
        }
    }
}

