/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.Layout;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.appender.ManagerFactory;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.AbstractSocketManager;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.net.DatagramOutputStream;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.Strings;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class DatagramSocketManager
extends AbstractSocketManager {
    private static final DatagramSocketManagerFactory FACTORY = new DatagramSocketManagerFactory();

    protected DatagramSocketManager(String string, OutputStream outputStream, InetAddress inetAddress, String string2, int n2, Layout<? extends Serializable> layout, int n3) {
        super(string, outputStream, inetAddress, string2, n2, layout, true, n3);
    }

    public static DatagramSocketManager getSocketManager(String string, int n2, Layout<? extends Serializable> layout, int n3) {
        if (Strings.isEmpty(string)) {
            throw new IllegalArgumentException("A host name is required");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("A port value is required");
        }
        return (DatagramSocketManager)DatagramSocketManager.getManager("UDP:" + string + ':' + n2, new FactoryData(string, n2, layout, n3), FACTORY);
    }

    @Override
    public Map<String, String> getContentFormat() {
        HashMap<String, String> hashMap = new HashMap<String, String>(super.getContentFormat());
        hashMap.put("protocol", "udp");
        hashMap.put("direction", "out");
        return hashMap;
    }

    private static class DatagramSocketManagerFactory
    implements ManagerFactory<DatagramSocketManager, FactoryData> {
        private DatagramSocketManagerFactory() {
        }

        @Override
        public DatagramSocketManager createManager(String string, FactoryData factoryData) {
            InetAddress inetAddress;
            try {
                inetAddress = InetAddress.getByName(factoryData.host);
            }
            catch (UnknownHostException unknownHostException) {
                LOGGER.error("Could not find address of " + factoryData.host, (Throwable)unknownHostException);
                return null;
            }
            DatagramOutputStream datagramOutputStream = new DatagramOutputStream(factoryData.host, factoryData.port, factoryData.layout.getHeader(), factoryData.layout.getFooter());
            return new DatagramSocketManager(string, (OutputStream)datagramOutputStream, inetAddress, factoryData.host, factoryData.port, factoryData.layout, factoryData.bufferSize);
        }
    }

    private static class FactoryData {
        private final String host;
        private final int port;
        private final Layout<? extends Serializable> layout;
        private final int bufferSize;

        public FactoryData(String string, int n2, Layout<? extends Serializable> layout, int n3) {
            this.host = string;
            this.port = n2;
            this.layout = layout;
            this.bufferSize = n3;
        }
    }
}

