/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.LogEvent;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.config.plugins.Plugin;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.ConverterKeys;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.core.pattern.LogEventPatternConverter;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.PerformanceSensitive;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.ReadOnlyStringMap;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.StringBuilders;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.util.TriConsumer;

@Plugin(name="MdcPatternConverter", category="Converter")
@ConverterKeys(value={"X", "mdc", "MDC"})
@PerformanceSensitive(value={"allocation"})
public final class MdcPatternConverter
extends LogEventPatternConverter {
    private final String key;
    private final String[] keys;
    private final boolean full;
    private static final TriConsumer<String, Object, StringBuilder> WRITE_KEY_VALUES_INTO = (string, object, stringBuilder) -> {
        stringBuilder.append((String)string).append('=');
        StringBuilders.appendValue(stringBuilder, object);
        stringBuilder.append(", ");
    };

    private MdcPatternConverter(String[] stringArray) {
        super(stringArray != null && stringArray.length > 0 ? "MDC{" + stringArray[0] + '}' : "MDC", "mdc");
        if (stringArray != null && stringArray.length > 0) {
            this.full = false;
            if (stringArray[0].indexOf(44) > 0) {
                this.keys = stringArray[0].split(",");
                for (int i2 = 0; i2 < this.keys.length; ++i2) {
                    this.keys[i2] = this.keys[i2].trim();
                }
                this.key = null;
            } else {
                this.keys = null;
                this.key = stringArray[0];
            }
        } else {
            this.full = true;
            this.key = null;
            this.keys = null;
        }
    }

    public static MdcPatternConverter newInstance(String[] stringArray) {
        return new MdcPatternConverter(stringArray);
    }

    @Override
    public void format(LogEvent logEvent, StringBuilder stringBuilder) {
        Object v2;
        ReadOnlyStringMap readOnlyStringMap = logEvent.getContextData();
        if (this.full) {
            if (readOnlyStringMap == null || readOnlyStringMap.isEmpty()) {
                stringBuilder.append("{}");
                return;
            }
            MdcPatternConverter.appendFully(readOnlyStringMap, stringBuilder);
        } else if (this.keys != null) {
            if (readOnlyStringMap == null || readOnlyStringMap.isEmpty()) {
                stringBuilder.append("{}");
                return;
            }
            MdcPatternConverter.appendSelectedKeys(this.keys, readOnlyStringMap, stringBuilder);
        } else if (readOnlyStringMap != null && (v2 = readOnlyStringMap.getValue(this.key)) != null) {
            StringBuilders.appendValue(stringBuilder, v2);
        }
    }

    private static void appendFully(ReadOnlyStringMap readOnlyStringMap, StringBuilder stringBuilder) {
        stringBuilder.append("{");
        int n2 = stringBuilder.length();
        readOnlyStringMap.forEach(WRITE_KEY_VALUES_INTO, stringBuilder);
        int n3 = stringBuilder.length();
        if (n3 > n2) {
            stringBuilder.setCharAt(n3 - 2, '}');
            stringBuilder.deleteCharAt(n3 - 1);
        } else {
            stringBuilder.append('}');
        }
    }

    private static void appendSelectedKeys(String[] stringArray, ReadOnlyStringMap readOnlyStringMap, StringBuilder stringBuilder) {
        int n2 = stringBuilder.length();
        stringBuilder.append('{');
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            Object v2 = readOnlyStringMap.getValue(string);
            if (v2 == null) continue;
            if (stringBuilder.length() - n2 > 1) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(string).append('=');
            StringBuilders.appendValue(stringBuilder, v2);
        }
        stringBuilder.append('}');
    }
}

