/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.status;

import com.contrastsecurity.thirdparty.oa4j.logging.log4j.Level;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusData;
import com.contrastsecurity.thirdparty.oa4j.logging.log4j.status.StatusListener;
import java.io.IOException;
import java.io.PrintStream;

public class StatusConsoleListener
implements StatusListener {
    private Level level = Level.FATAL;
    private String[] filters;
    private final PrintStream stream;

    public StatusConsoleListener(Level level) {
        this(level, System.out);
    }

    public StatusConsoleListener(Level level, PrintStream printStream) {
        if (printStream == null) {
            throw new IllegalArgumentException("You must provide a stream to use for this listener.");
        }
        this.level = level;
        this.stream = printStream;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    @Override
    public Level getStatusLevel() {
        return this.level;
    }

    @Override
    public void log(StatusData statusData) {
        if (!this.filtered(statusData)) {
            this.stream.println(statusData.getFormattedStatus());
        }
    }

    public void setFilters(String ... stringArray) {
        this.filters = stringArray;
    }

    private boolean filtered(StatusData statusData) {
        if (this.filters == null) {
            return false;
        }
        String string = statusData.getStackTraceElement().getClassName();
        for (String string2 : this.filters) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != System.out && this.stream != System.err) {
            this.stream.close();
        }
    }
}

