/*
 * Decompiled with CFR 0.152.
 */
package com.contrastsecurity.thirdparty.oa4j.logging.log4j.util;

import com.contrastsecurity.agent.commons.Throwables;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;

final class PrivateSecurityManagerStackTraceUtil {
    private static final PrivateSecurityManager SECURITY_MANAGER;

    private PrivateSecurityManagerStackTraceUtil() {
    }

    static boolean isEnabled() {
        return SECURITY_MANAGER != null;
    }

    static Deque<Class<?>> getCurrentStackTrace() {
        Class<?>[] classArray = SECURITY_MANAGER.getClassContext();
        ArrayDeque arrayDeque = new ArrayDeque(classArray.length);
        Collections.addAll(arrayDeque, classArray);
        return arrayDeque;
    }

    static {
        PrivateSecurityManager privateSecurityManager;
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("createSecurityManager"));
            }
            privateSecurityManager = new PrivateSecurityManager();
        }
        catch (SecurityException securityException) {
            Throwables.throwIfCritical(securityException);
            SecurityException securityException2 = securityException;
            privateSecurityManager = null;
        }
        SECURITY_MANAGER = privateSecurityManager;
    }

    private static final class PrivateSecurityManager
    extends SecurityManager {
        private PrivateSecurityManager() {
        }

        @Override
        protected Class<?>[] getClassContext() {
            return super.getClassContext();
        }
    }
}

